/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.dbinom;
import org.renjin.nmath.dpois;
import org.renjin.nmath.fmax2;
import org.renjin.nmath.lgamma;

public class dnbinom {
    private dnbinom() {
    }

    public static double dnbinom_mu(double x, double size, double mu, int log_p) {
        double d;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(size) || Double.isNaN(size) || Double.isNaN(mu) || Double.isNaN(mu)) {
            d = x + size + mu;
        } else if (mu < 0.0 || size < 0.0) {
            d = 0.0 / 0.0;
        } else {
            double d2 = Mathlib.round((double)x);
            double d3 = Math.abs(x - d2);
            double d4 = Math.abs(x);
            double d5 = fmax2.fmax2(1.0, d4) * 1.0E-7;
            if (d3 > d5) {
                Stdlib.printf((BytePtr)new BytePtr("non-integer x = %f\u0000".getBytes(), 0), (Object[])new Object[]{x});
                double iftmp$0 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                d = iftmp$0;
            } else if (x < 0.0 || !(Math.abs(x) <= Double.MAX_VALUE)) {
                double iftmp$1 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                d = iftmp$1;
            } else if (x == 0.0 && size == 0.0) {
                double iftmp$2 = log_p != 0 ? 0.0 : 1.0;
                d = iftmp$2;
            } else {
                x = Mathlib.round((double)x);
                if (!(Math.abs(size) <= Double.MAX_VALUE)) {
                    d = dpois.dpois_raw(x, mu, log_p);
                } else if (x == 0.0) {
                    double iftmp$3;
                    if (log_p != 0) {
                        double iftmp$4;
                        if (size < mu) {
                            double d6 = size + mu;
                            iftmp$4 = Mathlib.log((double)(size / d6));
                        } else {
                            double d7 = -mu;
                            double d8 = size + mu;
                            iftmp$4 = Mathlib.log1p((double)(d7 / d8));
                        }
                        iftmp$3 = iftmp$4 * size;
                    } else {
                        double iftmp$5;
                        if (size < mu) {
                            double d9 = size + mu;
                            iftmp$5 = Mathlib.log((double)(size / d9));
                        } else {
                            double d10 = -mu;
                            double d11 = size + mu;
                            iftmp$5 = Mathlib.log1p((double)(d10 / d11));
                        }
                        iftmp$3 = Mathlib.exp((double)(iftmp$5 * size));
                    }
                    d = iftmp$3;
                } else if (size * 1.0E-10 > x) {
                    double iftmp$7;
                    double iftmp$6;
                    if (size < mu) {
                        double d12 = size / mu + 1.0;
                        iftmp$6 = Mathlib.log((double)(size / d12));
                    } else {
                        double d13 = mu / size + 1.0;
                        iftmp$6 = Mathlib.log((double)(mu / d13));
                    }
                    double p = iftmp$6;
                    if (log_p != 0) {
                        double d14 = x * p - mu;
                        double d15 = lgamma.lgammafn(x + 1.0);
                        double d16 = d14 - d15;
                        double d17 = (x - 1.0) * x;
                        double d18 = size * 2.0;
                        double d19 = Mathlib.log1p((double)(d17 / d18));
                        iftmp$7 = d16 + d19;
                    } else {
                        double d20 = x * p - mu;
                        double d21 = lgamma.lgammafn(x + 1.0);
                        double d22 = d20 - d21;
                        double d23 = (x - 1.0) * x;
                        double d24 = size * 2.0;
                        double d25 = Mathlib.log1p((double)(d23 / d24));
                        iftmp$7 = Mathlib.exp((double)(d22 + d25));
                    }
                    d = iftmp$7;
                } else {
                    double d26 = size + x;
                    double p = size / d26;
                    double d27 = size + mu;
                    double d28 = mu / d27;
                    double d29 = size + mu;
                    double d30 = size / d29;
                    double d31 = x + size;
                    double ans = dbinom.dbinom_raw(size, d31, d30, d28, log_p);
                    double iftmp$8 = log_p != 0 ? Mathlib.log((double)p) + ans : p * ans;
                    d = iftmp$8;
                }
            }
        }
        return d;
    }

    public static double dnbinom(double x, double size, double prob, int log_p) {
        double d;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(size) || Double.isNaN(size) || Double.isNaN(prob) || Double.isNaN(prob)) {
            d = x + size + prob;
        } else if (prob <= 0.0 || prob > 1.0 || size < 0.0) {
            d = 0.0 / 0.0;
        } else {
            double d2 = Mathlib.round((double)x);
            double d3 = Math.abs(x - d2);
            double d4 = Math.abs(x);
            double d5 = fmax2.fmax2(1.0, d4) * 1.0E-7;
            if (d3 > d5) {
                Stdlib.printf((BytePtr)new BytePtr("non-integer x = %f\u0000".getBytes(), 0), (Object[])new Object[]{x});
                double iftmp$9 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                d = iftmp$9;
            } else if (x < 0.0 || !(Math.abs(x) <= Double.MAX_VALUE)) {
                double iftmp$10 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                d = iftmp$10;
            } else if (x == 0.0 && size == 0.0) {
                double iftmp$11 = log_p != 0 ? 0.0 : 1.0;
                d = iftmp$11;
            } else {
                x = Mathlib.round((double)x);
                if (!(Math.abs(size) <= Double.MAX_VALUE)) {
                    size = Double.MAX_VALUE;
                }
                double d6 = 1.0 - prob;
                double d7 = x + size;
                double ans = dbinom.dbinom_raw(size, d7, prob, d6, log_p);
                double d8 = size + x;
                double p = size / d8;
                double iftmp$12 = log_p != 0 ? Mathlib.log((double)p) + ans : p * ans;
                d = iftmp$12;
            }
        }
        return d;
    }
}

