/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.dchisq;
import org.renjin.nmath.dpois;

public class dnchisq {
    public static double eps$4352 = 5.0E-15;
    public static double $dnchisq$eps = 5.0E-15;

    private dnchisq() {
    }

    public static double dnchisq(double x, double df2, double ncp, int log_p) {
        double d;
        double x2 = 0.0;
        double imax = 0.0;
        double dfmid = 0.0;
        double mid = 0.0;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(df2) || Double.isNaN(df2) || Double.isNaN(ncp) || Double.isNaN(ncp)) {
            d = x + df2 + ncp;
        } else if (!(Math.abs(df2) <= Double.MAX_VALUE) || !(Math.abs(ncp) <= Double.MAX_VALUE) || ncp < 0.0 || df2 < 0.0) {
            d = 0.0 / 0.0;
        } else if (x < 0.0) {
            double iftmp$0 = log_p != 0 ? -1.0 / 0.0 : 0.0;
            d = iftmp$0;
        } else if (x == 0.0 && df2 < 2.0) {
            d = 1.0 / 0.0;
        } else if (ncp == 0.0) {
            double iftmp$1;
            if (df2 > 0.0) {
                iftmp$1 = dchisq.dchisq(x, df2, log_p);
            } else {
                double iftmp$2 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$1 = iftmp$2;
            }
            d = iftmp$1;
        } else {
            double d2 = 1.0 / 0.0;
            if (x == d2) {
                double iftmp$3 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                d = iftmp$3;
            } else {
                double d3;
                double ncp2 = ncp * 0.5;
                double d4 = 2.0 - df2;
                double d5 = 2.0 - df2;
                double d6 = d4 * d5;
                double d7 = ncp * 4.0 * x;
                double d8 = Mathlib.sqrt((double)(d6 + d7));
                imax = Mathlib.ceil((double)((d8 - (d3 = df2 + 2.0)) / 4.0));
                if (imax < 0.0) {
                    imax = 0.0;
                }
                if (!(Math.abs(imax) <= Double.MAX_VALUE) ^ true) {
                    dfmid = imax * 2.0 + df2;
                    double d9 = dpois.dpois_raw(imax, ncp2, 0);
                    double d10 = dchisq.dchisq(x, dfmid, 0);
                    mid = d9 * d10;
                } else {
                    mid = 0.0;
                }
                if (mid == 0.0) {
                    if (log_p != 0 || ncp > 1000.0) {
                        double nl = df2 + ncp;
                        double d11 = nl + ncp;
                        double ic = nl / d11;
                        double d12 = nl * ic;
                        d = dchisq.dchisq(x * ic, d12, log_p);
                    } else {
                        double iftmp$4 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                        d = iftmp$4;
                    }
                } else {
                    double eps$5;
                    double d13;
                    double d14;
                    double d15;
                    double q;
                    double sum = mid;
                    double term = mid;
                    df2 = dfmid;
                    double i = imax;
                    x2 = x * ncp2;
                    do {
                        q = x2 / (i += 1.0) / df2;
                        df2 += 2.0;
                    } while (q >= 1.0 || (d15 = term * q) > (d14 = (d13 = 1.0 - q) * (eps$5 = $dnchisq$eps)) || (sum += (term *= q)) * 1.0E-10 < term);
                    term = mid;
                    df2 = dfmid;
                    i = imax;
                    while (i != 0.0) {
                        double eps$6;
                        double d16;
                        double d17;
                        double d18;
                        q = i * (df2 -= 2.0) / x2;
                        i -= 1.0;
                        sum += (term *= q);
                        if (q < 1.0 && (d18 = term * q) <= (d17 = (d16 = 1.0 - q) * (eps$6 = $dnchisq$eps))) break;
                    }
                    double iftmp$7 = log_p != 0 ? Mathlib.log((double)sum) : sum;
                    d = iftmp$7;
                }
            }
        }
        return d;
    }
}

