/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.dgamma;
import org.renjin.nmath.dnbeta;
import org.renjin.nmath.dnchisq;

public class dnf {
    private dnf() {
    }

    public static double dnf(double x, double df1, double df2, double ncp, int log_p) {
        double d;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(df1) || Double.isNaN(df1) || Double.isNaN(df2) || Double.isNaN(df2) || Double.isNaN(ncp) || Double.isNaN(ncp)) {
            d = x + df2 + df1 + ncp;
        } else if (df1 <= 0.0 || df2 <= 0.0 || ncp < 0.0) {
            d = 0.0 / 0.0;
        } else if (x < 0.0) {
            double iftmp$0 = log_p != 0 ? -1.0 / 0.0 : 0.0;
            d = iftmp$0;
        } else if (!(Math.abs(ncp) <= Double.MAX_VALUE)) {
            d = 0.0 / 0.0;
        } else if (!(Math.abs(df1) <= Double.MAX_VALUE) && !(Math.abs(df2) <= Double.MAX_VALUE)) {
            if (x == 1.0) {
                d = 1.0 / 0.0;
            } else {
                double iftmp$1 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                d = iftmp$1;
            }
        } else if (!(Math.abs(df2) <= Double.MAX_VALUE)) {
            d = dnchisq.dnchisq(x * df1, df1, ncp, log_p) * df1;
        } else if (df1 > 1.0E14 && ncp < 1.0E7) {
            double iftmp$2;
            double f = ncp / df1 + 1.0;
            double d2 = 2.0 / df2;
            double d3 = df2 / 2.0;
            double z = dgamma.dgamma(1.0 / x / f, d3, d2, log_p);
            if (log_p != 0) {
                double d4 = Mathlib.log((double)x) * 2.0;
                double d5 = z - d4;
                double d6 = Mathlib.log((double)f);
                iftmp$2 = d5 - d6;
            } else {
                double d7 = x;
                double d8 = d7 * d7;
                iftmp$2 = z / d8 / f;
            }
            d = iftmp$2;
        } else {
            double iftmp$3;
            double y = df1 / df2 * x;
            double d9 = df2 / 2.0;
            double d10 = df1 / 2.0;
            double d11 = y + 1.0;
            double z = dnbeta.dnbeta(y / d11, d10, d9, ncp, log_p);
            if (log_p != 0) {
                double d12 = Mathlib.log((double)df1) + z;
                double d13 = Mathlib.log((double)df2);
                double d14 = d12 - d13;
                double d15 = Mathlib.log1p((double)y) * 2.0;
                iftmp$3 = d14 - d15;
            } else {
                double d16 = df1 / df2 * z;
                double d17 = y + 1.0;
                double d18 = d16 / d17;
                double d19 = y + 1.0;
                iftmp$3 = d18 / d19;
            }
            d = iftmp$3;
        }
        return d;
    }
}

