/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.dnorm;
import org.renjin.nmath.dt;
import org.renjin.nmath.lgamma;
import org.renjin.nmath.pnt;

public class dnt {
    private dnt() {
    }

    public static double dnt(double x, double df2, double ncp, int log_p) {
        double d;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(df2) || Double.isNaN(df2)) {
            d = x + df2;
        } else if (df2 <= 0.0) {
            d = 0.0 / 0.0;
        } else if (ncp == 0.0) {
            d = dt.dt(x, df2, log_p);
        } else if (!(Math.abs(x) <= Double.MAX_VALUE)) {
            double iftmp$0 = log_p != 0 ? -1.0 / 0.0 : 0.0;
            d = iftmp$0;
        } else if (!(Math.abs(df2) <= Double.MAX_VALUE) || df2 > 1.0E8) {
            d = dnorm.dnorm4(x, ncp, 1.0, log_p);
        } else {
            double u;
            double d2 = Math.abs(x);
            double d3 = Mathlib.sqrt((double)(df2 * 2.220446049250313E-16));
            if (d2 > d3) {
                double d4 = Mathlib.log((double)df2);
                double d5 = Mathlib.log((double)Math.abs(x));
                double d6 = d4 - d5;
                double d7 = df2 + 2.0;
                double d8 = pnt.pnt(Mathlib.sqrt((double)((df2 + 2.0) / df2)) * x, d7, ncp, 1, 0);
                double d9 = pnt.pnt(x, df2, ncp, 1, 0);
                double d10 = Mathlib.log((double)Math.abs(d8 - d9));
                u = d6 + d10;
            } else {
                double d11 = lgamma.lgammafn((df2 + 1.0) / 2.0);
                double d12 = lgamma.lgammafn(df2 / 2.0);
                double d13 = d11 - d12;
                double d14 = Mathlib.log((double)df2);
                double d15 = ncp;
                double d16 = d15 * d15;
                double d17 = (d14 + d16) * 0.5 + 0.5723649429247001;
                u = d13 - d17;
            }
            double iftmp$1 = log_p == 0 ? Mathlib.exp((double)u) : u;
            d = iftmp$1;
        }
        return d;
    }
}

