/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.bd0;
import org.renjin.nmath.fmax2;
import org.renjin.nmath.lgamma;
import org.renjin.nmath.stirlerr;

public class dpois {
    private dpois() {
    }

    public static double dpois(double x, double lambda, int log_p) {
        double d;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(lambda) || Double.isNaN(lambda)) {
            d = x + lambda;
        } else if (lambda < 0.0) {
            d = 0.0 / 0.0;
        } else {
            double d2 = Mathlib.round((double)x);
            double d3 = Math.abs(x - d2);
            double d4 = Math.abs(x);
            double d5 = fmax2.fmax2(1.0, d4) * 1.0E-7;
            if (d3 > d5) {
                Stdlib.printf((BytePtr)new BytePtr("non-integer x = %f\u0000".getBytes(), 0), (Object[])new Object[]{x});
                double iftmp$0 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                d = iftmp$0;
            } else if (x < 0.0 || !(Math.abs(x) <= Double.MAX_VALUE)) {
                double iftmp$1 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                d = iftmp$1;
            } else {
                x = Mathlib.round((double)x);
                d = dpois.dpois_raw(x, lambda, log_p);
            }
        }
        return d;
    }

    public static double dpois_raw(double x, double lambda, int log_p) {
        double d;
        if (lambda == 0.0) {
            double iftmp$2;
            if (x == 0.0) {
                double iftmp$3 = log_p != 0 ? 0.0 : 1.0;
                iftmp$2 = iftmp$3;
            } else {
                double iftmp$4 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$2 = iftmp$4;
            }
            d = iftmp$2;
        } else if (!(Math.abs(lambda) <= Double.MAX_VALUE)) {
            double iftmp$5 = log_p != 0 ? -1.0 / 0.0 : 0.0;
            d = iftmp$5;
        } else if (x < 0.0) {
            double iftmp$6 = log_p != 0 ? -1.0 / 0.0 : 0.0;
            d = iftmp$6;
        } else if (lambda * Double.MIN_NORMAL >= x) {
            double iftmp$7 = log_p != 0 ? -lambda : Mathlib.exp((double)(-lambda));
            d = iftmp$7;
        } else if (x * Double.MIN_NORMAL > lambda) {
            if (!(Math.abs(x) <= Double.MAX_VALUE)) {
                double iftmp$8 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                d = iftmp$8;
            } else {
                double iftmp$9;
                if (log_p != 0) {
                    double d2 = Mathlib.log((double)lambda) * x - lambda;
                    double d3 = lgamma.lgammafn(x + 1.0);
                    iftmp$9 = d2 - d3;
                } else {
                    double d4 = Mathlib.log((double)lambda) * x - lambda;
                    double d5 = lgamma.lgammafn(x + 1.0);
                    iftmp$9 = Mathlib.exp((double)(d4 - d5));
                }
                d = iftmp$9;
            }
        } else {
            double iftmp$10;
            if (log_p != 0) {
                double d6 = Mathlib.log((double)(x * (Math.PI * 2))) * -0.5;
                double d7 = -stirlerr.Rf_stirlerr(x);
                double d8 = bd0.Rf_bd0(x, lambda);
                double d9 = d7 - d8;
                iftmp$10 = d6 + d9;
            } else {
                double d10 = -stirlerr.Rf_stirlerr(x);
                double d11 = bd0.Rf_bd0(x, lambda);
                double d12 = Mathlib.exp((double)(d10 - d11));
                double d13 = Mathlib.sqrt((double)(x * (Math.PI * 2)));
                iftmp$10 = d12 / d13;
            }
            d = iftmp$10;
        }
        return d;
    }
}

