/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.bd0;
import org.renjin.nmath.dnorm;
import org.renjin.nmath.stirlerr;

public class dt {
    private dt() {
    }

    public static double dt(double x, double n, int log_p) {
        double d;
        double ax = 0.0;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(n) || Double.isNaN(n)) {
            d = x + n;
        } else if (n <= 0.0) {
            d = 0.0 / 0.0;
        } else if (!(Math.abs(x) <= Double.MAX_VALUE)) {
            double iftmp$0 = log_p != 0 ? -1.0 / 0.0 : 0.0;
            d = iftmp$0;
        } else if (!(Math.abs(n) <= Double.MAX_VALUE)) {
            d = dnorm.dnorm4(x, 0.0, 1.0, log_p);
        } else {
            double u;
            double l_x2n;
            boolean lrg_x2n;
            double d2 = stirlerr.Rf_stirlerr((n + 1.0) / 2.0);
            double d3 = (n + 1.0) / 2.0;
            double d4 = bd0.Rf_bd0(n / 2.0, d3);
            double d5 = d2 - d4;
            double d6 = stirlerr.Rf_stirlerr(n / 2.0);
            double t = d5 - d6;
            double d7 = x;
            double x2n = d7 * d7 / n;
            boolean bl = lrg_x2n = x2n > 4.503599627370496E15;
            if (lrg_x2n) {
                ax = Math.abs(x);
                double d8 = Mathlib.log((double)ax);
                double d9 = Mathlib.log((double)n) / 2.0;
                l_x2n = d8 - d9;
                u = n * l_x2n;
            } else if (x2n > 0.2) {
                l_x2n = Mathlib.log((double)(x2n + 1.0)) / 2.0;
                u = n * l_x2n;
            } else {
                l_x2n = Mathlib.log1p((double)x2n) / 2.0;
                double d10 = x;
                double d11 = d10 * d10 / 2.0;
                double d12 = x;
                double d13 = (d12 * d12 + n) / 2.0;
                double d14 = bd0.Rf_bd0(n / 2.0, d13);
                u = d11 - d14;
            }
            if (log_p != 0) {
                double d15 = t - u;
                double d16 = l_x2n + 0.9189385332046728;
                d = d15 - d16;
            } else {
                double iftmp$1 = lrg_x2n ? Mathlib.sqrt((double)n) / ax : Mathlib.exp((double)(-l_x2n));
                double I_sqrt_ = iftmp$1;
                d = Mathlib.exp((double)(t - u)) * 0.3989422804014327 * I_sqrt_;
            }
        }
        return d;
    }
}

