/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Mathlib;

public class dweibull {
    private dweibull() {
    }

    public static double dweibull(double x, double shape, double scale, int log_p) {
        double d;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(shape) || Double.isNaN(shape) || Double.isNaN(scale) || Double.isNaN(scale)) {
            d = x + shape + scale;
        } else if (shape <= 0.0 || scale <= 0.0) {
            d = 0.0 / 0.0;
        } else if (x < 0.0) {
            double iftmp$0 = log_p != 0 ? -1.0 / 0.0 : 0.0;
            d = iftmp$0;
        } else if (!(Math.abs(x) <= Double.MAX_VALUE)) {
            double iftmp$1 = log_p != 0 ? -1.0 / 0.0 : 0.0;
            d = iftmp$1;
        } else if (x == 0.0 && shape < 1.0) {
            d = 1.0 / 0.0;
        } else {
            double iftmp$2;
            double d2 = shape - 1.0;
            double tmp1 = Mathlib.pow((double)(x / scale), (double)d2);
            double tmp2 = x / scale * tmp1;
            if (log_p != 0) {
                iftmp$2 = Mathlib.log((double)(shape * tmp1 / scale)) - tmp2;
            } else {
                double d3 = shape * tmp1;
                double d4 = Mathlib.exp((double)(-tmp2));
                iftmp$2 = d3 * d4 / scale;
            }
            d = iftmp$2;
        }
        return d;
    }
}

