/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.mlutils;

public class fround {
    private fround() {
    }

    public static double fround(double x, double digits) {
        double d;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(digits) || Double.isNaN(digits)) {
            d = x + digits;
        } else if (!(Math.abs(x) <= Double.MAX_VALUE)) {
            d = x;
        } else {
            double d2 = 1.0 / 0.0;
            if (digits == d2) {
                d = x;
            } else {
                double d3 = -1.0 / 0.0;
                if (digits == d3) {
                    d = 0.0;
                } else {
                    double sgn;
                    if (digits > 308.0) {
                        digits = 308.0;
                    }
                    int dig = (int)Mathlib.floor((double)(digits + 0.5));
                    if (x < 0.0) {
                        sgn = -1.0;
                        x = -x;
                    } else {
                        sgn = 1.0;
                    }
                    if (dig == 0) {
                        d = Mathlib.rint((double)x) * sgn;
                    } else if (dig > 0) {
                        double pow10 = mlutils.R_pow_di(10.0, dig);
                        double intx = Mathlib.floor((double)x);
                        d = (Mathlib.rint((double)((x - intx) * pow10)) / pow10 + intx) * sgn;
                    } else {
                        int n = -dig;
                        double pow10 = mlutils.R_pow_di(10.0, n);
                        d = Mathlib.rint((double)(x / pow10)) * sgn * pow10;
                    }
                }
            }
        }
        return d;
    }
}

