/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.gamma;
import org.renjin.nmath.lgamma;
import org.renjin.nmath.lgammacor;

public class lbeta {
    private lbeta() {
    }

    public static double lbeta(double a, double b) {
        double d;
        if (Double.isNaN(a) || Double.isNaN(a) || Double.isNaN(b) || Double.isNaN(b)) {
            d = a + b;
        } else {
            double q;
            double p = q = a;
            if (b < p) {
                p = b;
            }
            if (b > q) {
                q = b;
            }
            if (p < 0.0) {
                d = 0.0 / 0.0;
            } else if (p == 0.0) {
                d = 1.0 / 0.0;
            } else if (!(Math.abs(q) <= Double.MAX_VALUE)) {
                d = -1.0 / 0.0;
            } else if (p >= 10.0) {
                double d2 = lgammacor.Rf_lgammacor(p);
                double d3 = lgammacor.Rf_lgammacor(q);
                double d4 = d2 + d3;
                double d5 = lgammacor.Rf_lgammacor(p + q);
                double corr = d4 - d5;
                double d6 = Mathlib.log((double)q) * -0.5 + 0.9189385332046728 + corr;
                double d7 = p - 0.5;
                double d8 = p + q;
                double d9 = Mathlib.log((double)(p / d8));
                double d10 = d7 * d9;
                double d11 = d6 + d10;
                double d12 = -p;
                double d13 = p + q;
                double d14 = Mathlib.log1p((double)(d12 / d13)) * q;
                d = d11 + d14;
            } else if (q >= 10.0) {
                double d15 = lgammacor.Rf_lgammacor(q);
                double d16 = lgammacor.Rf_lgammacor(p + q);
                double corr = d15 - d16;
                double d17 = lgamma.lgammafn(p) + corr + p;
                double d18 = Mathlib.log((double)(p + q)) * p;
                double d19 = d17 - d18;
                double d20 = q - 0.5;
                double d21 = -p;
                double d22 = p + q;
                double d23 = Mathlib.log1p((double)(d21 / d22));
                double d24 = d20 * d23;
                d = d19 + d24;
            } else if (p < 1.0E-306) {
                double d25 = lgamma.lgammafn(p);
                double d26 = lgamma.lgammafn(q);
                double d27 = lgamma.lgammafn(p + q);
                double d28 = d26 - d27;
                d = d25 + d28;
            } else {
                double d29 = gamma.gammafn(p);
                double d30 = gamma.gammafn(q);
                double d31 = gamma.gammafn(p + q);
                double d32 = d30 / d31;
                d = Mathlib.log((double)(d29 * d32));
            }
        }
        return d;
    }
}

