/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.cospi;
import org.renjin.nmath.gamma;
import org.renjin.nmath.lgammacor;

public class lgamma {
    private lgamma() {
    }

    public static double lgammafn(double x) {
        return lgamma.lgammafn_sign(x, BytePtr.of((int)0));
    }

    public static double lgammafn_sign(double x, Ptr sgn) {
        double d;
        if (!sgn.isNull()) {
            sgn.setInt(1);
        }
        if (Double.isNaN(x) || Double.isNaN(x)) {
            d = x;
        } else {
            if (!sgn.isNull() && x < 0.0 && Mathlib.fmod((double)Mathlib.floor((double)(-x)), (double)2.0) == 0.0) {
                sgn.setInt(-1);
            }
            if (x <= 0.0 && Mathlib.trunc((double)x) == x) {
                BytePtr msg = new BytePtr("\u0000".getBytes(), 0);
                int msg$offset = 0;
                msg = new BytePtr("value out of range in '%s'\n\u0000".getBytes(), 0);
                msg$offset = 0;
                Stdlib.printf((BytePtr)((BytePtr)msg.pointerPlus(msg$offset)), (Object[])new Object[]{new BytePtr("lgamma\u0000".getBytes(), 0)});
                d = 1.0 / 0.0;
            } else {
                double y = Math.abs(x);
                if (y < 1.0E-306) {
                    d = -Mathlib.log((double)y);
                } else if (y <= 10.0) {
                    d = Mathlib.log((double)Math.abs(gamma.gammafn(x)));
                } else if (y > 2.5327372760800758E305) {
                    BytePtr msg = new BytePtr("\u0000".getBytes(), 0);
                    int msg$offset = 0;
                    msg = new BytePtr("value out of range in '%s'\n\u0000".getBytes(), 0);
                    msg$offset = 0;
                    Stdlib.printf((BytePtr)((BytePtr)msg.pointerPlus(msg$offset)), (Object[])new Object[]{new BytePtr("lgamma\u0000".getBytes(), 0)});
                    d = 1.0 / 0.0;
                } else if (x > 0.0) {
                    if (x > 1.0E17) {
                        d = (Mathlib.log((double)x) - 1.0) * x;
                    } else if (x > 4934720.0) {
                        double d2 = x - 0.5;
                        double d3 = Mathlib.log((double)x);
                        d = d2 * d3 + 0.9189385332046728 - x;
                    } else {
                        double d4 = x - 0.5;
                        double d5 = Mathlib.log((double)x);
                        double d6 = d4 * d5 + 0.9189385332046728 - x;
                        double d7 = lgammacor.Rf_lgammacor(x);
                        d = d6 + d7;
                    }
                } else {
                    double sinpiy = Math.abs(cospi.sinpi(y));
                    if (sinpiy == 0.0) {
                        Stdlib.printf((BytePtr)new BytePtr(" ** should NEVER happen! *** [lgamma.c: Neg.int, y=%g]\n\u0000".getBytes(), 0), (Object[])new Object[]{y});
                        d = 0.0 / 0.0;
                    } else {
                        double d8 = x - 0.5;
                        double d9 = Mathlib.log((double)y);
                        double d10 = d8 * d9 + 0.22579135264472744 - x;
                        double d11 = Mathlib.log((double)sinpiy);
                        double d12 = d10 - d11;
                        double d13 = lgammacor.Rf_lgammacor(y);
                        double ans = d12 - d13;
                        double d14 = Mathlib.trunc((double)(x - 0.5));
                        if (Math.abs((x - d14) * ans / x) < 1.4901161193847656E-8) {
                            BytePtr msg = new BytePtr("\u0000".getBytes(), 0);
                            int msg$offset = 0;
                            msg = new BytePtr("full precision may not have been achieved in '%s'\n\u0000".getBytes(), 0);
                            msg$offset = 0;
                            Stdlib.printf((BytePtr)((BytePtr)msg.pointerPlus(msg$offset)), (Object[])new Object[]{new BytePtr("lgamma\u0000".getBytes(), 0)});
                        }
                        d = ans;
                    }
                }
            }
        }
        return d;
    }
}

