/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.annotations.VarArgs;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Stdlib;

public class mlutils {
    public static double R_NegInf = Double.NEGATIVE_INFINITY;
    public static double R_PosInf = Double.POSITIVE_INFINITY;
    public static double NA_REAL = Double.NaN;

    private mlutils() {
    }

    public static void REprintf(Ptr format, @VarArgs Ptr ptr) {
        Ptr[] ap = new Ptr[]{BytePtr.of((int)0)};
        ap[0] = ptr;
        Ptr ap$0 = ap[0];
        Stdlib.fprintf((Ptr)Stdlib.stderr, (BytePtr)((BytePtr)format), (Object[])new Object[]{ap$0});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double R_pow_di(double x, int n) {
        double pow = 0.0;
        pow = 1.0;
        if (Double.isNaN(x)) return x;
        if (Double.isNaN(x)) return x;
        if (n == 0) return pow;
        if (!(Math.abs(x) <= Double.MAX_VALUE)) {
            double d = n;
            return mlutils.R_pow(x, d);
        }
        if (n < 0) {
            n = -n;
            x = 1.0 / x;
        }
        while (true) {
            if ((n & 1) != 0) {
                pow *= x;
            }
            if ((n >>= 1) == 0) return pow;
            double d = x;
            x = d * d;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double R_pow(double x, double y) {
        if (x == 1.0) return 1.0;
        if (y == 0.0) return 1.0;
        if (x == 0.0) {
            if (y > 0.0) return 0.0;
            return 1.0 / 0.0;
        }
        if (!(Math.abs(x) <= Double.MAX_VALUE) ^ true) {
            if (!(Math.abs(y) <= Double.MAX_VALUE) ^ true) return Mathlib.pow((double)x, (double)y);
        }
        if (Double.isNaN(x)) return x + y;
        if (Double.isNaN(x)) return x + y;
        if (Double.isNaN(y)) return x + y;
        if (Double.isNaN(y)) return x + y;
        if (!(Math.abs(x) <= Double.MAX_VALUE)) {
            if (x > 0.0) {
                if (y < 0.0) return 0.0;
                double iftmp$2 = 1.0 / 0.0;
                return iftmp$2;
            }
            if (!(Math.abs(y) <= Double.MAX_VALUE) ^ true && Mathlib.floor((double)y) == y) {
                if (y < 0.0) return 0.0;
                double iftmp$4 = mlutils.myfmod(y, 2.0) == 0.0 ? -x : x;
                double iftmp$3 = iftmp$4;
                return iftmp$3;
            }
        }
        if (Math.abs(y) <= Double.MAX_VALUE || !(x >= 0.0)) return 0.0 / 0.0;
        if (y > 0.0) {
            if (!(x >= 1.0)) {
                return 0.0;
            }
            double iftmp$5 = 1.0 / 0.0;
            return iftmp$5;
        }
        if (!(x < 1.0)) {
            return 0.0;
        }
        double iftmp$6 = 1.0 / 0.0;
        return iftmp$6;
    }

    public static double myfmod(double x1, double x2) {
        double d = Mathlib.floor((double)(x1 / x2)) * x2;
        return x1 - d;
    }

    public static int R_isnancpp(double x) {
        return !Double.isNaN(x) && !Double.isNaN(x) ? 0 : 1;
    }

    public static int R_finite(double x) {
        return (Math.abs(x) <= Double.MAX_VALUE ? 0 : 1) ^ 1;
    }
}

