/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.toms708;

public class pbeta {
    private pbeta() {
    }

    public static double pbeta(double x, double a, double b, int lower_tail, int log_p) {
        double d;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(a) || Double.isNaN(b) || Double.isNaN(b)) {
            d = x + a + b;
        } else if (a < 0.0 || b < 0.0) {
            d = 0.0 / 0.0;
        } else if (x <= 0.0) {
            double iftmp$0;
            if (lower_tail != 0) {
                double iftmp$1 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$0 = iftmp$1;
            } else {
                double iftmp$2 = log_p != 0 ? 0.0 : 1.0;
                iftmp$0 = iftmp$2;
            }
            d = iftmp$0;
        } else if (x >= 1.0) {
            double iftmp$3;
            if (lower_tail != 0) {
                double iftmp$4 = log_p != 0 ? 0.0 : 1.0;
                iftmp$3 = iftmp$4;
            } else {
                double iftmp$5 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$3 = iftmp$5;
            }
            d = iftmp$3;
        } else {
            d = pbeta.pbeta_raw(x, a, b, lower_tail, log_p);
        }
        return d;
    }

    public static double pbeta_raw(double x, double a, double b, int lower_tail, int log_p) {
        double d;
        int[] ierr = new int[1];
        double[] wc = new double[1];
        double[] w = new double[1];
        ierr[0] = 0;
        wc[0] = 0.0;
        w[0] = 0.0;
        if (a == 0.0 || b == 0.0 || !(Math.abs(a) <= Double.MAX_VALUE) || !(Math.abs(b) <= Double.MAX_VALUE)) {
            if (a == 0.0 && b == 0.0) {
                double iftmp$6 = log_p != 0 ? -0.6931471805599453 : 0.5;
                d = iftmp$6;
            } else if (a == 0.0 || a / b == 0.0) {
                double iftmp$7;
                if (lower_tail != 0) {
                    double iftmp$8 = log_p != 0 ? 0.0 : 1.0;
                    iftmp$7 = iftmp$8;
                } else {
                    double iftmp$9 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                    iftmp$7 = iftmp$9;
                }
                d = iftmp$7;
            } else if (b == 0.0 || b / a == 0.0) {
                double iftmp$10;
                if (lower_tail != 0) {
                    double iftmp$11 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                    iftmp$10 = iftmp$11;
                } else {
                    double iftmp$12 = log_p != 0 ? 0.0 : 1.0;
                    iftmp$10 = iftmp$12;
                }
                d = iftmp$10;
            } else if (x < 0.5) {
                double iftmp$13;
                if (lower_tail != 0) {
                    double iftmp$14 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                    iftmp$13 = iftmp$14;
                } else {
                    double iftmp$15 = log_p != 0 ? 0.0 : 1.0;
                    iftmp$13 = iftmp$15;
                }
                d = iftmp$13;
            } else {
                double iftmp$16;
                if (lower_tail != 0) {
                    double iftmp$17 = log_p != 0 ? 0.0 : 1.0;
                    iftmp$16 = iftmp$17;
                } else {
                    double iftmp$18 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                    iftmp$16 = iftmp$18;
                }
                d = iftmp$16;
            }
        } else {
            double x1 = 0.5 - x + 0.5;
            toms708.Rf_bratio(a, b, x, x1, (Ptr)new DoublePtr(w, 0), (Ptr)new DoublePtr(wc, 0), (Ptr)new IntPtr(ierr, 0), log_p);
            if (ierr[0] != 0 && ierr[0] != 11 && ierr[0] != 14) {
                int ierr$22 = ierr[0];
                Stdlib.printf((BytePtr)new BytePtr("pbeta_raw(%g, a=%g, b=%g, ..) -> bratio() gave error code %d\u0000".getBytes(), 0), (Object[])new Object[]{x, a, b, ierr$22});
            }
            double iftmp$23 = lower_tail != 0 ? w[0] : wc[0];
            d = iftmp$23;
        }
        return d;
    }
}

