/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.fmax2;
import org.renjin.nmath.pbeta;

public class pbinom {
    private pbinom() {
    }

    public static double pbinom(double x, double n, double p, int lower_tail, int log_p) {
        double d;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(n) || Double.isNaN(n) || Double.isNaN(p) || Double.isNaN(p)) {
            d = x + n + p;
        } else if (!(Math.abs(n) <= Double.MAX_VALUE) || !(Math.abs(p) <= Double.MAX_VALUE)) {
            d = 0.0 / 0.0;
        } else {
            double d2 = Mathlib.round((double)n);
            double d3 = Math.abs(n - d2);
            double d4 = Math.abs(n);
            double d5 = fmax2.fmax2(1.0, d4) * 1.0E-7;
            if (d3 > d5) {
                Stdlib.printf((BytePtr)new BytePtr("non-integer n = %f\u0000".getBytes(), 0), (Object[])new Object[]{n});
                d = 0.0 / 0.0;
            } else {
                n = Mathlib.round((double)n);
                if (n < 0.0 || p < 0.0 || p > 1.0) {
                    d = 0.0 / 0.0;
                } else if (x < 0.0) {
                    double iftmp$0;
                    if (lower_tail != 0) {
                        double iftmp$1 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                        iftmp$0 = iftmp$1;
                    } else {
                        double iftmp$2 = log_p != 0 ? 0.0 : 1.0;
                        iftmp$0 = iftmp$2;
                    }
                    d = iftmp$0;
                } else if (n <= (x = Mathlib.floor((double)(x + 1.0E-7)))) {
                    double iftmp$3;
                    if (lower_tail != 0) {
                        double iftmp$4 = log_p != 0 ? 0.0 : 1.0;
                        iftmp$3 = iftmp$4;
                    } else {
                        double iftmp$5 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                        iftmp$3 = iftmp$5;
                    }
                    d = iftmp$3;
                } else {
                    int n2 = lower_tail != 0 ? 0 : 1;
                    double d6 = n - x;
                    double d7 = x + 1.0;
                    d = pbeta.pbeta(p, d7, d6, n2, log_p);
                }
            }
        }
        return d;
    }
}

