/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Mathlib;

public class pcauchy {
    private pcauchy() {
    }

    public static double pcauchy(double x, double location, double scale, int lower_tail, int log_p) {
        double d;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(location) || Double.isNaN(location) || Double.isNaN(scale) || Double.isNaN(scale)) {
            d = x + location + scale;
        } else if (scale <= 0.0) {
            d = 0.0 / 0.0;
        } else {
            x = (x - location) / scale;
            if (Double.isNaN(x) || Double.isNaN(x)) {
                d = 0.0 / 0.0;
            } else if (!(Math.abs(x) <= Double.MAX_VALUE)) {
                if (x < 0.0) {
                    double iftmp$0;
                    if (lower_tail != 0) {
                        double iftmp$1 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                        iftmp$0 = iftmp$1;
                    } else {
                        double iftmp$2 = log_p != 0 ? 0.0 : 1.0;
                        iftmp$0 = iftmp$2;
                    }
                    d = iftmp$0;
                } else {
                    double iftmp$3;
                    if (lower_tail != 0) {
                        double iftmp$4 = log_p != 0 ? 0.0 : 1.0;
                        iftmp$3 = iftmp$4;
                    } else {
                        double iftmp$5 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                        iftmp$3 = iftmp$5;
                    }
                    d = iftmp$3;
                }
            } else {
                if (lower_tail == 0) {
                    x = -x;
                }
                if (Math.abs(x) > 1.0) {
                    double iftmp$6;
                    double y = Mathlib.atan((double)(1.0 / x)) / Math.PI;
                    if (x > 0.0) {
                        double iftmp$7 = log_p != 0 ? Mathlib.log1p((double)(-y)) : 0.5 - y + 0.5;
                        iftmp$6 = iftmp$7;
                    } else {
                        double iftmp$8 = log_p != 0 ? Mathlib.log((double)(-y)) : -y;
                        iftmp$6 = iftmp$8;
                    }
                    d = iftmp$6;
                } else {
                    double iftmp$9 = log_p != 0 ? Mathlib.log((double)(Mathlib.atan((double)x) / Math.PI + 0.5)) : Mathlib.atan((double)x) / Math.PI + 0.5;
                    d = iftmp$9;
                }
            }
        }
        return d;
    }
}

