/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.dnorm;
import org.renjin.nmath.dpois;
import org.renjin.nmath.fmax2;
import org.renjin.nmath.lgamma;
import org.renjin.nmath.pnorm;

public class pgamma {
    public static double tol_logcf$4372;
    public static double two$4371;
    public static double minLog1Value$4368;
    public static double[] coeffs$4378;
    public static double[] coefs_b$4489;
    public static double[] coefs_a$4488;
    public static double M_cutoff;
    public static double scalefactor;
    public static double[] $ppois_asymp$coefs_b;
    public static double[] $ppois_asymp$coefs_a;
    public static double[] $lgamma1p$coeffs;
    public static double $log1pmx$tol_logcf;
    public static double $log1pmx$two;
    public static double $log1pmx$minLog1Value;

    private pgamma() {
    }

    public static double pgamma(double x, double alph, double scale, int lower_tail, int log_p) {
        double d;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(alph) || Double.isNaN(alph) || Double.isNaN(scale) || Double.isNaN(scale)) {
            d = x + alph + scale;
        } else if (alph < 0.0 || scale <= 0.0) {
            d = 0.0 / 0.0;
        } else if (Double.isNaN(x /= scale) || Double.isNaN(x)) {
            d = x;
        } else if (alph == 0.0) {
            double iftmp$0;
            if (x <= 0.0) {
                double iftmp$1;
                if (lower_tail != 0) {
                    double iftmp$2 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                    iftmp$1 = iftmp$2;
                } else {
                    double iftmp$3 = log_p != 0 ? 0.0 : 1.0;
                    iftmp$1 = iftmp$3;
                }
                iftmp$0 = iftmp$1;
            } else {
                double iftmp$4;
                if (lower_tail != 0) {
                    double iftmp$5 = log_p != 0 ? 0.0 : 1.0;
                    iftmp$4 = iftmp$5;
                } else {
                    double iftmp$6 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                    iftmp$4 = iftmp$6;
                }
                iftmp$0 = iftmp$4;
            }
            d = iftmp$0;
        } else {
            d = pgamma.Rf_pgamma_raw(x, alph, lower_tail, log_p);
        }
        return d;
    }

    public static double Rf_pgamma_raw(double x, double alph, int lower_tail, int log_p) {
        double d;
        if (x <= 0.0) {
            double iftmp$7;
            if (lower_tail != 0) {
                double iftmp$8 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$7 = iftmp$8;
            } else {
                double iftmp$9 = log_p != 0 ? 0.0 : 1.0;
                iftmp$7 = iftmp$9;
            }
            d = iftmp$7;
        } else {
            double d2 = 1.0 / 0.0;
            if (x >= d2) {
                double iftmp$10;
                if (lower_tail != 0) {
                    double iftmp$11 = log_p != 0 ? 0.0 : 1.0;
                    iftmp$10 = iftmp$11;
                } else {
                    double iftmp$12 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                    iftmp$10 = iftmp$12;
                }
                d = iftmp$10;
            } else {
                double res;
                if (x < 1.0) {
                    res = pgamma.pgamma_smallx(x, alph, lower_tail, log_p);
                } else if (alph - 1.0 >= x && (alph + 50.0) * 0.8 > x) {
                    double sum = pgamma.pd_upper_series(x, alph, log_p);
                    double d3 = pgamma.dpois_wrap(alph, x, log_p);
                    if (lower_tail == 0) {
                        double iftmp$13;
                        if (log_p != 0) {
                            double iftmp$14 = d3 + sum > -0.6931471805599453 ? Mathlib.log((double)(-Mathlib.expm1((double)(d3 + sum)))) : Mathlib.log1p((double)(-Mathlib.exp((double)(d3 + sum))));
                            iftmp$13 = iftmp$14;
                        } else {
                            double d4 = d3 * sum;
                            iftmp$13 = 1.0 - d4;
                        }
                        res = iftmp$13;
                    } else {
                        double iftmp$15 = log_p != 0 ? sum + d3 : sum * d3;
                        res = iftmp$15;
                    }
                } else if (alph - 1.0 < x && (x + 50.0) * 0.8 > alph) {
                    double sum;
                    double d5 = pgamma.dpois_wrap(alph, x, log_p);
                    if (alph < 1.0) {
                        double d6 = x * 2.220446049250313E-16;
                        double d7 = 1.0 - alph;
                        if (d6 > d7) {
                            double iftmp$16 = log_p != 0 ? 0.0 : 1.0;
                            sum = iftmp$16;
                        } else {
                            double d8 = alph - 1.0;
                            double d9 = x - d8;
                            double f = pgamma.pd_lower_cf(alph, d9) * x / alph;
                            double iftmp$17 = log_p != 0 ? Mathlib.log((double)f) : f;
                            sum = iftmp$17;
                        }
                    } else {
                        double d10 = alph - 1.0;
                        sum = pgamma.pd_lower_series(x, d10);
                        double iftmp$18 = log_p != 0 ? Mathlib.log1p((double)sum) : sum + 1.0;
                        sum = iftmp$18;
                    }
                    if (lower_tail == 0) {
                        double iftmp$19 = log_p != 0 ? sum + d5 : sum * d5;
                        res = iftmp$19;
                    } else {
                        double iftmp$20;
                        if (log_p != 0) {
                            double iftmp$21 = d5 + sum > -0.6931471805599453 ? Mathlib.log((double)(-Mathlib.expm1((double)(d5 + sum)))) : Mathlib.log1p((double)(-Mathlib.exp((double)(d5 + sum))));
                            iftmp$20 = iftmp$21;
                        } else {
                            double d11 = d5 * sum;
                            iftmp$20 = 1.0 - d11;
                        }
                        res = iftmp$20;
                    }
                } else {
                    int n = lower_tail != 0 ? 0 : 1;
                    res = pgamma.ppois_asymp(alph - 1.0, x, n, log_p);
                }
                d = log_p == 0 && res < 1.0020841800044864E-292 ? Mathlib.exp((double)pgamma.Rf_pgamma_raw(x, alph, lower_tail, 1)) : res;
            }
        }
        return d;
    }

    public static double ppois_asymp(double x, double lambda, int lower_tail, int log_p) {
        double d;
        double res2_term;
        double res1_term;
        double s2pt = 0.0;
        double pt_ = 0.0;
        double res12 = 0.0;
        double dfm = lambda - x;
        pt_ = -pgamma.log1pmx(dfm / x);
        s2pt = Mathlib.sqrt((double)(x * 2.0 * pt_));
        if (dfm < 0.0) {
            s2pt = -s2pt;
        }
        res12 = 0.0;
        double res1_ig = res1_term = Mathlib.sqrt((double)x);
        double res2_ig = res2_term = s2pt;
        int i = 1;
        while (i <= 7) {
            res12 = $ppois_asymp$coefs_a[i] * res1_ig + res12;
            res12 = $ppois_asymp$coefs_b[i] * res2_ig + res12;
            double d2 = i;
            res1_term = pt_ / d2 * res1_term;
            double d3 = pt_ * 2.0;
            double d4 = i * 2 + 1;
            res2_term = d3 / d4 * res2_term;
            res1_ig = res1_ig / x + res1_term;
            res2_ig = res2_ig / x + res2_term;
            ++i;
        }
        double elfb = x;
        double elfb_term = 1.0;
        i = 1;
        while (i <= 7) {
            elfb = $ppois_asymp$coefs_b[i] * elfb_term + elfb;
            elfb_term /= x;
            ++i;
        }
        if (lower_tail == 0) {
            elfb = -elfb;
        }
        double f = res12 / elfb;
        int n = lower_tail != 0 ? 0 : 1;
        double np = pnorm.pnorm5(s2pt, 0.0, 1.0, n, log_p);
        if (log_p != 0) {
            int n2 = lower_tail != 0 ? 0 : 1;
            double n_d_over_p = pgamma.dpnorm(s2pt, n2, np);
            d = Mathlib.log1p((double)(f * n_d_over_p)) + np;
        } else {
            double nd = dnorm.dnorm4(s2pt, 0.0, 1.0, log_p);
            d = f * nd + np;
        }
        return d;
    }

    public static double dpnorm(double x, int lower_tail, double lp) {
        double d;
        double x2 = 0.0;
        if (x < 0.0) {
            x = -x;
            int n = lower_tail = lower_tail != 0 ? 0 : 1;
        }
        if (x > 10.0 && lower_tail == 0) {
            double d2;
            double d3;
            double term;
            double sum = term = 1.0 / x;
            double d4 = x;
            x2 = d4 * d4;
            double i = 1.0;
            do {
                term = -i / x2 * term;
                i += 2.0;
            } while ((d3 = Math.abs(term)) > (d2 = (sum += term) * 2.220446049250313E-16));
            d = 1.0 / sum;
        } else {
            double d5 = dnorm.dnorm4(x, 0.0, 1.0, 0);
            double d6 = Mathlib.exp((double)lp);
            d = d5 / d6;
        }
        return d;
    }

    public static double pd_lower_series(double lambda, double y) {
        double term = 1.0;
        double sum = 0.0;
        while (y >= 1.0 && sum * 2.220446049250313E-16 < term) {
            term = y / lambda * term;
            sum += term;
            y -= 1.0;
        }
        if (Mathlib.floor((double)y) != y) {
            double d = lambda + 1.0 - y;
            double f = pgamma.pd_lower_cf(y, d);
            sum = term * f + sum;
        }
        return sum;
    }

    public static double pd_lower_cf(double y, double d) {
        double d2;
        block9: {
            double c4 = 0.0;
            double c2 = 0.0;
            double f0 = 0.0;
            double of = 0.0;
            double f = 0.0;
            f = 0.0;
            if (y == 0.0) {
                d2 = 0.0;
            } else {
                f0 = y / d;
                double d3 = Math.abs(y - 1.0);
                double d4 = Math.abs(d) * 2.220446049250313E-16;
                if (d3 < d4) {
                    d2 = f0;
                } else {
                    double scalefactor$26;
                    if (f0 > 1.0) {
                        f0 = 1.0;
                    }
                    c2 = y;
                    c4 = d;
                    double a1 = 0.0;
                    double b1 = 1.0;
                    double a2 = y;
                    double b2 = d;
                    while (b2 > (scalefactor$26 = scalefactor)) {
                        double scalefactor$22 = scalefactor;
                        a1 /= scalefactor$22;
                        double scalefactor$23 = scalefactor;
                        b1 /= scalefactor$23;
                        double scalefactor$24 = scalefactor;
                        a2 /= scalefactor$24;
                        double scalefactor$25 = scalefactor;
                        b2 /= scalefactor$25;
                    }
                    double i = 0.0;
                    of = -1.0;
                    while (i < 200000.0) {
                        double d5;
                        double d6;
                        double c3 = (i += 1.0) * (c2 -= 1.0);
                        double d7 = (c4 += 2.0) * a2;
                        double d8 = c3 * a1;
                        a1 = d7 + d8;
                        double d9 = c4 * b2;
                        double d10 = c3 * b1;
                        b1 = d9 + d10;
                        c3 = (i += 1.0) * (c2 -= 1.0);
                        double d11 = (c4 += 2.0) * a1;
                        double d12 = c3 * a2;
                        a2 = d11 + d12;
                        double d13 = c4 * b1;
                        double d14 = c3 * b2;
                        double scalefactor$27 = scalefactor;
                        if ((b2 = d13 + d14) > scalefactor$27) {
                            double scalefactor$28 = scalefactor;
                            a1 /= scalefactor$28;
                            double scalefactor$29 = scalefactor;
                            b1 /= scalefactor$29;
                            double scalefactor$30 = scalefactor;
                            a2 /= scalefactor$30;
                            double scalefactor$31 = scalefactor;
                            b2 /= scalefactor$31;
                        }
                        if (b2 == 0.0) continue;
                        f = a2 / b2;
                        double d15 = Math.abs(f - of);
                        if (d15 <= (d6 = fmax2.fmax2(f0, d5 = Math.abs(f)) * 2.220446049250313E-16)) {
                            d2 = f;
                            break block9;
                        }
                        of = f;
                    }
                    Stdlib.printf((BytePtr)new BytePtr(" ** NON-convergence in pgamma()'s pd_lower_cf() f= %g.\n\u0000".getBytes(), 0), (Object[])new Object[]{f});
                    d2 = f;
                }
            }
        }
        return d2;
    }

    public static double pd_upper_series(double x, double y, int log_p) {
        double term;
        double sum = term = x / y;
        while ((sum += (term = x / (y += 1.0) * term)) * 2.220446049250313E-16 < term) {
        }
        double iftmp$32 = log_p != 0 ? Mathlib.log((double)sum) : sum;
        return iftmp$32;
    }

    public static double pgamma_smallx(double x, double alph, int lower_tail, int log_p) {
        double d;
        double d2;
        double d3;
        double term;
        double d4;
        double sum = 0.0;
        double c = alph;
        double n = 0.0;
        while ((d4 = Math.abs(term = (c = -x / (n += 1.0) * c) / (d3 = alph + n))) > (d2 = Math.abs(sum += term) * 2.220446049250313E-16)) {
        }
        if (lower_tail != 0) {
            double f2;
            double iftmp$33 = log_p != 0 ? Mathlib.log1p((double)sum) : sum + 1.0;
            double f1 = iftmp$33;
            if (alph > 1.0) {
                f2 = dpois.dpois_raw(alph, x, log_p);
                double iftmp$34 = log_p != 0 ? f2 + x : Mathlib.exp((double)x) * f2;
                f2 = iftmp$34;
            } else if (log_p != 0) {
                double d5 = Mathlib.log((double)x) * alph;
                double d6 = pgamma.lgamma1p(alph);
                f2 = d5 - d6;
            } else {
                double d7 = Mathlib.pow((double)x, (double)alph);
                double d8 = Mathlib.exp((double)pgamma.lgamma1p(alph));
                f2 = d7 / d8;
            }
            double iftmp$35 = log_p != 0 ? f1 + f2 : f1 * f2;
            d = iftmp$35;
        } else {
            double d9 = Mathlib.log((double)x) * alph;
            double d10 = pgamma.lgamma1p(alph);
            double lf2 = d9 - d10;
            if (log_p != 0) {
                double iftmp$36 = Mathlib.log1p((double)sum) + lf2 > -0.6931471805599453 ? Mathlib.log((double)(-Mathlib.expm1((double)(Mathlib.log1p((double)sum) + lf2)))) : Mathlib.log1p((double)(-Mathlib.exp((double)(Mathlib.log1p((double)sum) + lf2))));
                d = iftmp$36;
            } else {
                double f1m1 = sum;
                double f2m1 = Mathlib.expm1((double)lf2);
                double d11 = f1m1 + f2m1;
                double d12 = f1m1 * f2m1;
                d = -(d11 + d12);
            }
        }
        return d;
    }

    public static double dpois_wrap(double x_plus_1, double lambda, int log_p) {
        double d;
        if (!(Math.abs(lambda) <= Double.MAX_VALUE)) {
            double iftmp$37 = log_p != 0 ? -1.0 / 0.0 : 0.0;
            d = iftmp$37;
        } else if (x_plus_1 > 1.0) {
            d = dpois.dpois_raw(x_plus_1 - 1.0, lambda, log_p);
        } else {
            double d2 = Math.abs(x_plus_1 - 1.0);
            double M_cutoff$38 = M_cutoff;
            if (d2 * M_cutoff$38 < lambda) {
                double iftmp$39;
                if (log_p != 0) {
                    double d3 = -lambda;
                    double d4 = lgamma.lgammafn(x_plus_1);
                    iftmp$39 = d3 - d4;
                } else {
                    double d5 = -lambda;
                    double d6 = lgamma.lgammafn(x_plus_1);
                    iftmp$39 = Mathlib.exp((double)(d5 - d6));
                }
                d = iftmp$39;
            } else {
                double d7 = dpois.dpois_raw(x_plus_1, lambda, log_p);
                double iftmp$40 = log_p != 0 ? Mathlib.log((double)(x_plus_1 / lambda)) + d7 : x_plus_1 / lambda * d7;
                d = iftmp$40;
            }
        }
        return d;
    }

    public static double logspace_sum(Ptr logx, int n) {
        double d;
        double Mx = 0.0;
        if (n == 0) {
            d = -1.0 / 0.0;
        } else if (n == 1) {
            d = logx.getDouble();
        } else if (n == 2) {
            double d2 = logx.getDouble(8);
            d = pgamma.logspace_add(logx.getDouble(), d2);
        } else {
            Mx = logx.getDouble();
            int i = 1;
            while (i < n) {
                Ptr ptr = logx;
                int n2 = i * 8;
                int n3 = n2;
                if (ptr.getDouble(n3) > Mx) {
                    int n4 = i * 8;
                    Ptr ptr2 = logx;
                    int n5 = n4;
                    Mx = ptr2.getDouble(n5);
                }
                ++i;
            }
            double s = 0.0;
            i = 0;
            while (i < n) {
                int n6 = i * 8;
                Ptr ptr = logx;
                int n7 = n6;
                s = Mathlib.exp((double)(ptr.getDouble(n7) - Mx)) + s;
                ++i;
            }
            d = Mathlib.log((double)s) + Mx;
        }
        return d;
    }

    public static double logspace_sub(double logx, double logy) {
        double iftmp$44 = logy - logx > -0.6931471805599453 ? Mathlib.log((double)(-Mathlib.expm1((double)(logy - logx)))) : Mathlib.log1p((double)(-Mathlib.exp((double)(logy - logx))));
        return iftmp$44 + logx;
    }

    public static double logspace_add(double logx, double logy) {
        double d = fmax2.fmax2(logx, logy);
        double d2 = Mathlib.log1p((double)Mathlib.exp((double)(-Math.abs(logx - logy))));
        return d + d2;
    }

    public static double lgamma1p(double a) {
        double d;
        double eulers_const = 0.0;
        eulers_const = 0.5772156649015329;
        double c = 2.2737368458246524E-13;
        double tol_logcf = 1.0E-14;
        if (Math.abs(a) >= 0.5) {
            d = lgamma.lgammafn(a + 1.0);
        } else {
            double d2 = 42;
            double lgam = pgamma.logcf(-a / 2.0, d2, 1.0, tol_logcf) * c;
            int i = 39;
            while (i >= 0) {
                double d3 = $lgamma1p$coeffs[i];
                double d4 = a * lgam;
                lgam = d3 - d4;
                --i;
            }
            double d5 = (a * lgam - eulers_const) * a;
            double d6 = pgamma.log1pmx(a);
            d = d5 - d6;
        }
        return d;
    }

    public static double log1pmx(double x) {
        double d;
        double minLog1Value$45;
        if (x > 1.0 || x < (minLog1Value$45 = $log1pmx$minLog1Value)) {
            d = Mathlib.log1p((double)x) - x;
        } else {
            double r;
            double d2 = x + 2.0;
            double d3 = r = x / d2;
            double y = d3 * d3;
            if (Math.abs(x) < 0.01) {
                double d4 = $log1pmx$two / 9.0 * y;
                double d5 = $log1pmx$two / 7.0;
                double d6 = (d4 + d5) * y;
                double d7 = $log1pmx$two / 5.0;
                double d8 = (d6 + d7) * y;
                double d9 = $log1pmx$two / 3.0;
                d = ((d8 + d9) * y - x) * r;
            } else {
                double d10 = y * 2.0;
                double tol_logcf$50 = $log1pmx$tol_logcf;
                double d11 = pgamma.logcf(y, 3.0, 2.0, tol_logcf$50);
                d = (d10 * d11 - x) * r;
            }
        }
        return d;
    }

    public static double logcf(double x, double i, double d, double eps) {
        double d2;
        double d3;
        double d4;
        double d5;
        double c1 = d * 2.0;
        double c2 = i + d;
        double c4 = c2 + d;
        double a1 = c2;
        double d6 = i * x;
        double b1 = (c2 - d6) * i;
        double d7 = d;
        double b2 = d7 * d7 * x;
        double a2 = c4 * c2 - b2;
        double d8 = c4 * b1;
        double d9 = i * b2;
        b2 = d8 - d9;
        while ((d5 = Math.abs((d4 = a2 * b1) - (d3 = a1 * b2))) > (d2 = Math.abs(eps * b1 * b2))) {
            double scalefactor$51;
            double d10 = c2;
            double c3 = d10 * d10 * x;
            c2 += d;
            double d11 = (c4 += d) * a2;
            double d12 = c3 * a1;
            a1 = d11 - d12;
            double d13 = c4 * b2;
            double d14 = c3 * b1;
            b1 = d13 - d14;
            double d15 = c1;
            c3 = d15 * d15 * x;
            c1 += d;
            double d16 = (c4 += d) * a1;
            double d17 = c3 * a2;
            a2 = d16 - d17;
            double d18 = c4 * b1;
            double d19 = c3 * b2;
            double d20 = Math.abs(b2 = d18 - d19);
            if (d20 > (scalefactor$51 = scalefactor)) {
                double scalefactor$52 = scalefactor;
                a1 /= scalefactor$52;
                double scalefactor$53 = scalefactor;
                b1 /= scalefactor$53;
                double scalefactor$54 = scalefactor;
                a2 /= scalefactor$54;
                double scalefactor$55 = scalefactor;
                b2 /= scalefactor$55;
                continue;
            }
            double d21 = Math.abs(b2);
            double scalefactor$56 = scalefactor;
            double d22 = 1.0 / scalefactor$56;
            if (!(d21 < d22)) continue;
            double scalefactor$57 = scalefactor;
            a1 *= scalefactor$57;
            double scalefactor$58 = scalefactor;
            b1 *= scalefactor$58;
            double scalefactor$59 = scalefactor;
            a2 *= scalefactor$59;
            double scalefactor$60 = scalefactor;
            b2 *= scalefactor$60;
        }
        return a2 / b2;
    }

    static {
        coeffs$4378 = new double[40];
        coefs_b$4489 = new double[8];
        coefs_a$4488 = new double[8];
        $ppois_asymp$coefs_b = new double[8];
        $ppois_asymp$coefs_a = new double[8];
        $lgamma1p$coeffs = new double[40];
        tol_logcf$4372 = 1.0E-14;
        two$4371 = 2.0;
        minLog1Value$4368 = -0.79149064;
        pgamma.coeffs$4378$$clinit();
        pgamma.coefs_b$4489$$clinit();
        pgamma.coefs_a$4488$$clinit();
        M_cutoff = 3.196577161300664E18;
        scalefactor = 1.157920892373162E77;
        System.arraycopy(new double[]{-1.0E99, 0.08333333333333333, 0.003472222222222222, -0.0026813271604938273, -2.2947209362139917E-4, 7.840392217200666E-4, 6.972813758365857E-5, -5.921664373536939E-4}, 0, $ppois_asymp$coefs_b, 0, 8);
        System.arraycopy(new double[]{-1.0E99, 0.6666666666666666, -0.02962962962962963, 0.0028218694885361554, 0.0018812463256907702, -7.119598889146215E-4, -6.783725850941215E-4, 4.728641948577934E-4}, 0, $ppois_asymp$coefs_a, 0, 8);
        System.arraycopy(new double[]{0.3224670334241132, 0.0673523010531981, 0.020580808427784546, 0.007385551028673986, 0.0028905103307415234, 0.001192753911703261, 5.096695247430425E-4, 2.2315475845357939E-4, 9.945751278180853E-5, 4.492623673813314E-5, 2.050721277567069E-5, 9.439488275268397E-6, 4.374866789907488E-6, 2.039215753801366E-6, 9.55141213040742E-7, 4.492469198764566E-7, 2.1207184805554665E-7, 1.0043224823968099E-7, 4.7698101693639804E-8, 2.2711094608943164E-8, 1.0838659214896955E-8, 5.183475041970047E-9, 2.4836745438024785E-9, 1.1921401405860912E-9, 5.731367241678862E-10, 2.7595228851242334E-10, 1.330476437424449E-10, 6.4229645638381E-11, 3.1044247747322276E-11, 1.5021384080754142E-11, 7.275974480239079E-12, 3.527742476575915E-12, 1.711991790559618E-12, 8.315385841420285E-13, 4.04220052528944E-13, 1.9664756310966165E-13, 9.573630387838556E-14, 4.6640760264283744E-14, 2.2737369600659724E-14, 1.1091399470834522E-14}, 0, $lgamma1p$coeffs, 0, 40);
        $log1pmx$tol_logcf = 1.0E-14;
        $log1pmx$two = 2.0;
        $log1pmx$minLog1Value = -0.79149064;
    }

    static void coeffs$4378$$clinit() {
        System.arraycopy(new double[]{0.3224670334241132, 0.0673523010531981, 0.020580808427784546, 0.007385551028673986, 0.0028905103307415234, 0.001192753911703261, 5.096695247430425E-4, 2.2315475845357939E-4, 9.945751278180853E-5, 4.492623673813314E-5, 2.050721277567069E-5, 9.439488275268397E-6, 4.374866789907488E-6, 2.039215753801366E-6, 9.55141213040742E-7, 4.492469198764566E-7, 2.1207184805554665E-7, 1.0043224823968099E-7, 4.7698101693639804E-8, 2.2711094608943164E-8, 1.0838659214896955E-8, 5.183475041970047E-9, 2.4836745438024785E-9, 1.1921401405860912E-9, 5.731367241678862E-10, 2.7595228851242334E-10, 1.330476437424449E-10, 6.4229645638381E-11, 3.1044247747322276E-11, 1.5021384080754142E-11, 7.275974480239079E-12, 3.527742476575915E-12, 1.711991790559618E-12, 8.315385841420285E-13, 4.04220052528944E-13, 1.9664756310966165E-13, 9.573630387838556E-14, 4.6640760264283744E-14, 2.2737369600659724E-14, 1.1091399470834522E-14}, 0, coeffs$4378, 0, 40);
    }

    static void coefs_b$4489$$clinit() {
        System.arraycopy(new double[]{-1.0E99, 0.08333333333333333, 0.003472222222222222, -0.0026813271604938273, -2.2947209362139917E-4, 7.840392217200666E-4, 6.972813758365857E-5, -5.921664373536939E-4}, 0, coefs_b$4489, 0, 8);
    }

    static void coefs_a$4488$$clinit() {
        System.arraycopy(new double[]{-1.0E99, 0.6666666666666666, -0.02962962962962963, 0.0028218694885361554, 0.0018812463256907702, -7.119598889146215E-4, -6.783725850941215E-4, 4.728641948577934E-4}, 0, coefs_a$4488, 0, 8);
    }
}

