/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.dhyper;

public class phyper {
    private phyper() {
    }

    public static double phyper(double x, double NR, double NB, double n, int lower_tail, int log_p) {
        double d;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(NR) || Double.isNaN(NR) || Double.isNaN(NB) || Double.isNaN(NB) || Double.isNaN(n) || Double.isNaN(n)) {
            d = x + NR + NB + n;
        } else {
            x = Mathlib.floor((double)(x + 1.0E-7));
            NR = Mathlib.round((double)NR);
            NB = Mathlib.round((double)NB);
            n = Mathlib.round((double)n);
            if (NR < 0.0 || NB < 0.0 || !(Math.abs(NR + NB) <= Double.MAX_VALUE) || n < 0.0 || NR + NB < n) {
                d = 0.0 / 0.0;
            } else {
                double d2 = (NR + NB) * x;
                double d3 = n * NR;
                if (d2 > d3) {
                    double oldNB = NB;
                    NB = NR;
                    NR = oldNB;
                    x = n - x - 1.0;
                    int n2 = lower_tail = lower_tail != 0 ? 0 : 1;
                }
                if (x < 0.0) {
                    double iftmp$0;
                    if (lower_tail != 0) {
                        double iftmp$1 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                        iftmp$0 = iftmp$1;
                    } else {
                        double iftmp$2 = log_p != 0 ? 0.0 : 1.0;
                        iftmp$0 = iftmp$2;
                    }
                    d = iftmp$0;
                } else if (x >= NR || x >= n) {
                    double iftmp$3;
                    if (lower_tail != 0) {
                        double iftmp$4 = log_p != 0 ? 0.0 : 1.0;
                        iftmp$3 = iftmp$4;
                    } else {
                        double iftmp$5 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                        iftmp$3 = iftmp$5;
                    }
                    d = iftmp$3;
                } else {
                    double iftmp$6;
                    double d4 = dhyper.dhyper(x, NR, NB, n, log_p);
                    double pd = phyper.pdhyper(x, NR, NB, n, log_p);
                    if (log_p != 0) {
                        double iftmp$7;
                        if (lower_tail != 0) {
                            iftmp$7 = d4 + pd;
                        } else {
                            double iftmp$8 = d4 + pd > -0.6931471805599453 ? Mathlib.log((double)(-Mathlib.expm1((double)(d4 + pd)))) : Mathlib.log1p((double)(-Mathlib.exp((double)(d4 + pd))));
                            iftmp$7 = iftmp$8;
                        }
                        iftmp$6 = iftmp$7;
                    } else {
                        double iftmp$9;
                        if (lower_tail != 0) {
                            iftmp$9 = d4 * pd;
                        } else {
                            double d5 = d4 * pd;
                            iftmp$9 = 0.5 - d5 + 0.5;
                        }
                        iftmp$6 = iftmp$9;
                    }
                    d = iftmp$6;
                }
            }
        }
        return d;
    }

    public static double pdhyper(double x, double NR, double NB, double n, int log_p) {
        double sum = 0.0;
        double term = 1.0;
        while (x > 0.0 && sum * 2.220446049250313E-16 <= term) {
            double d = (NB - n + x) * x;
            double d2 = n + 1.0 - x;
            double d3 = d / d2;
            double d4 = NR + 1.0 - x;
            term = d3 / d4 * term;
            sum += term;
            x -= 1.0;
        }
        double ss = sum;
        double iftmp$10 = log_p != 0 ? Mathlib.log1p((double)ss) : ss + 1.0;
        return iftmp$10;
    }
}

