/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.pnorm;

public class plnorm {
    private plnorm() {
    }

    public static double plnorm(double x, double meanlog, double sdlog, int lower_tail, int log_p) {
        double d;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(meanlog) || Double.isNaN(meanlog) || Double.isNaN(sdlog) || Double.isNaN(sdlog)) {
            d = x + meanlog + sdlog;
        } else if (sdlog < 0.0) {
            d = 0.0 / 0.0;
        } else if (x > 0.0) {
            d = pnorm.pnorm5(Mathlib.log((double)x), meanlog, sdlog, lower_tail, log_p);
        } else {
            double iftmp$0;
            if (lower_tail != 0) {
                double iftmp$1 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$0 = iftmp$1;
            } else {
                double iftmp$2 = log_p != 0 ? 0.0 : 1.0;
                iftmp$0 = iftmp$2;
            }
            d = iftmp$0;
        }
        return d;
    }
}

