/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Mathlib;

public class plogis {
    private plogis() {
    }

    public static double plogis(double x, double location, double scale, int lower_tail, int log_p) {
        double d;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(location) || Double.isNaN(location) || Double.isNaN(scale) || Double.isNaN(scale)) {
            d = x + location + scale;
        } else if (scale <= 0.0) {
            d = 0.0 / 0.0;
        } else {
            x = (x - location) / scale;
            if (Double.isNaN(x) || Double.isNaN(x)) {
                d = 0.0 / 0.0;
            } else if (!(Math.abs(x) <= Double.MAX_VALUE)) {
                if (x > 0.0) {
                    double iftmp$0;
                    if (lower_tail != 0) {
                        double iftmp$1 = log_p != 0 ? 0.0 : 1.0;
                        iftmp$0 = iftmp$1;
                    } else {
                        double iftmp$2 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                        iftmp$0 = iftmp$2;
                    }
                    d = iftmp$0;
                } else {
                    double iftmp$3;
                    if (lower_tail != 0) {
                        double iftmp$4 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                        iftmp$3 = iftmp$4;
                    } else {
                        double iftmp$5 = log_p != 0 ? 0.0 : 1.0;
                        iftmp$3 = iftmp$5;
                    }
                    d = iftmp$3;
                }
            } else if (log_p != 0) {
                double iftmp$6 = lower_tail != 0 ? -x : x;
                d = -plogis.Rf_log1pexp(iftmp$6);
            } else {
                double iftmp$7 = lower_tail != 0 ? -x : x;
                double d2 = Mathlib.exp((double)iftmp$7) + 1.0;
                d = 1.0 / d2;
            }
        }
        return d;
    }

    public static double Rf_log1pexp(double x) {
        double d = x <= 18.0 ? Mathlib.log1p((double)Mathlib.exp((double)x)) : (x > 33.3 ? x : Mathlib.exp((double)(-x)) + x);
        return d;
    }
}

