/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.fmax2;
import org.renjin.nmath.lgamma;
import org.renjin.nmath.toms708;

public class pnbeta {
    public static double errmax$4353 = 1.0E-9;
    public static double $Rf_pnbeta_raw$errmax = 1.0E-9;

    private pnbeta() {
    }

    public static double pnbeta(double x, double a, double b, double ncp, int lower_tail, int log_p) {
        double d;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(a) || Double.isNaN(b) || Double.isNaN(b) || Double.isNaN(ncp) || Double.isNaN(ncp)) {
            d = x + a + b + ncp;
        } else if (x <= 0.0) {
            double iftmp$0;
            if (lower_tail != 0) {
                double iftmp$1 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$0 = iftmp$1;
            } else {
                double iftmp$2 = log_p != 0 ? 0.0 : 1.0;
                iftmp$0 = iftmp$2;
            }
            d = iftmp$0;
        } else if (x >= 1.0) {
            double iftmp$3;
            if (lower_tail != 0) {
                double iftmp$4 = log_p != 0 ? 0.0 : 1.0;
                iftmp$3 = iftmp$4;
            } else {
                double iftmp$5 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$3 = iftmp$5;
            }
            d = iftmp$3;
        } else {
            double d2 = 1.0 - x;
            d = pnbeta.Rf_pnbeta2(x, d2, a, b, ncp, lower_tail, log_p);
        }
        return d;
    }

    public static double Rf_pnbeta2(double x, double o_x, double a, double b, double ncp, int lower_tail, int log_p) {
        double d;
        double ans = pnbeta.Rf_pnbeta_raw(x, o_x, a, b, ncp);
        if (lower_tail != 0) {
            double iftmp$6 = log_p != 0 ? Mathlib.log((double)ans) : ans;
            d = iftmp$6;
        } else {
            if (ans > 0.9999999999) {
                BytePtr msg = new BytePtr("\u0000".getBytes(), 0);
                int msg$offset = 0;
                msg = new BytePtr("full precision may not have been achieved in '%s'\n\u0000".getBytes(), 0);
                msg$offset = 0;
                Stdlib.printf((BytePtr)((BytePtr)msg.pointerPlus(msg$offset)), (Object[])new Object[]{new BytePtr("pnbeta\u0000".getBytes(), 0)});
            }
            if (ans > 1.0) {
                ans = 1.0;
            }
            double iftmp$7 = log_p != 0 ? Mathlib.log1p((double)(-ans)) : 1.0 - ans;
            d = iftmp$7;
        }
        return d;
    }

    public static double Rf_pnbeta_raw(double x, double o_x, double a, double b, double ncp) {
        double d;
        int[] ierr = new int[1];
        double[] tmp_c = new double[1];
        double[] temp = new double[1];
        ierr[0] = 0;
        tmp_c[0] = 0.0;
        temp[0] = 0.0;
        double x0 = 0.0;
        double c = 0.0;
        int itrmax = 0;
        itrmax = 10000;
        if (ncp < 0.0 || a <= 0.0 || b <= 0.0) {
            d = 0.0 / 0.0;
        } else if (x < 0.0 || o_x > 1.0 || x == 0.0 && o_x == 1.0) {
            d = 0.0;
        } else if (x > 1.0 || o_x < 0.0 || x == 1.0 && o_x == 0.0) {
            d = 1.0;
        } else {
            double errmax$14;
            double errbd;
            double ax;
            double q;
            c = ncp / 2.0;
            double d2 = Mathlib.sqrt((double)c) * 7.0;
            x0 = Mathlib.floor((double)fmax2.fmax2(c - d2, 0.0));
            double a0 = a + x0;
            double d3 = lgamma.lgammafn(a0);
            double d4 = lgamma.lgammafn(b);
            double d5 = d3 + d4;
            double d6 = lgamma.lgammafn(a0 + b);
            double lbeta2 = d5 - d6;
            toms708.Rf_bratio(a0, b, x, o_x, (Ptr)new DoublePtr(temp, 0), (Ptr)new DoublePtr(tmp_c, 0), (Ptr)new IntPtr(ierr, 0), 0);
            double d7 = Mathlib.log((double)x) * a0;
            double iftmp$8 = x < 0.5 ? Mathlib.log1p((double)(-x)) : Mathlib.log((double)o_x);
            double d8 = iftmp$8 * b;
            double d9 = d7 + d8 - lbeta2;
            double d10 = Mathlib.log((double)a0);
            double gx = Mathlib.exp((double)(d9 - d10));
            if (a0 > a) {
                double d11 = Mathlib.log((double)c) * x0 - c;
                double d12 = lgamma.lgammafn(x0 + 1.0);
                q = Mathlib.exp((double)(d11 - d12));
            } else {
                q = Mathlib.exp((double)(-c));
            }
            double sumq = 1.0 - q;
            double temp$9 = temp[0];
            double ans = ax = q * temp$9;
            double j = Mathlib.floor((double)x0);
            do {
                double temp$11;
                temp[0] = temp$11 = temp[0] - gx;
                double d13 = (a + b + (j += 1.0) - 1.0) * x;
                double d14 = a + j;
                gx = d13 / d14 * gx;
                q = c / j * q;
                ax = temp[0] * q;
                ans += ax;
            } while ((errbd = (temp[0] - gx) * (sumq -= q)) > (errmax$14 = $Rf_pnbeta_raw$errmax) && (double)itrmax + x0 > j);
            double errmax$15 = $Rf_pnbeta_raw$errmax;
            if (errbd > errmax$15) {
                BytePtr msg = new BytePtr("\u0000".getBytes(), 0);
                int msg$offset = 0;
                msg = new BytePtr("full precision may not have been achieved in '%s'\n\u0000".getBytes(), 0);
                msg$offset = 0;
                Stdlib.printf((BytePtr)((BytePtr)msg.pointerPlus(msg$offset)), (Object[])new Object[]{new BytePtr("pnbeta\u0000".getBytes(), 0)});
            }
            if ((double)itrmax + x0 <= j) {
                BytePtr msg = new BytePtr("\u0000".getBytes(), 0);
                int msg$offset = 0;
                msg = new BytePtr("convergence failed in '%s'\n\u0000".getBytes(), 0);
                msg$offset = 0;
                Stdlib.printf((BytePtr)((BytePtr)msg.pointerPlus(msg$offset)), (Object[])new Object[]{new BytePtr("pnbeta\u0000".getBytes(), 0)});
            }
            d = ans;
        }
        return d;
    }
}

