/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.pbeta;
import org.renjin.nmath.ppois;
import org.renjin.nmath.toms708;

public class pnbinom {
    private pnbinom() {
    }

    public static double pnbinom_mu(double x, double size, double mu, int lower_tail, int log_p) {
        double d;
        double[] wc = new double[1];
        double[] w = new double[1];
        int[] ierr = new int[1];
        wc[0] = 0.0;
        w[0] = 0.0;
        ierr[0] = 0;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(size) || Double.isNaN(size) || Double.isNaN(mu) || Double.isNaN(mu)) {
            d = x + size + mu;
        } else if (!(Math.abs(mu) <= Double.MAX_VALUE)) {
            d = 0.0 / 0.0;
        } else if (size < 0.0 || mu < 0.0) {
            d = 0.0 / 0.0;
        } else if (size == 0.0) {
            double iftmp$0;
            if (x >= 0.0) {
                double iftmp$1;
                if (lower_tail != 0) {
                    double iftmp$2 = log_p != 0 ? 0.0 : 1.0;
                    iftmp$1 = iftmp$2;
                } else {
                    double iftmp$3 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                    iftmp$1 = iftmp$3;
                }
                iftmp$0 = iftmp$1;
            } else {
                double iftmp$4;
                if (lower_tail != 0) {
                    double iftmp$5 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                    iftmp$4 = iftmp$5;
                } else {
                    double iftmp$6 = log_p != 0 ? 0.0 : 1.0;
                    iftmp$4 = iftmp$6;
                }
                iftmp$0 = iftmp$4;
            }
            d = iftmp$0;
        } else if (x < 0.0) {
            double iftmp$7;
            if (lower_tail != 0) {
                double iftmp$8 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$7 = iftmp$8;
            } else {
                double iftmp$9 = log_p != 0 ? 0.0 : 1.0;
                iftmp$7 = iftmp$9;
            }
            d = iftmp$7;
        } else if (!(Math.abs(x) <= Double.MAX_VALUE)) {
            double iftmp$10;
            if (lower_tail != 0) {
                double iftmp$11 = log_p != 0 ? 0.0 : 1.0;
                iftmp$10 = iftmp$11;
            } else {
                double iftmp$12 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$10 = iftmp$12;
            }
            d = iftmp$10;
        } else if (!(Math.abs(size) <= Double.MAX_VALUE)) {
            d = ppois.ppois(x, mu, lower_tail, log_p);
        } else {
            x = Mathlib.floor((double)(x + 1.0E-7));
            double d2 = size + mu;
            double d3 = mu / d2;
            double d4 = size + mu;
            double d5 = size / d4;
            double d6 = x + 1.0;
            toms708.Rf_bratio(size, d6, d5, d3, (Ptr)new DoublePtr(w, 0), (Ptr)new DoublePtr(wc, 0), (Ptr)new IntPtr(ierr, 0), log_p);
            if (ierr[0] != 0) {
                int ierr$14 = ierr[0];
                Stdlib.printf((BytePtr)new BytePtr("pnbinom_mu() -> bratio() gave error code %d\u0000".getBytes(), 0), (Object[])new Object[]{ierr$14});
            }
            double iftmp$15 = lower_tail != 0 ? w[0] : wc[0];
            d = iftmp$15;
        }
        return d;
    }

    public static double pnbinom(double x, double size, double prob, int lower_tail, int log_p) {
        double d;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(size) || Double.isNaN(size) || Double.isNaN(prob) || Double.isNaN(prob)) {
            d = x + size + prob;
        } else if (!(Math.abs(size) <= Double.MAX_VALUE) || !(Math.abs(prob) <= Double.MAX_VALUE)) {
            d = 0.0 / 0.0;
        } else if (size < 0.0 || prob <= 0.0 || prob > 1.0) {
            d = 0.0 / 0.0;
        } else if (size == 0.0) {
            double iftmp$16;
            if (x >= 0.0) {
                double iftmp$17;
                if (lower_tail != 0) {
                    double iftmp$18 = log_p != 0 ? 0.0 : 1.0;
                    iftmp$17 = iftmp$18;
                } else {
                    double iftmp$19 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                    iftmp$17 = iftmp$19;
                }
                iftmp$16 = iftmp$17;
            } else {
                double iftmp$20;
                if (lower_tail != 0) {
                    double iftmp$21 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                    iftmp$20 = iftmp$21;
                } else {
                    double iftmp$22 = log_p != 0 ? 0.0 : 1.0;
                    iftmp$20 = iftmp$22;
                }
                iftmp$16 = iftmp$20;
            }
            d = iftmp$16;
        } else if (x < 0.0) {
            double iftmp$23;
            if (lower_tail != 0) {
                double iftmp$24 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$23 = iftmp$24;
            } else {
                double iftmp$25 = log_p != 0 ? 0.0 : 1.0;
                iftmp$23 = iftmp$25;
            }
            d = iftmp$23;
        } else if (!(Math.abs(x) <= Double.MAX_VALUE)) {
            double iftmp$26;
            if (lower_tail != 0) {
                double iftmp$27 = log_p != 0 ? 0.0 : 1.0;
                iftmp$26 = iftmp$27;
            } else {
                double iftmp$28 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$26 = iftmp$28;
            }
            d = iftmp$26;
        } else {
            x = Mathlib.floor((double)(x + 1.0E-7));
            double d2 = x + 1.0;
            d = pbeta.pbeta(prob, size, d2, lower_tail, log_p);
        }
        return d;
    }
}

