/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.nmath.pnbeta;
import org.renjin.nmath.pnchisq;

public class pnf {
    private pnf() {
    }

    public static double pnf(double x, double df1, double df2, double ncp, int lower_tail, int log_p) {
        double d;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(df1) || Double.isNaN(df1) || Double.isNaN(df2) || Double.isNaN(df2) || Double.isNaN(ncp) || Double.isNaN(ncp)) {
            d = x + df2 + df1 + ncp;
        } else if (df1 <= 0.0 || df2 <= 0.0 || ncp < 0.0) {
            d = 0.0 / 0.0;
        } else if (!(Math.abs(ncp) <= Double.MAX_VALUE)) {
            d = 0.0 / 0.0;
        } else if (!(Math.abs(df1) <= Double.MAX_VALUE) && !(Math.abs(df2) <= Double.MAX_VALUE)) {
            d = 0.0 / 0.0;
        } else if (x <= 0.0) {
            double iftmp$0;
            if (lower_tail != 0) {
                double iftmp$1 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$0 = iftmp$1;
            } else {
                double iftmp$2 = log_p != 0 ? 0.0 : 1.0;
                iftmp$0 = iftmp$2;
            }
            d = iftmp$0;
        } else {
            double d2 = 1.0 / 0.0;
            if (x >= d2) {
                double iftmp$3;
                if (lower_tail != 0) {
                    double iftmp$4 = log_p != 0 ? 0.0 : 1.0;
                    iftmp$3 = iftmp$4;
                } else {
                    double iftmp$5 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                    iftmp$3 = iftmp$5;
                }
                d = iftmp$3;
            } else if (df2 > 1.0E8) {
                d = pnchisq.pnchisq(x * df1, df1, ncp, lower_tail, log_p);
            } else {
                double y = df1 / df2 * x;
                double d3 = df2 / 2.0;
                double d4 = df1 / 2.0;
                double d5 = y + 1.0;
                double d6 = 1.0 / d5;
                double d7 = y + 1.0;
                d = pnbeta.Rf_pnbeta2(y / d7, d6, d4, d3, ncp, lower_tail, log_p);
            }
        }
        return d;
    }
}

