/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.d1mach;
import org.renjin.nmath.fmax2;
import org.renjin.nmath.fmin2;
import org.renjin.nmath.i1mach;
import org.renjin.nmath.imin2;
import org.renjin.nmath.mlutils;

public class polygamma {
    public static double[] bvalues$4360 = new double[22];
    public static double[] $dpsifn$bvalues = new double[22];

    private polygamma() {
    }

    public static double pentagamma(double x) {
        double d;
        int[] ierr = new int[1];
        int[] nz = new int[1];
        double[] ans = new double[1];
        ierr[0] = 0;
        nz[0] = 0;
        ans[0] = 0.0;
        if (Double.isNaN(x) || Double.isNaN(x)) {
            d = x;
        } else {
            polygamma.dpsifn(x, 3, 1, 1, (Ptr)new DoublePtr(ans, 0), (Ptr)new IntPtr(nz, 0), (Ptr)new IntPtr(ierr, 0));
            if (ierr[0] != 0) {
                Builtins.__errno_location().setInt(0, 33);
                d = 0.0 / 0.0;
            } else {
                d = ans[0] * 6.0;
            }
        }
        return d;
    }

    public static double tetragamma(double x) {
        double d;
        int[] ierr = new int[1];
        int[] nz = new int[1];
        double[] ans = new double[1];
        ierr[0] = 0;
        nz[0] = 0;
        ans[0] = 0.0;
        if (Double.isNaN(x) || Double.isNaN(x)) {
            d = x;
        } else {
            polygamma.dpsifn(x, 2, 1, 1, (Ptr)new DoublePtr(ans, 0), (Ptr)new IntPtr(nz, 0), (Ptr)new IntPtr(ierr, 0));
            if (ierr[0] != 0) {
                Builtins.__errno_location().setInt(0, 33);
                d = 0.0 / 0.0;
            } else {
                d = ans[0] * -2.0;
            }
        }
        return d;
    }

    public static double trigamma(double x) {
        double d;
        int[] ierr = new int[1];
        int[] nz = new int[1];
        double[] ans = new double[1];
        ierr[0] = 0;
        nz[0] = 0;
        ans[0] = 0.0;
        if (Double.isNaN(x) || Double.isNaN(x)) {
            d = x;
        } else {
            polygamma.dpsifn(x, 1, 1, 1, (Ptr)new DoublePtr(ans, 0), (Ptr)new IntPtr(nz, 0), (Ptr)new IntPtr(ierr, 0));
            if (ierr[0] != 0) {
                Builtins.__errno_location().setInt(0, 33);
                d = 0.0 / 0.0;
            } else {
                d = ans[0];
            }
        }
        return d;
    }

    public static double digamma(double x) {
        double d;
        int[] ierr = new int[1];
        int[] nz = new int[1];
        double[] ans = new double[1];
        ierr[0] = 0;
        nz[0] = 0;
        ans[0] = 0.0;
        if (Double.isNaN(x) || Double.isNaN(x)) {
            d = x;
        } else {
            polygamma.dpsifn(x, 0, 1, 1, (Ptr)new DoublePtr(ans, 0), (Ptr)new IntPtr(nz, 0), (Ptr)new IntPtr(ierr, 0));
            if (ierr[0] != 0) {
                Builtins.__errno_location().setInt(0, 33);
                d = 0.0 / 0.0;
            } else {
                d = -ans[0];
            }
        }
        return d;
    }

    public static double psigamma(double x, double deriv) {
        double d;
        int[] ierr = new int[1];
        int[] nz = new int[1];
        double[] ans = new double[1];
        int n = 0;
        ierr[0] = 0;
        nz[0] = 0;
        ans[0] = 0.0;
        if (Double.isNaN(x) || Double.isNaN(x)) {
            d = x;
        } else {
            deriv = Mathlib.round((double)deriv);
            n = (int)deriv;
            if (n > 100) {
                Stdlib.printf((BytePtr)new BytePtr("deriv = %d > %d (= n_max)\n\u0000".getBytes(), 0), (Object[])new Object[]{n, 100});
                d = 0.0 / 0.0;
            } else {
                polygamma.dpsifn(x, n, 1, 1, (Ptr)new DoublePtr(ans, 0), (Ptr)new IntPtr(nz, 0), (Ptr)new IntPtr(ierr, 0));
                if (ierr[0] != 0) {
                    Builtins.__errno_location().setInt(0, 33);
                    d = 0.0 / 0.0;
                } else {
                    double ans$9;
                    ans[0] = ans$9 = -ans[0];
                    int k = 1;
                    while (k <= n) {
                        double ans$11;
                        double d2 = -k;
                        double ans$10 = ans[0];
                        ans[0] = ans$11 = d2 * ans$10;
                        ++k;
                    }
                    d = ans[0];
                }
            }
        }
        return d;
    }

    /*
     * Unable to fully structure code
     */
    public static void dpsifn(double x, int n, int kode, int m, Ptr ans, Ptr nz, Ptr ierr) {
        block41: {
            block49: {
                block50: {
                    block42: {
                        block47: {
                            block48: {
                                block44: {
                                    block46: {
                                        block45: {
                                            block43: {
                                                trmr = new double[101];
                                                trm = new double[23];
                                                xln = 0.0;
                                                xinc = 0.0;
                                                xdmy = 0.0;
                                                xdmln = 0.0;
                                                wdtol = 0.0;
                                                t2 = 0.0;
                                                t1 = 0.0;
                                                tt = 0.0;
                                                tst = 0.0;
                                                tss = 0.0;
                                                tols = 0.0;
                                                tol = 0.0;
                                                ta = 0.0;
                                                t = 0.0;
                                                r1m5 = 0.0;
                                                rxsq = 0.0;
                                                elim = 0.0;
                                                fn = 0;
                                                nx = 0;
                                                np = 0;
                                                nn = 0;
                                                mm = 0;
                                                j = 0;
                                                xln = 0.0;
                                                ierr.setInt(0);
                                                if (n >= 0 && kode > 0 && kode <= 2 && m > 0) break block43;
                                                ierr.setInt(1);
                                                break block41;
                                            }
                                            if (!(x <= 0.0)) break block44;
                                            if (Mathlib.round((double)x) != x) break block45;
                                            j = 0;
                                            while (j < m) {
                                                var392_35 = j * 8;
                                                var390_33 = ans;
                                                var391_34 = var392_35;
                                                iftmp$13 = (j + n & 1) != 0 ? 1.0 / 0.0 : 0.0 / 0.0;
                                                var390_33.setDouble(var391_34, iftmp$13);
                                                ++j;
                                            }
                                            break block41;
                                        }
                                        polygamma.dpsifn(1.0 - x, n, 1, m, ans, nz, ierr);
                                        if (m <= 1 && n <= 3) break block46;
                                        ierr.setInt(4);
                                        break block41;
                                    }
                                    x *= 3.141592653589793;
                                    if (n == 0) {
                                        var381_36 = Mathlib.cos((double)x);
                                        var379_37 = Mathlib.sin((double)x);
                                        tt = var381_36 / var379_37;
                                    } else if (n == 1) {
                                        var375_38 = mlutils.R_pow_di(Mathlib.sin((double)x), 2);
                                        tt = -1.0 / var375_38;
                                    } else if (n == 2) {
                                        var371_39 = Mathlib.cos((double)x) * 2.0;
                                        var367_40 = mlutils.R_pow_di(Mathlib.sin((double)x), 3);
                                        tt = var371_39 / var367_40;
                                    } else if (n == 3) {
                                        var357_41 = (mlutils.R_pow_di(Mathlib.cos((double)x), 2) * 2.0 + 1.0) * -2.0;
                                        var353_42 = mlutils.R_pow_di(Mathlib.sin((double)x), 4);
                                        tt = var357_41 / var353_42;
                                    } else {
                                        tt = 0.0 / 0.0;
                                    }
                                    iftmp$14 = (n & 1) != 0 ? -1.0 : 1.0;
                                    s = iftmp$14;
                                    t1 = t2 = (s = 1.0);
                                    k = 0;
                                    j = k - n;
                                    while (j < m) {
                                        t1 *= 3.141592653589793;
                                        if (k > 1) {
                                            t2 = (double)k * t2;
                                        }
                                        if (j >= 0) {
                                            var345_58 = j * 8;
                                            var343_56 = ans;
                                            var344_57 = var345_58;
                                            var341_55 = j * 8;
                                            var339_53 = ans;
                                            var340_54 = var341_55;
                                            var337_52 = var339_53.getDouble(var340_54);
                                            var333_51 = t1 / t2 * tt;
                                            var329_50 = (var337_52 + var333_51) * s;
                                            var343_56.setDouble(var344_57, var329_50);
                                        }
                                        ++k;
                                        ++j;
                                        s = -s;
                                    }
                                    if (n != 0 || kode != 2) break block41;
                                    var325_59 = ans.getDouble() + xln;
                                    ans.setDouble(var325_59);
                                    break block41;
                                }
                                nz.setInt(0);
                                xln = Mathlib.log((double)x);
                                if (kode != 1 || m != 1) break block47;
                                lrg = 2.251799813685248E15;
                                if (n != 0 || !(x * xln > lrg)) break block48;
                                var321_61 = -xln;
                                ans.setDouble(var321_61);
                                break block41;
                            }
                            if (n <= 0 || !((double)n * lrg < x)) break block47;
                            var310_62 = Mathlib.exp((double)((double)(-n) * xln));
                            var308_63 = n;
                            var306_64 = var310_62 / var308_63;
                            ans.setDouble(var306_64);
                            break block41;
                        }
                        mm = m;
                        var305_65 = i1mach.Rf_i1mach(16);
                        nx = imin2.imin2(-i1mach.Rf_i1mach(15), var305_65);
                        r1m5 = d1mach.Rf_d1mach(5);
                        wdtol = fmax2.fmax2(d1mach.Rf_d1mach(4) * 0.5, 5.0E-19);
                        elim = ((double)nx * r1m5 - 3.0) * 2.302;
                        while (true) {
                            if (Math.abs(t = (double)((fn = (nn = n + mm + -1)) + 1) * xln) > elim) {
                                if (t <= 0.0) {
                                    nz.setInt(0);
                                    ierr.setInt(2);
                                    break block41;
                                }
                            } else {
                                if (x < wdtol) {
                                    var288_84 = ~n;
                                    var286_85 = mlutils.R_pow_di(x, var288_84);
                                    ans.setDouble(var286_85);
                                    if (mm != 1) {
                                        k = 1;
                                        while (k < mm) {
                                            var284_92 = k * 8;
                                            var282_90 = ans;
                                            var283_91 = var284_92;
                                            var279_89 = (k + -1) * 8;
                                            var277_87 = ans;
                                            var278_88 = var279_89;
                                            var273_86 = var277_87.getDouble(var278_88) / x;
                                            var282_90.setDouble(var283_91, var273_86);
                                            ++k;
                                        }
                                    }
                                    if (n != 0 || kode != 2) break block41;
                                    var269_93 = ans.getDouble() + xln;
                                    ans.setDouble(var269_93);
                                    break block41;
                                }
                                rln = (double)i1mach.Rf_i1mach(14) * r1m5;
                                rln = fmin2.fmin2(rln, 18.06);
                                fln = fmax2.fmax2(rln, 3.0) - 3.0;
                                yint = fln * 0.4 + 3.5;
                                slope = (fln * 6.038E-4 + 0.008677) * fln + 0.21;
                                xm = (double)fn * slope + yint;
                                xmin = (int)xm + 1;
                                if (n != 0) {
                                    var249_83 = rln * -2.302;
                                    var247_82 = fmin2.fmin2(0.0, xln);
                                    xm = var249_83 - var247_82;
                                    var245_81 = n;
                                    arg = xm / var245_81;
                                    arg = fmin2.fmin2(0.0, arg);
                                    eps = Mathlib.exp((double)arg);
                                    xm = 1.0 - eps;
                                    if (Math.abs(arg) < 0.001) {
                                        xm = -arg;
                                    }
                                    fln = x * xm / eps;
                                    xm = xmin - x;
                                    if (xm > 7.0 && fln < 15.0) break;
                                }
                                xdmy = x;
                                xdmln = xln;
                                xinc = 0.0;
                                if (x < xmin) {
                                    nx = (int)x;
                                    var239_80 = nx;
                                    xinc = xmin - var239_80;
                                    xdmy = x + xinc;
                                    xdmln = Mathlib.log((double)xdmy);
                                }
                                t = (double)fn * xdmln;
                                t1 = xdmln * 2.0;
                                t2 = t + xdmln;
                                var235_79 = Math.abs(t2);
                                var231_78 = fmax2.fmax2(Math.abs(t1), var235_79);
                                tk = fmax2.fmax2(Math.abs(t), var231_78);
                                if (tk <= elim) break block42;
                            }
                            nz = nz.pointerPlus(4);
                            var227_77 = --mm * 8;
                            var225_75 = ans;
                            var226_76 = var227_77;
                            var225_75.setDouble(var226_76, 0.0);
                            if (mm != 0) {
                                continue;
                            }
                            break block41;
                            break;
                        }
                        nn = (int)fln + 1;
                        np = n + 1;
                        t1 = (double)(n + 1) * xln;
                        s = t = Mathlib.exp((double)(-t1));
                        den = x;
                        i = 1;
                        while (i <= nn) {
                            var216_98 = -np;
                            trm[i] = var214_97 = Mathlib.pow((double)(den += 1.0), (double)var216_98);
                            s = trm[i] + s;
                            ++i;
                        }
                        ans.setDouble(s);
                        if (n == 0 && kode == 2) {
                            var210_99 = s + xln;
                            ans.setDouble(var210_99);
                        }
                        if (mm == 1) break block41;
                        tol = wdtol / 5.0;
                        j = 1;
                        while (j < mm) {
                            s = t /= x;
                            tols = t * tol;
                            den = x;
                            i = 1;
                            while (i <= nn) {
                                trm[i] = var206_103 = trm[i] / (den += 1.0);
                                s = trm[i] + s;
                                if (trm[i] < tols) break;
                                ++i;
                            }
                            var200_102 = j * 8;
                            var198_100 = ans;
                            var199_101 = var200_102;
                            var198_100.setDouble(var199_101, s);
                            ++j;
                        }
                        break block41;
                    }
                    tss = Mathlib.exp((double)(-t));
                    t1 = tt = 0.5 / xdmy;
                    tst = wdtol * tt;
                    if (nn != 0) {
                        var194_104 = fn;
                        t1 = 1.0 / var194_104 + tt;
                    }
                    v0 = xdmy;
                    var190_105 = v0 * v0;
                    rxsq = 1.0 / var190_105;
                    ta = rxsq * 0.5;
                    t = (double)(fn + 1) * ta;
                    s = polygamma.$dpsifn$bvalues[2] * t;
                    if (Math.abs(s) >= tst) {
                        tk = 2.0;
                        k = 4;
                        while (k <= 22) {
                            var177_113 = (double)fn + tk + 1.0;
                            var175_112 = tk + 1.0;
                            var171_111 = var177_113 / var175_112 * t;
                            var167_110 = (double)fn + tk;
                            var165_109 = tk + 2.0;
                            var163_108 = var167_110 / var165_109;
                            t = var171_111 * var163_108 * rxsq;
                            var160_107 = k + -1;
                            trm[k] = var156_106 = polygamma.$dpsifn$bvalues[var160_107] * t;
                            if (Math.abs(trm[k]) < tst) break;
                            s = trm[k] + s;
                            tk += 2.0;
                            ++k;
                        }
                    }
                    s = (s + t1) * tss;
                    if (xinc == 0.0) break block49;
                    nx = (int)xinc;
                    np = nn + 1;
                    if (nx <= 100) break block50;
                    nz.setInt(0);
                    ierr.setInt(3);
                    break block41;
                }
                if (nn != 0) {
                    xm = xinc - 1.0;
                    fx = x + xm;
                    i = 1;
                    while (i <= nx) {
                        var145_116 = -np;
                        trmr[i] = var143_115 = Mathlib.pow((double)fx, (double)var145_116);
                        s = trmr[i] + s;
                        fx = x + (xm -= 1.0);
                        ++i;
                    }
                }
                ** GOTO lbl333
            }
            var138_117 = (mm + -1) * 8;
            var136_118 = ans;
            var137_119 = var138_117;
            var136_118.setDouble(var137_119, s);
            if (fn == 0) ** GOTO lbl340
            j = 2;
            while (j <= mm) {
                block53: {
                    block52: {
                        block51: {
                            tss *= xdmy;
                            t1 = tt;
                            if (--fn != 0) {
                                var134_120 = fn;
                                t1 = 1.0 / var134_120 + tt;
                            }
                            t = (double)(fn + 1) * ta;
                            s = polygamma.$dpsifn$bvalues[2] * t;
                            if (Math.abs(s) >= tst) {
                                tk = fn + 4;
                                k = 4;
                                while (k <= 22) {
                                    var122_127 = trm[k];
                                    var119_126 = fn + 1;
                                    trm[k] = var115_125 = var122_127 * var119_126 / tk;
                                    if (Math.abs(trm[k]) < tst) break;
                                    s = trm[k] + s;
                                    tk += 2.0;
                                    ++k;
                                }
                            }
                            s = (s + t1) * tss;
                            if (xinc == 0.0) break block51;
                            if (fn != 0) {
                                xm = xinc - 1.0;
                                fx = x + xm;
                                i = 1;
                                while (i <= nx) {
                                    trmr[i] = var103_124 = trmr[i] * fx;
                                    s = trmr[i] + s;
                                    fx = x + (xm -= 1.0);
                                    ++i;
                                }
                            }
                            break block52;
                        }
                        var98_123 = (mm - j) * 8;
                        var96_121 = ans;
                        var97_122 = var98_123;
                        var96_121.setDouble(var97_122, s);
                        if (fn != 0) {
                            ++j;
                            continue;
                        }
                        break block53;
                    }
                    i = 1;
                    while (i <= nx) {
                        var91_128 = (double)(nx - i) + x;
                        s = 1.0 / var91_128 + s;
                        ++i;
                    }
                }
                if (kode != 2) {
                    var87_129 = s - xdmln;
                    ans.setDouble(var87_129);
                    break;
                }
                if (xdmy == x) break;
                var85_130 = Mathlib.log((double)(xdmy / x));
                var83_131 = s - var85_130;
                ans.setDouble(var83_131);
                break;
            }
        }
    }

    static {
        polygamma.bvalues$4360$$clinit();
        System.arraycopy(new double[]{1.0, -0.5, 0.16666666666666666, -0.03333333333333333, 0.023809523809523808, -0.03333333333333333, 0.07575757575757576, -0.2531135531135531, 1.1666666666666667, -7.092156862745098, 54.971177944862156, -529.1242424242424, 6192.123188405797, -86580.25311355312, 1425517.1666666667, -2.7298231067816094E7, 6.015808739006424E8, -1.5116315767092157E10, 4.296146430611667E11, -1.3711655205088332E13, 4.883323189735932E14, -1.9296579341940068E16}, 0, $dpsifn$bvalues, 0, 22);
    }

    static void bvalues$4360$$clinit() {
        System.arraycopy(new double[]{1.0, -0.5, 0.16666666666666666, -0.03333333333333333, 0.023809523809523808, -0.03333333333333333, 0.07575757575757576, -0.2531135531135531, 1.1666666666666667, -7.092156862745098, 54.971177944862156, -529.1242424242424, 6192.123188405797, -86580.25311355312, 1425517.1666666667, -2.7298231067816094E7, 6.015808739006424E8, -1.5116315767092157E10, 4.296146430611667E11, -1.3711655205088332E13, 4.883323189735932E14, -1.9296579341940068E16}, 0, bvalues$4360, 0, 22);
    }
}

