/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.pgamma;

public class ppois {
    private ppois() {
    }

    public static double ppois(double x, double lambda, int lower_tail, int log_p) {
        double d;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(lambda) || Double.isNaN(lambda)) {
            d = x + lambda;
        } else if (lambda < 0.0) {
            d = 0.0 / 0.0;
        } else if (x < 0.0) {
            double iftmp$0;
            if (lower_tail != 0) {
                double iftmp$1 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$0 = iftmp$1;
            } else {
                double iftmp$2 = log_p != 0 ? 0.0 : 1.0;
                iftmp$0 = iftmp$2;
            }
            d = iftmp$0;
        } else if (lambda == 0.0) {
            double iftmp$3;
            if (lower_tail != 0) {
                double iftmp$4 = log_p != 0 ? 0.0 : 1.0;
                iftmp$3 = iftmp$4;
            } else {
                double iftmp$5 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$3 = iftmp$5;
            }
            d = iftmp$3;
        } else if (!(Math.abs(x) <= Double.MAX_VALUE)) {
            double iftmp$6;
            if (lower_tail != 0) {
                double iftmp$7 = log_p != 0 ? 0.0 : 1.0;
                iftmp$6 = iftmp$7;
            } else {
                double iftmp$8 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$6 = iftmp$8;
            }
            d = iftmp$6;
        } else {
            x = Mathlib.floor((double)(x + 1.0E-7));
            int n = lower_tail != 0 ? 0 : 1;
            double d2 = x + 1.0;
            d = pgamma.pgamma(lambda, d2, 1.0, n, log_p);
        }
        return d;
    }
}

