/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.lbeta;
import org.renjin.nmath.pbeta;
import org.renjin.nmath.pnorm;

public class pt {
    private pt() {
    }

    public static double pt(double x, double n, int lower_tail, int log_p) {
        double d;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(n) || Double.isNaN(n)) {
            d = x + n;
        } else if (n <= 0.0) {
            d = 0.0 / 0.0;
        } else if (!(Math.abs(x) <= Double.MAX_VALUE)) {
            double iftmp$0;
            if (x < 0.0) {
                double iftmp$1;
                if (lower_tail != 0) {
                    double iftmp$2 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                    iftmp$1 = iftmp$2;
                } else {
                    double iftmp$3 = log_p != 0 ? 0.0 : 1.0;
                    iftmp$1 = iftmp$3;
                }
                iftmp$0 = iftmp$1;
            } else {
                double iftmp$4;
                if (lower_tail != 0) {
                    double iftmp$5 = log_p != 0 ? 0.0 : 1.0;
                    iftmp$4 = iftmp$5;
                } else {
                    double iftmp$6 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                    iftmp$4 = iftmp$6;
                }
                iftmp$0 = iftmp$4;
            }
            d = iftmp$0;
        } else if (!(Math.abs(n) <= Double.MAX_VALUE)) {
            d = pnorm.pnorm5(x, 0.0, 1.0, lower_tail, log_p);
        } else {
            double val;
            double nx = x / n * x + 1.0;
            if (nx > 1.0E100) {
                double d2 = n * -0.5;
                double d3 = Mathlib.log((double)Math.abs(x)) * 2.0;
                double d4 = Mathlib.log((double)n);
                double d5 = d3 - d4;
                double d6 = d2 * d5;
                double d7 = lbeta.lbeta(n * 0.5, 0.5);
                double d8 = d6 - d7;
                double d9 = Mathlib.log((double)(n * 0.5));
                double lval = d8 - d9;
                double iftmp$7 = log_p == 0 ? Mathlib.exp((double)lval) : lval;
                val = iftmp$7;
            } else {
                double iftmp$8;
                double d10 = x;
                if (d10 * d10 < n) {
                    double d11 = n / 2.0;
                    double d12 = x;
                    double d13 = d12 * d12;
                    double d14 = x;
                    double d15 = d14 * d14 + n;
                    iftmp$8 = pbeta.pbeta(d13 / d15, 0.5, d11, 0, log_p);
                } else {
                    double d16 = n / 2.0;
                    iftmp$8 = pbeta.pbeta(1.0 / nx, d16, 0.5, 1, log_p);
                }
                val = iftmp$8;
            }
            if (x <= 0.0) {
                int n2 = lower_tail = lower_tail != 0 ? 0 : 1;
            }
            if (log_p != 0) {
                d = lower_tail != 0 ? Mathlib.log1p((double)(Mathlib.exp((double)val) * -0.5)) : val - 0.6931471805599453;
            } else {
                double iftmp$9 = lower_tail != 0 ? 0.5 - val + 0.5 : (val /= 2.0);
                d = iftmp$9;
            }
        }
        return d;
    }
}

