/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Mathlib;

public class pweibull {
    private pweibull() {
    }

    public static double pweibull(double x, double shape, double scale, int lower_tail, int log_p) {
        double d;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(shape) || Double.isNaN(shape) || Double.isNaN(scale) || Double.isNaN(scale)) {
            d = x + shape + scale;
        } else if (shape <= 0.0 || scale <= 0.0) {
            d = 0.0 / 0.0;
        } else if (x <= 0.0) {
            double iftmp$0;
            if (lower_tail != 0) {
                double iftmp$1 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$0 = iftmp$1;
            } else {
                double iftmp$2 = log_p != 0 ? 0.0 : 1.0;
                iftmp$0 = iftmp$2;
            }
            d = iftmp$0;
        } else {
            double iftmp$3;
            x = -Mathlib.pow((double)(x / scale), (double)shape);
            if (lower_tail != 0) {
                double iftmp$4;
                if (log_p != 0) {
                    double iftmp$5 = x > -0.6931471805599453 ? Mathlib.log((double)(-Mathlib.expm1((double)x))) : Mathlib.log1p((double)(-Mathlib.exp((double)x)));
                    iftmp$4 = iftmp$5;
                } else {
                    iftmp$4 = -Mathlib.expm1((double)x);
                }
                iftmp$3 = iftmp$4;
            } else {
                double iftmp$6 = log_p == 0 ? Mathlib.exp((double)x) : x;
                iftmp$3 = iftmp$6;
            }
            d = iftmp$3;
        }
        return d;
    }
}

