/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.nmath.fmax2;
import org.renjin.nmath.fmin2;
import org.renjin.nmath.pbinom;
import org.renjin.nmath.qnorm;

public class qbinom {
    private qbinom() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double qbinom(double p, double n, double pr, int lower_tail, int log_p) {
        double oldincr;
        double z$11;
        double z$7;
        double[] z = new double[]{0.0};
        if (Double.isNaN(p)) return p + n + pr;
        if (Double.isNaN(p)) return p + n + pr;
        if (Double.isNaN(n)) return p + n + pr;
        if (Double.isNaN(n)) return p + n + pr;
        if (Double.isNaN(pr)) return p + n + pr;
        if (Double.isNaN(pr)) return p + n + pr;
        if (!(Math.abs(n) <= Double.MAX_VALUE)) return 0.0 / 0.0;
        if (!(Math.abs(pr) <= Double.MAX_VALUE)) return 0.0 / 0.0;
        if (!(Math.abs(p) <= Double.MAX_VALUE)) {
            if (log_p == 0) return 0.0 / 0.0;
        }
        if (Mathlib.floor((double)(n + 0.5)) != n) return 0.0 / 0.0;
        if (pr < 0.0) return 0.0 / 0.0;
        if (pr > 1.0) return 0.0 / 0.0;
        if (n < 0.0) return 0.0 / 0.0;
        if (log_p != 0) {
            if (p > 0.0) return 0.0 / 0.0;
            if (p == 0.0) {
                if (lower_tail == 0) {
                    return 0.0;
                }
                double iftmp$0 = n;
                return iftmp$0;
            }
            double d = -1.0 / 0.0;
            if (p == d) {
                if (lower_tail != 0) {
                    return 0.0;
                }
                double iftmp$1 = n;
                return iftmp$1;
            }
        } else {
            if (p < 0.0) return 0.0 / 0.0;
            if (p > 1.0) return 0.0 / 0.0;
            if (p == 0.0) {
                if (lower_tail != 0) {
                    return 0.0;
                }
                double iftmp$2 = n;
                return iftmp$2;
            }
            if (p == 1.0) {
                if (lower_tail == 0) {
                    return 0.0;
                }
                double iftmp$3 = n;
                return iftmp$3;
            }
        }
        if (pr == 0.0) return 0.0;
        if (n == 0.0) return 0.0;
        double q = 1.0 - pr;
        if (q == 0.0) return n;
        double mu = n * pr;
        double sigma = Mathlib.sqrt((double)(n * pr * q));
        double gamma2 = (q - pr) / sigma;
        if (lower_tail == 0 || log_p != 0) {
            double iftmp$4;
            if (log_p != 0) {
                double iftmp$5 = lower_tail != 0 ? Mathlib.exp((double)p) : -Mathlib.expm1((double)p);
                iftmp$4 = iftmp$5;
            } else {
                double iftmp$6 = lower_tail == 0 ? 0.5 - p + 0.5 : p;
                iftmp$4 = iftmp$6;
            }
            p = iftmp$4;
            if (p == 0.0) return 0.0;
            if (p == 1.0) return n;
        }
        if (p + 2.242650509742816E-16 >= 1.0) return n;
        z[0] = z$7 = qnorm.qnorm5(p, 0.0, 1.0, 1, 0);
        double z$8 = z[0];
        double z$9 = z[0];
        double d = (z$8 * z$9 - 1.0) * gamma2 / 6.0;
        double z$10 = z[0];
        double y = Mathlib.floor((double)((d + z$10) * sigma + mu + 0.5));
        if (y > n) {
            y = n;
        }
        z[0] = z$11 = pbinom.pbinom(y, n, pr, 1, 0);
        p *= 0.9999999999999858;
        if (n < 100000.0) return qbinom.do_search(y, (Ptr)new DoublePtr(z, 0), p, n, pr, 1.0);
        double incr = Mathlib.floor((double)(n * 0.001));
        do {
            oldincr = incr;
            y = qbinom.do_search(y, (Ptr)new DoublePtr(z, 0), p, n, pr, incr);
            double d2 = Mathlib.floor((double)(incr / 100.0));
            incr = fmax2.fmax2(1.0, d2);
        } while (oldincr > 1.0 && n * 1.0E-15 < incr);
        return y;
    }

    public static double do_search(double y, Ptr z, double p, double n, double pr, double incr) {
        double d;
        block4: {
            if (z.getDouble() >= p) {
                while (true) {
                    double newz;
                    if (y == 0.0 || (newz = pbinom.pbinom(y - incr, n, pr, 1, 0)) < p) {
                        d = y;
                        break block4;
                    }
                    double d2 = y - incr;
                    y = fmax2.fmax2(0.0, d2);
                    z.setDouble(newz);
                }
            }
            while ((y = fmin2.fmin2(y + incr, n)) != n) {
                double d3 = pbinom.pbinom(y, n, pr, 1, 0);
                z.setDouble(d3);
                if (!(z.getDouble() >= p)) continue;
            }
            d = y;
        }
        return d;
    }
}

