/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.cospi;

public class qcauchy {
    private qcauchy() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double qcauchy(double p, double location, double scale, int lower_tail, int log_p) {
        if (Double.isNaN(p)) return p + location + scale;
        if (Double.isNaN(p)) return p + location + scale;
        if (Double.isNaN(location)) return p + location + scale;
        if (Double.isNaN(location)) return p + location + scale;
        if (Double.isNaN(scale)) return p + location + scale;
        if (Double.isNaN(scale)) return p + location + scale;
        if (log_p != 0) {
            if (p > 0.0) return 0.0 / 0.0;
        }
        if (log_p == 0) {
            if (p < 0.0) return 0.0 / 0.0;
            if (p > 1.0) return 0.0 / 0.0;
        }
        if (scale <= 0.0 || !(Math.abs(scale) <= Double.MAX_VALUE)) {
            if (scale == 0.0) return location;
            return 0.0 / 0.0;
        }
        if (log_p != 0) {
            if (p > -1.0) {
                if (p == 0.0) {
                    double iftmp$0;
                    if (lower_tail == 0) {
                        double d = -scale;
                        double d2 = 1.0 / 0.0;
                        iftmp$0 = d * d2;
                        return iftmp$0 + location;
                    } else {
                        double d = 1.0 / 0.0;
                        iftmp$0 = scale * d;
                    }
                    return iftmp$0 + location;
                }
                lower_tail = lower_tail != 0 ? 0 : 1;
                p = -Mathlib.expm1((double)p);
            } else {
                p = Mathlib.exp((double)p);
            }
        } else if (p > 0.5) {
            if (p == 1.0) {
                double iftmp$1;
                if (lower_tail == 0) {
                    double d = -scale;
                    double d3 = 1.0 / 0.0;
                    iftmp$1 = d * d3;
                    return iftmp$1 + location;
                } else {
                    double d = 1.0 / 0.0;
                    iftmp$1 = scale * d;
                }
                return iftmp$1 + location;
            }
            p = 1.0 - p;
            lower_tail = lower_tail != 0 ? 0 : 1;
        }
        if (p == 0.5) return location;
        if (p == 0.0) {
            double iftmp$2;
            if (lower_tail == 0) {
                double d = 1.0 / 0.0;
                iftmp$2 = scale * d;
                return iftmp$2 + location;
            } else {
                double d = -1.0 / 0.0;
                iftmp$2 = scale * d;
            }
            return iftmp$2 + location;
        }
        double iftmp$3 = lower_tail != 0 ? -scale : scale;
        double d = cospi.tanpi(p);
        return iftmp$3 / d + location;
    }
}

