/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.nmath.qbeta;
import org.renjin.nmath.qchisq;

public class qf {
    private qf() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double qf(double p, double df1, double df2, int lower_tail, int log_p) {
        double d;
        if (Double.isNaN(p)) return p + df1 + df2;
        if (Double.isNaN(p)) return p + df1 + df2;
        if (Double.isNaN(df1)) return p + df1 + df2;
        if (Double.isNaN(df1)) return p + df1 + df2;
        if (Double.isNaN(df2)) return p + df1 + df2;
        if (Double.isNaN(df2)) return p + df1 + df2;
        if (df1 <= 0.0) return 0.0 / 0.0;
        if (df2 <= 0.0) return 0.0 / 0.0;
        if (log_p != 0) {
            if (p > 0.0) return 0.0 / 0.0;
            if (p == 0.0) {
                if (lower_tail == 0) {
                    return 0.0;
                }
                double iftmp$0 = 1.0 / 0.0;
                return iftmp$0;
            }
            double d2 = -1.0 / 0.0;
            if (p == d2) {
                if (lower_tail != 0) {
                    return 0.0;
                }
                double iftmp$1 = 1.0 / 0.0;
                return iftmp$1;
            }
        } else {
            if (p < 0.0) return 0.0 / 0.0;
            if (p > 1.0) return 0.0 / 0.0;
            if (p == 0.0) {
                if (lower_tail != 0) {
                    return 0.0;
                }
                double iftmp$2 = 1.0 / 0.0;
                return iftmp$2;
            }
            if (p == 1.0) {
                if (lower_tail == 0) {
                    return 0.0;
                }
                double iftmp$3 = 1.0 / 0.0;
                return iftmp$3;
            }
        }
        if (df1 <= df2 && df2 > 400000.0) {
            if (!(Math.abs(df1) <= Double.MAX_VALUE)) return 1.0;
            return qchisq.qchisq(p, df1, lower_tail, log_p) / df1;
        }
        if (df1 > 400000.0) {
            int n = lower_tail != 0 ? 0 : 1;
            double d3 = qchisq.qchisq(p, df2, n, log_p);
            return df2 / d3;
        }
        double d4 = df2 / 2.0;
        double d5 = df1 / 2.0;
        int n = lower_tail != 0 ? 0 : 1;
        double d6 = qbeta.qbeta(p, d4, d5, n, log_p);
        double d7 = 1.0 / d6 - 1.0;
        double iftmp$4 = (Double.isNaN(p = d7 * (d = df2 / df1)) || Double.isNaN(p)) ^ true ? p : 0.0 / 0.0;
        return iftmp$4;
    }
}

