/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.dgamma;
import org.renjin.nmath.lgamma;
import org.renjin.nmath.pgamma;
import org.renjin.nmath.qnorm;

public class qgamma {
    public static double i2520$4388 = 3.968253968253968E-4;
    public static double i420$4387 = 0.002380952380952381;
    public static double i5040$4389 = 1.984126984126984E-4;
    public static double $qgamma$i5040 = 1.984126984126984E-4;
    public static double $qgamma$i2520 = 3.968253968253968E-4;
    public static double $qgamma$i420 = 0.002380952380952381;

    private qgamma() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double qgamma(double p, double alpha, double scale, int lower_tail, int log_p) {
        double t;
        double p1;
        int i;
        double iftmp$4;
        int max_it_Newton = 0;
        double s6 = 0.0;
        double ch0 = 0.0;
        double g = 0.0;
        double c = 0.0;
        double p_ = 0.0;
        max_it_Newton = 1;
        if (Double.isNaN(p)) return p + alpha + scale;
        if (Double.isNaN(p)) return p + alpha + scale;
        if (Double.isNaN(alpha)) return p + alpha + scale;
        if (Double.isNaN(alpha)) return p + alpha + scale;
        if (Double.isNaN(scale)) return p + alpha + scale;
        if (Double.isNaN(scale)) return p + alpha + scale;
        if (log_p != 0) {
            if (p > 0.0) return 0.0 / 0.0;
            if (p == 0.0) {
                if (lower_tail == 0) {
                    return 0.0;
                }
                double iftmp$0 = 1.0 / 0.0;
                return iftmp$0;
            }
            double d = -1.0 / 0.0;
            if (p == d) {
                if (lower_tail != 0) {
                    return 0.0;
                }
                double iftmp$1 = 1.0 / 0.0;
                return iftmp$1;
            }
        } else {
            if (p < 0.0) return 0.0 / 0.0;
            if (p > 1.0) return 0.0 / 0.0;
            if (p == 0.0) {
                if (lower_tail != 0) {
                    return 0.0;
                }
                double iftmp$2 = 1.0 / 0.0;
                return iftmp$2;
            }
            if (p == 1.0) {
                if (lower_tail == 0) {
                    return 0.0;
                }
                double iftmp$3 = 1.0 / 0.0;
                return iftmp$3;
            }
        }
        if (alpha < 0.0) return 0.0 / 0.0;
        if (scale <= 0.0) return 0.0 / 0.0;
        if (alpha == 0.0) return 0.0;
        if (alpha < 1.0E-10) {
            max_it_Newton = 7;
        }
        if (log_p != 0) {
            double iftmp$5 = lower_tail != 0 ? Mathlib.exp((double)p) : -Mathlib.expm1((double)p);
            iftmp$4 = iftmp$5;
        } else {
            double iftmp$6 = lower_tail == 0 ? 0.5 - p + 0.5 : p;
            iftmp$4 = iftmp$6;
        }
        p_ = iftmp$4;
        g = lgamma.lgammafn(alpha);
        double d = alpha * 2.0;
        double ch = qgamma.qchisq_appr(p, d, g, lower_tail, log_p, 0.01);
        if (!(Math.abs(ch) <= Double.MAX_VALUE)) {
            max_it_Newton = 0;
        } else if (ch < 5.0E-7) {
            max_it_Newton = 20;
        } else if (p_ > 0.99999999999999 || p_ < 1.0E-100) {
            max_it_Newton = 20;
        } else {
            c = alpha - 1.0;
            double d2 = (c * 127.0 + 346.0) * c + 120.0;
            double i5040$7 = $qgamma$i5040;
            s6 = d2 * i5040$7;
            ch0 = ch;
            i = 1;
            while (i <= 1000) {
                double q = ch;
                p1 = ch * 0.5;
                double d3 = pgamma.Rf_pgamma_raw(p1, alpha, 1, 0);
                double p2 = p_ - d3;
                if (!(Math.abs(p2) <= Double.MAX_VALUE) || ch <= 0.0) {
                    ch = ch0;
                    max_it_Newton = 27;
                    break;
                }
                double d4 = alpha * 0.6931471805599453 + g + p1;
                double d5 = Mathlib.log((double)ch) * c;
                t = Mathlib.exp((double)(d4 - d5)) * p2;
                double b = t / ch;
                double d6 = t * 0.5;
                double d7 = b * c;
                double a = d6 - d7;
                double d8 = ((((a * 60.0 + 70.0) * a + 84.0) * a + 105.0) * a + 140.0) * a + 210.0;
                double i420$8 = $qgamma$i420;
                double s1 = d8 * i420$8;
                double d9 = (((a * 1278.0 + 1141.0) * a + 966.0) * a + 735.0) * a + 420.0;
                double i2520$9 = $qgamma$i2520;
                double s2 = d9 * i2520$9;
                double d10 = ((a * 932.0 + 707.0) * a + 462.0) * a + 210.0;
                double i2520$10 = $qgamma$i2520;
                double s3 = d10 * i2520$10;
                double d11 = (a * 1182.0 + 672.0) * a + 252.0;
                double d12 = ((a * 1740.0 + 889.0) * a + 294.0) * c;
                double d13 = d11 + d12;
                double i5040$11 = $qgamma$i5040;
                double s4 = d13 * i5040$11;
                double d14 = a * 2264.0 + 84.0;
                double d15 = (a * 606.0 + 1175.0) * c;
                double d16 = d14 + d15;
                double i2520$12 = $qgamma$i2520;
                double s5 = d16 * i2520$12;
                double d17 = t * 0.5 * s1 + 1.0;
                double d18 = b * c;
                double d19 = b * s6;
                double d20 = (s5 - d19) * b;
                double d21 = (s4 - d20) * b;
                double d22 = (s3 - d21) * b;
                double d23 = (s2 - d22) * b;
                double d24 = s1 - d23;
                double d25 = d18 * d24;
                ch = (d17 - d25) * t + ch;
                double d26 = Math.abs(q - ch);
                double d27 = ch * 5.0E-7;
                if (d26 < d27) break;
                double d28 = Math.abs(q - ch);
                double d29 = ch * 0.1;
                if (d28 > d29) {
                    ch = ch < q ? q * 0.9 : q * 1.1;
                }
                ++i;
            }
        }
        double x = scale * 0.5 * ch;
        if (max_it_Newton == 0) return x;
        if (log_p == 0) {
            p = Mathlib.log((double)p);
            log_p = 1;
        }
        if (x == 0.0) {
            double _1_p = 1.0000001;
            double _1_m = 0.9999999;
            x = Double.MIN_NORMAL;
            p_ = pgamma.pgamma(x, alpha, scale, lower_tail, log_p);
            if (lower_tail != 0) {
                if (p * _1_p < p_) return 0.0;
            }
            if (lower_tail == 0) {
                if (p * _1_m > p_) return 0.0;
            }
        } else {
            p_ = pgamma.pgamma(x, alpha, scale, lower_tail, log_p);
        }
        double d30 = -1.0 / 0.0;
        if (p_ == d30) return 0.0;
        i = 1;
        while (i <= max_it_Newton) {
            double d31;
            p1 = p_ - p;
            double d32 = Math.abs(p1);
            if (d32 < (d31 = Math.abs(p * 1.0E-15))) return x;
            g = dgamma.dgamma(x, alpha, scale, log_p);
            double iftmp$13 = log_p != 0 ? -1.0 / 0.0 : 0.0;
            if (g == iftmp$13) return x;
            double iftmp$14 = log_p != 0 ? Mathlib.exp((double)(p_ - g)) * p1 : p1 / g;
            t = iftmp$14;
            double iftmp$15 = lower_tail != 0 ? x - t : x + t;
            t = iftmp$15;
            p_ = pgamma.pgamma(t, alpha, scale, lower_tail, log_p);
            double d33 = Math.abs(p_ - p);
            double d34 = Math.abs(p1);
            if (d33 > d34) return x;
            if (i > 1) {
                double d35;
                double d36 = Math.abs(p_ - p);
                if (d36 == (d35 = Math.abs(p1))) return x;
            }
            x = t;
            ++i;
        }
        return x;
    }

    public static double qchisq_appr(double p, double nu, double g, int lower_tail, int log_p, double tol) {
        double d;
        double a = 0.0;
        if (Double.isNaN(p) || Double.isNaN(p) || Double.isNaN(nu) || Double.isNaN(nu)) {
            d = p + nu;
        } else if (log_p != 0 && p > 0.0 || log_p == 0 && (p < 0.0 || p > 1.0)) {
            d = 0.0 / 0.0;
        } else if (nu <= 0.0) {
            d = 0.0 / 0.0;
        } else {
            double ch;
            double iftmp$16;
            double alpha = nu * 0.5;
            double c = alpha - 1.0;
            if (lower_tail != 0) {
                double iftmp$17 = log_p == 0 ? Mathlib.log((double)p) : p;
                iftmp$16 = iftmp$17;
            } else {
                double iftmp$18;
                if (log_p != 0) {
                    double iftmp$19 = p > -0.6931471805599453 ? Mathlib.log((double)(-Mathlib.expm1((double)p))) : Mathlib.log1p((double)(-Mathlib.exp((double)p)));
                    iftmp$18 = iftmp$19;
                } else {
                    iftmp$18 = Mathlib.log1p((double)(-p));
                }
                iftmp$16 = iftmp$18;
            }
            double p1 = iftmp$16;
            if (p1 * -1.24 > nu) {
                double iftmp$20 = alpha < 0.5 ? pgamma.lgamma1p(alpha) : Mathlib.log((double)alpha) + g;
                ch = Mathlib.exp((double)((iftmp$20 + p1) / alpha + 0.6931471805599453));
            } else if (nu > 0.32) {
                double x = qnorm.qnorm5(p, 0.0, 1.0, lower_tail, log_p);
                double d2 = nu * 9.0;
                p1 = 2.0 / d2;
                ch = Mathlib.pow((double)(Mathlib.sqrt((double)p1) * x + 1.0 - p1), (double)3.0) * nu;
                if (nu * 2.2 + 6.0 < ch) {
                    double iftmp$21;
                    if (lower_tail != 0) {
                        double iftmp$22;
                        if (log_p != 0) {
                            double iftmp$23 = p > -0.6931471805599453 ? Mathlib.log((double)(-Mathlib.expm1((double)p))) : Mathlib.log1p((double)(-Mathlib.exp((double)p)));
                            iftmp$22 = iftmp$23;
                        } else {
                            iftmp$22 = Mathlib.log1p((double)(-p));
                        }
                        iftmp$21 = iftmp$22;
                    } else {
                        double iftmp$24 = log_p == 0 ? Mathlib.log((double)p) : p;
                        iftmp$21 = iftmp$24;
                    }
                    double d3 = Mathlib.log((double)(ch * 0.5)) * c;
                    ch = (iftmp$21 - d3 + g) * -2.0;
                }
            } else {
                double d4;
                double t;
                double p2;
                double d5;
                double d6;
                double q;
                double d7;
                double iftmp$25;
                ch = 0.4;
                if (lower_tail != 0) {
                    double iftmp$26;
                    if (log_p != 0) {
                        double iftmp$27 = p > -0.6931471805599453 ? Mathlib.log((double)(-Mathlib.expm1((double)p))) : Mathlib.log1p((double)(-Mathlib.exp((double)p)));
                        iftmp$26 = iftmp$27;
                    } else {
                        iftmp$26 = Mathlib.log1p((double)(-p));
                    }
                    iftmp$25 = iftmp$26;
                } else {
                    double iftmp$28 = log_p == 0 ? Mathlib.log((double)p) : p;
                    iftmp$25 = iftmp$28;
                }
                double d8 = iftmp$25 + g;
                double d9 = c * 0.6931471805599453;
                a = d8 + d9;
                do {
                    q = ch;
                    double d10 = (ch + 4.67) * ch + 1.0;
                    p1 = 1.0 / d10;
                    p2 = ((ch + 6.66) * ch + 6.73) * ch;
                    double d11 = (ch * 2.0 + 4.67) * p1 - 0.5;
                    double d12 = ((ch * 3.0 + 13.32) * ch + 6.73) / p2;
                    t = d11 - d12;
                } while ((d7 = Math.abs(q - (ch -= (d6 = (1.0 - (d5 = Mathlib.exp((double)(ch * 0.5 + a)) * p2 * p1)) / t)))) > (d4 = Math.abs(ch) * tol));
            }
            d = ch;
        }
        return d;
    }
}

