/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.choose;
import org.renjin.nmath.fmax2;
import org.renjin.nmath.fmin2;

public class qhyper {
    private qhyper() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double qhyper(double p, double NR, double NB, double n, int lower_tail, int log_p) {
        boolean small_N = false;
        double xend = 0.0;
        if (Double.isNaN(p)) return p + NR + NB + n;
        if (Double.isNaN(p)) return p + NR + NB + n;
        if (Double.isNaN(NR)) return p + NR + NB + n;
        if (Double.isNaN(NR)) return p + NR + NB + n;
        if (Double.isNaN(NB)) return p + NR + NB + n;
        if (Double.isNaN(NB)) return p + NR + NB + n;
        if (Double.isNaN(n)) return p + NR + NB + n;
        if (Double.isNaN(n)) return p + NR + NB + n;
        if (!(Math.abs(p) <= Double.MAX_VALUE)) return 0.0 / 0.0;
        if (!(Math.abs(NR) <= Double.MAX_VALUE)) return 0.0 / 0.0;
        if (!(Math.abs(NB) <= Double.MAX_VALUE)) return 0.0 / 0.0;
        if (!(Math.abs(n) <= Double.MAX_VALUE)) return 0.0 / 0.0;
        NR = Mathlib.round((double)NR);
        NB = Mathlib.round((double)NB);
        double N = NR + NB;
        n = Mathlib.round((double)n);
        if (NR < 0.0) return 0.0 / 0.0;
        if (NB < 0.0) return 0.0 / 0.0;
        if (n < 0.0) return 0.0 / 0.0;
        if (n > N) return 0.0 / 0.0;
        double d = n - NB;
        double xstart = fmax2.fmax2(0.0, d);
        xend = fmin2.fmin2(n, NR);
        if (log_p != 0) {
            if (p > 0.0) return 0.0 / 0.0;
            if (p == 0.0) {
                double iftmp$0 = lower_tail != 0 ? xend : xstart;
                return iftmp$0;
            }
            double d2 = -1.0 / 0.0;
            if (p == d2) {
                double iftmp$1 = lower_tail != 0 ? xstart : xend;
                return iftmp$1;
            }
        } else {
            if (p < 0.0) return 0.0 / 0.0;
            if (p > 1.0) return 0.0 / 0.0;
            if (p == 0.0) {
                double iftmp$2 = lower_tail != 0 ? xstart : xend;
                return iftmp$2;
            }
            if (p == 1.0) {
                double iftmp$3 = lower_tail != 0 ? xend : xstart;
                return iftmp$3;
            }
        }
        double xr = xstart;
        double xb = n - xr;
        small_N = N < 1000.0;
        double d3 = choose.Rf_lfastchoose(NR, xr);
        double d4 = choose.Rf_lfastchoose(NB, xb);
        double d5 = d3 + d4;
        double d6 = choose.Rf_lfastchoose(N, n);
        double term = d5 - d6;
        if (small_N) {
            term = Mathlib.exp((double)term);
        }
        NR -= xr;
        NB -= xb;
        if (lower_tail == 0 || log_p != 0) {
            double iftmp$4;
            if (log_p != 0) {
                double iftmp$5 = lower_tail != 0 ? Mathlib.exp((double)p) : -Mathlib.expm1((double)p);
                iftmp$4 = iftmp$5;
            } else {
                double iftmp$6 = lower_tail == 0 ? 0.5 - p + 0.5 : p;
                iftmp$4 = iftmp$6;
            }
            p = iftmp$4;
        }
        p *= 0.999999999999778;
        double iftmp$7 = !small_N ? Mathlib.exp((double)term) : term;
        double sum = iftmp$7;
        while (sum < p && xr < xend) {
            xr += 1.0;
            NB += 1.0;
            if (small_N) {
                double d7 = NR / xr;
                double d8 = xb / NB;
                term = d7 * d8 * term;
            } else {
                double d9 = NR / xr;
                double d10 = xb / NB;
                term = Mathlib.log((double)(d9 * d10)) + term;
            }
            double iftmp$8 = !small_N ? Mathlib.exp((double)term) : term;
            sum = iftmp$8 + sum;
            xb -= 1.0;
            NR -= 1.0;
        }
        return xr;
    }
}

