/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.qnorm;

public class qlnorm {
    private qlnorm() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double qlnorm(double p, double meanlog, double sdlog, int lower_tail, int log_p) {
        if (Double.isNaN(p)) return p + meanlog + sdlog;
        if (Double.isNaN(p)) return p + meanlog + sdlog;
        if (Double.isNaN(meanlog)) return p + meanlog + sdlog;
        if (Double.isNaN(meanlog)) return p + meanlog + sdlog;
        if (Double.isNaN(sdlog)) return p + meanlog + sdlog;
        if (Double.isNaN(sdlog)) return p + meanlog + sdlog;
        if (log_p != 0) {
            if (p > 0.0) return 0.0 / 0.0;
            if (p == 0.0) {
                if (lower_tail == 0) {
                    return 0.0;
                }
                double iftmp$0 = 1.0 / 0.0;
                return iftmp$0;
            }
            double d = -1.0 / 0.0;
            if (p != d) return Mathlib.exp((double)qnorm.qnorm5(p, meanlog, sdlog, lower_tail, log_p));
            if (lower_tail != 0) {
                return 0.0;
            }
            double iftmp$1 = 1.0 / 0.0;
            return iftmp$1;
        }
        if (p < 0.0) return 0.0 / 0.0;
        if (p > 1.0) return 0.0 / 0.0;
        if (p == 0.0) {
            if (lower_tail != 0) {
                return 0.0;
            }
            double iftmp$2 = 1.0 / 0.0;
            return iftmp$2;
        }
        if (p != 1.0) return Mathlib.exp((double)qnorm.qnorm5(p, meanlog, sdlog, lower_tail, log_p));
        if (lower_tail == 0) {
            return 0.0;
        }
        double iftmp$3 = 1.0 / 0.0;
        return iftmp$3;
    }
}

