/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.nmath.fmax2;
import org.renjin.nmath.pnbinom;
import org.renjin.nmath.qnorm;
import org.renjin.nmath.qpois;

public class qnbinom {
    private qnbinom() {
    }

    public static double qnbinom_mu(double p, double size, double mu, int lower_tail, int log_p) {
        double d;
        double d2 = 1.0 / 0.0;
        if (size == d2) {
            d = qpois.qpois(p, mu, lower_tail, log_p);
        } else {
            double d3 = size + mu;
            double d4 = size / d3;
            d = qnbinom.qnbinom(p, size, d4, lower_tail, log_p);
        }
        return d;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double qnbinom(double p, double size, double prob, int lower_tail, int log_p) {
        double oldincr;
        double z$17;
        double z$13;
        double[] z = new double[]{0.0};
        if (Double.isNaN(p)) return p + size + prob;
        if (Double.isNaN(p)) return p + size + prob;
        if (Double.isNaN(size)) return p + size + prob;
        if (Double.isNaN(size)) return p + size + prob;
        if (Double.isNaN(prob)) return p + size + prob;
        if (Double.isNaN(prob)) return p + size + prob;
        if (prob == 0.0) {
            if (size == 0.0) return 0.0;
        }
        if (prob <= 0.0) return 0.0 / 0.0;
        if (prob > 1.0) return 0.0 / 0.0;
        if (size < 0.0) return 0.0 / 0.0;
        if (prob == 1.0) return 0.0;
        if (size == 0.0) return 0.0;
        if (log_p != 0) {
            if (p > 0.0) return 0.0 / 0.0;
            if (p == 0.0) {
                if (lower_tail == 0) {
                    return 0.0;
                }
                double iftmp$0 = 1.0 / 0.0;
                return iftmp$0;
            }
            double d = -1.0 / 0.0;
            if (p == d) {
                if (lower_tail != 0) {
                    return 0.0;
                }
                double iftmp$1 = 1.0 / 0.0;
                return iftmp$1;
            }
        } else {
            if (p < 0.0) return 0.0 / 0.0;
            if (p > 1.0) return 0.0 / 0.0;
            if (p == 0.0) {
                if (lower_tail != 0) {
                    return 0.0;
                }
                double iftmp$2 = 1.0 / 0.0;
                return iftmp$2;
            }
            if (p == 1.0) {
                if (lower_tail == 0) {
                    return 0.0;
                }
                double iftmp$3 = 1.0 / 0.0;
                return iftmp$3;
            }
        }
        double Q = 1.0 / prob;
        double P = (1.0 - prob) * Q;
        double mu = size * P;
        double sigma = Mathlib.sqrt((double)(size * P * Q));
        double gamma2 = (Q + P) / sigma;
        if (lower_tail == 0 || log_p != 0) {
            double iftmp$10;
            double iftmp$7;
            double iftmp$4;
            if (log_p != 0) {
                double iftmp$5 = lower_tail != 0 ? Mathlib.exp((double)p) : -Mathlib.expm1((double)p);
                iftmp$4 = iftmp$5;
            } else {
                double iftmp$6 = lower_tail == 0 ? 0.5 - p + 0.5 : p;
                iftmp$4 = iftmp$6;
            }
            p = iftmp$4;
            if (lower_tail != 0) {
                double iftmp$8 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$7 = iftmp$8;
            } else {
                double iftmp$9 = log_p != 0 ? 0.0 : 1.0;
                iftmp$7 = iftmp$9;
            }
            if (iftmp$7 == p) return 0.0;
            if (lower_tail != 0) {
                double iftmp$11 = log_p != 0 ? 0.0 : 1.0;
                iftmp$10 = iftmp$11;
            } else {
                double iftmp$12 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$10 = iftmp$12;
            }
            if (iftmp$10 == p) return 1.0 / 0.0;
        }
        if (p + 2.242650509742816E-16 >= 1.0) return 1.0 / 0.0;
        z[0] = z$13 = qnorm.qnorm5(p, 0.0, 1.0, 1, 0);
        double z$14 = z[0];
        double z$15 = z[0];
        double d = (z$14 * z$15 - 1.0) * gamma2 / 6.0;
        double z$16 = z[0];
        double y = Mathlib.round((double)((d + z$16) * sigma + mu));
        z[0] = z$17 = pnbinom.pnbinom(y, size, prob, 1, 0);
        p *= 0.9999999999999858;
        if (y < 100000.0) return qnbinom.do_search(y, (Ptr)new DoublePtr(z, 0), p, size, prob, 1.0);
        double incr = Mathlib.floor((double)(y * 0.001));
        do {
            oldincr = incr;
            y = qnbinom.do_search(y, (Ptr)new DoublePtr(z, 0), p, size, prob, incr);
            double d2 = Mathlib.floor((double)(incr / 100.0));
            incr = fmax2.fmax2(1.0, d2);
        } while (oldincr > 1.0 && y * 1.0E-15 < incr);
        return y;
    }

    public static double do_search(double y, Ptr z, double p, double n, double pr, double incr) {
        double d;
        block3: {
            block4: {
                if (!(z.getDouble() >= p)) break block4;
                while (true) {
                    block6: {
                        block5: {
                            if (y == 0.0) break block5;
                            double d2 = pnbinom.pnbinom(y - incr, n, pr, 1, 0);
                            z.setDouble(d2);
                            if (!(z.getDouble() < p)) break block6;
                        }
                        d = y;
                        break block3;
                    }
                    double d3 = y - incr;
                    y = fmax2.fmax2(0.0, d3);
                }
            }
            do {
                double d4 = pnbinom.pnbinom(y += incr, n, pr, 1, 0);
                z.setDouble(d4);
            } while (!(z.getDouble() >= p));
            d = y;
        }
        return d;
    }
}

