/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.nmath.qnbeta;
import org.renjin.nmath.qnchisq;

public class qnf {
    private qnf() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double qnf(double p, double df1, double df2, double ncp, int lower_tail, int log_p) {
        if (Double.isNaN(p)) return p + df1 + df2 + ncp;
        if (Double.isNaN(p)) return p + df1 + df2 + ncp;
        if (Double.isNaN(df1)) return p + df1 + df2 + ncp;
        if (Double.isNaN(df1)) return p + df1 + df2 + ncp;
        if (Double.isNaN(df2)) return p + df1 + df2 + ncp;
        if (Double.isNaN(df2)) return p + df1 + df2 + ncp;
        if (Double.isNaN(ncp)) return p + df1 + df2 + ncp;
        if (Double.isNaN(ncp)) return p + df1 + df2 + ncp;
        if (df1 <= 0.0) return 0.0 / 0.0;
        if (df2 <= 0.0) return 0.0 / 0.0;
        if (ncp < 0.0) return 0.0 / 0.0;
        if (!(Math.abs(ncp) <= Double.MAX_VALUE)) return 0.0 / 0.0;
        if (!(Math.abs(df1) <= Double.MAX_VALUE)) {
            if (!(Math.abs(df2) <= Double.MAX_VALUE)) return 0.0 / 0.0;
        }
        if (log_p != 0) {
            if (p > 0.0) return 0.0 / 0.0;
            if (p == 0.0) {
                if (lower_tail == 0) {
                    return 0.0;
                }
                double iftmp$0 = 1.0 / 0.0;
                return iftmp$0;
            }
            double d = -1.0 / 0.0;
            if (p == d) {
                if (lower_tail != 0) {
                    return 0.0;
                }
                double iftmp$1 = 1.0 / 0.0;
                return iftmp$1;
            }
        } else {
            if (p < 0.0) return 0.0 / 0.0;
            if (p > 1.0) return 0.0 / 0.0;
            if (p == 0.0) {
                if (lower_tail != 0) {
                    return 0.0;
                }
                double iftmp$2 = 1.0 / 0.0;
                return iftmp$2;
            }
            if (p == 1.0) {
                if (lower_tail == 0) {
                    return 0.0;
                }
                double iftmp$3 = 1.0 / 0.0;
                return iftmp$3;
            }
        }
        if (df2 > 1.0E8) return qnchisq.qnchisq(p, df1, ncp, lower_tail, log_p) / df1;
        double d = df2 / 2.0;
        double d2 = df1 / 2.0;
        double y = qnbeta.qnbeta(p, d2, d, ncp, lower_tail, log_p);
        double d3 = 1.0 - y;
        double d4 = y / d3;
        double d5 = df2 / df1;
        return d4 * d5;
    }
}

