/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.nmath.fmax2;
import org.renjin.nmath.ppois;
import org.renjin.nmath.qnorm;

public class qpois {
    private qpois() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double qpois(double p, double lambda, int lower_tail, int log_p) {
        double oldincr;
        double z$13;
        double z$9;
        double iftmp$3;
        double iftmp$0;
        double[] z = new double[]{0.0};
        if (Double.isNaN(p)) return p + lambda;
        if (Double.isNaN(p)) return p + lambda;
        if (Double.isNaN(lambda)) return p + lambda;
        if (Double.isNaN(lambda)) return p + lambda;
        if (!(Math.abs(lambda) <= Double.MAX_VALUE)) return 0.0 / 0.0;
        if (lambda < 0.0) return 0.0 / 0.0;
        if (log_p != 0) {
            if (p > 0.0) return 0.0 / 0.0;
        }
        if (log_p == 0) {
            if (p < 0.0) return 0.0 / 0.0;
            if (p > 1.0) return 0.0 / 0.0;
        }
        if (lambda == 0.0) return 0.0;
        if (lower_tail != 0) {
            double iftmp$1 = log_p != 0 ? -1.0 / 0.0 : 0.0;
            iftmp$0 = iftmp$1;
        } else {
            double iftmp$2 = log_p != 0 ? 0.0 : 1.0;
            iftmp$0 = iftmp$2;
        }
        if (iftmp$0 == p) return 0.0;
        if (lower_tail != 0) {
            double iftmp$4 = log_p != 0 ? 0.0 : 1.0;
            iftmp$3 = iftmp$4;
        } else {
            double iftmp$5 = log_p != 0 ? -1.0 / 0.0 : 0.0;
            iftmp$3 = iftmp$5;
        }
        if (iftmp$3 == p) return 1.0 / 0.0;
        double mu = lambda;
        double sigma = Mathlib.sqrt((double)lambda);
        double gamma2 = 1.0 / sigma;
        if (lower_tail == 0 || log_p != 0) {
            double iftmp$6;
            if (log_p != 0) {
                double iftmp$7 = lower_tail != 0 ? Mathlib.exp((double)p) : -Mathlib.expm1((double)p);
                iftmp$6 = iftmp$7;
            } else {
                double iftmp$8 = lower_tail == 0 ? 0.5 - p + 0.5 : p;
                iftmp$6 = iftmp$8;
            }
            p = iftmp$6;
            if (p == 0.0) return 0.0;
            if (p == 1.0) return 1.0 / 0.0;
        }
        if (p + 2.242650509742816E-16 >= 1.0) return 1.0 / 0.0;
        z[0] = z$9 = qnorm.qnorm5(p, 0.0, 1.0, 1, 0);
        double z$10 = z[0];
        double z$11 = z[0];
        double d = (z$10 * z$11 - 1.0) * gamma2 / 6.0;
        double z$12 = z[0];
        double y = Mathlib.round((double)((d + z$12) * sigma + mu));
        z[0] = z$13 = ppois.ppois(y, lambda, 1, 0);
        p *= 0.9999999999999858;
        if (lambda < 100000.0) return qpois.do_search(y, (Ptr)new DoublePtr(z, 0), p, lambda, 1.0);
        double incr = Mathlib.floor((double)(y * 0.001));
        do {
            oldincr = incr;
            y = qpois.do_search(y, (Ptr)new DoublePtr(z, 0), p, lambda, incr);
            double d2 = Mathlib.floor((double)(incr / 100.0));
            incr = fmax2.fmax2(1.0, d2);
        } while (oldincr > 1.0 && lambda * 1.0E-15 < incr);
        return y;
    }

    public static double do_search(double y, Ptr z, double p, double lambda, double incr) {
        double d;
        block3: {
            block4: {
                if (!(z.getDouble() >= p)) break block4;
                while (true) {
                    block6: {
                        block5: {
                            if (y == 0.0) break block5;
                            double d2 = ppois.ppois(y - incr, lambda, 1, 0);
                            z.setDouble(d2);
                            if (!(z.getDouble() < p)) break block6;
                        }
                        d = y;
                        break block3;
                    }
                    double d3 = y - incr;
                    y = fmax2.fmax2(0.0, d3);
                }
            }
            do {
                double d4 = ppois.ppois(y += incr, lambda, 1, 0);
                z.setDouble(d4);
            } while (!(z.getDouble() >= p));
            d = y;
        }
        return d;
    }
}

