/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.fmax2;
import org.renjin.nmath.ptukey;

public class qtukey {
    public static double c5$4365 = 1.4142;
    public static double c4$4364 = 1.208;
    public static double c3$4363 = 1.214;
    public static double c2$4362 = 0.2368;
    public static double c1$4361 = 0.8832;
    public static double vmax$4366 = 120.0;
    public static double q0$4352 = 0.099348462606;
    public static double q1$4354 = 0.588581570495;
    public static double q2$4356 = 0.531103462366;
    public static double q3$4358 = 0.10353775285;
    public static double q4$4360 = 0.0038560700634;
    public static double p0$4351 = 0.322232421088;
    public static double p1$4353 = -1.0;
    public static double p2$4355 = -0.342242088547;
    public static double p3$4357 = -0.204231210125;
    public static double p4$4359 = -4.53642210148E-5;
    public static double eps$4379 = 1.0E-4;
    public static double $qtukey$eps = 1.0E-4;
    public static double $qinv$vmax = 120.0;
    public static double $qinv$c5 = 1.4142;
    public static double $qinv$c4 = 1.208;
    public static double $qinv$c3 = 1.214;
    public static double $qinv$c2 = 0.2368;
    public static double $qinv$c1 = 0.8832;
    public static double $qinv$q4 = 0.0038560700634;
    public static double $qinv$p4 = -4.53642210148E-5;
    public static double $qinv$q3 = 0.10353775285;
    public static double $qinv$p3 = -0.204231210125;
    public static double $qinv$q2 = 0.531103462366;
    public static double $qinv$p2 = -0.342242088547;
    public static double $qinv$q1 = 0.588581570495;
    public static double $qinv$p1 = -1.0;
    public static double $qinv$q0 = 0.099348462606;
    public static double $qinv$p0 = 0.322232421088;

    private qtukey() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double qtukey(double p, double rr, double cc, double df2, int lower_tail, int log_p) {
        double x1;
        double iftmp$4;
        int maxiter = 0;
        maxiter = 50;
        double ans = 0.0;
        if (Double.isNaN(p)) return p + rr + cc + df2;
        if (Double.isNaN(p)) return p + rr + cc + df2;
        if (Double.isNaN(rr)) return p + rr + cc + df2;
        if (Double.isNaN(rr)) return p + rr + cc + df2;
        if (Double.isNaN(cc)) return p + rr + cc + df2;
        if (Double.isNaN(cc)) return p + rr + cc + df2;
        if (Double.isNaN(df2)) return p + rr + cc + df2;
        if (Double.isNaN(df2)) return p + rr + cc + df2;
        if (df2 < 2.0) return 0.0 / 0.0;
        if (rr < 1.0) return 0.0 / 0.0;
        if (cc < 2.0) return 0.0 / 0.0;
        if (log_p != 0) {
            if (p > 0.0) return 0.0 / 0.0;
            if (p == 0.0) {
                if (lower_tail == 0) {
                    return 0.0;
                }
                double iftmp$0 = 1.0 / 0.0;
                return iftmp$0;
            }
            double d = -1.0 / 0.0;
            if (p == d) {
                if (lower_tail != 0) {
                    return 0.0;
                }
                double iftmp$1 = 1.0 / 0.0;
                return iftmp$1;
            }
        } else {
            if (p < 0.0) return 0.0 / 0.0;
            if (p > 1.0) return 0.0 / 0.0;
            if (p == 0.0) {
                if (lower_tail != 0) {
                    return 0.0;
                }
                double iftmp$2 = 1.0 / 0.0;
                return iftmp$2;
            }
            if (p == 1.0) {
                if (lower_tail == 0) {
                    return 0.0;
                }
                double iftmp$3 = 1.0 / 0.0;
                return iftmp$3;
            }
        }
        if (log_p != 0) {
            double iftmp$5 = lower_tail != 0 ? Mathlib.exp((double)p) : -Mathlib.expm1((double)p);
            iftmp$4 = iftmp$5;
        } else {
            double iftmp$6 = lower_tail == 0 ? 0.5 - p + 0.5 : p;
            iftmp$4 = iftmp$6;
        }
        p = iftmp$4;
        double x0 = qtukey.qinv(p, cc, df2);
        double valx0 = ptukey.ptukey(x0, rr, cc, df2, 1, 0) - p;
        if (valx0 > 0.0) {
            double d = x0 - 1.0;
            x1 = fmax2.fmax2(0.0, d);
        } else {
            x1 = x0 + 1.0;
        }
        double valx1 = ptukey.ptukey(x1, rr, cc, df2, 1, 0) - p;
        int iter = 1;
        while (iter < maxiter) {
            double d = (x1 - x0) * valx1;
            double d2 = valx1 - valx0;
            double d3 = d / d2;
            ans = x1 - d3;
            valx0 = valx1;
            x0 = x1;
            if (ans < 0.0) {
                ans = 0.0;
                valx1 = -p;
            }
            valx1 = ptukey.ptukey(ans, rr, cc, df2, 1, 0) - p;
            x1 = ans;
            double xabs = Math.abs(x1 - x0);
            double eps$7 = $qtukey$eps;
            if (xabs < eps$7) return ans;
            ++iter;
        }
        BytePtr msg = new BytePtr("\u0000".getBytes(), 0);
        int msg$offset = 0;
        msg = new BytePtr("convergence failed in '%s'\n\u0000".getBytes(), 0);
        msg$offset = 0;
        Stdlib.printf((BytePtr)((BytePtr)msg.pointerPlus(msg$offset)), (Object[])new Object[]{new BytePtr("qtukey\u0000".getBytes(), 0)});
        return ans;
    }

    public static double qinv(double p, double c, double v) {
        double d = p * 0.5;
        double d2 = 0.5 - d;
        double d3 = d2 * d2;
        double yi = Mathlib.sqrt((double)Mathlib.log((double)(1.0 / d3)));
        double p4$8 = $qinv$p4;
        double d4 = yi * p4$8;
        double p3$9 = $qinv$p3;
        double d5 = (d4 + p3$9) * yi;
        double p2$10 = $qinv$p2;
        double d6 = (d5 + p2$10) * yi;
        double p1$11 = $qinv$p1;
        double d7 = (d6 + p1$11) * yi;
        double p0$12 = $qinv$p0;
        double d8 = d7 + p0$12;
        double q4$13 = $qinv$q4;
        double d9 = yi * q4$13;
        double q3$14 = $qinv$q3;
        double d10 = (d9 + q3$14) * yi;
        double q2$15 = $qinv$q2;
        double d11 = (d10 + q2$15) * yi;
        double q1$16 = $qinv$q1;
        double d12 = (d11 + q1$16) * yi;
        double q0$17 = $qinv$q0;
        double d13 = d12 + q0$17;
        double t = d8 / d13 + yi;
        double vmax$18 = $qinv$vmax;
        if (v < vmax$18) {
            double d14 = t;
            t = (d14 * d14 * t + t) / v / 4.0 + t;
        }
        double c1$19 = $qinv$c1;
        double d15 = $qinv$c2 * t;
        double q = c1$19 - d15;
        double vmax$21 = $qinv$vmax;
        if (v < vmax$21) {
            double d16 = -$qinv$c3 / v;
            double d17 = $qinv$c4 * t / v;
            q = d16 + d17 + q;
        }
        double d18 = Mathlib.log((double)(c - 1.0)) * q;
        double c5$24 = $qinv$c5;
        return (d18 + c5$24) * t;
    }
}

