/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import java.lang.invoke.MethodHandle;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.math.Errors;
import org.renjin.nmath.rbinom;

public class rmultinom {
    private rmultinom() {
    }

    public static void rmultinom(MethodHandle unif_rand, int n, Ptr prob, int K, Ptr rN) {
        block14: {
            double p_tot = 0.0;
            if (K > 0) {
                if (n < 0) {
                    rN.setInt(-1);
                } else {
                    double pp;
                    int k = 0;
                    while (k < K) {
                        Ptr ptr = prob;
                        int n2 = k * 8;
                        int n3 = n2;
                        pp = ptr.getDouble(n3);
                        if (!(Math.abs(pp) <= Double.MAX_VALUE) || pp < 0.0 || pp > 1.0) {
                            int n4 = k * 4;
                            Ptr ptr2 = rN;
                            int n5 = n4;
                            ptr2.setInt(n5, -1);
                            break block14;
                        }
                        p_tot += pp;
                        int n6 = k * 4;
                        Ptr ptr3 = rN;
                        int n7 = n6;
                        ptr3.setInt(n7, 0);
                        ++k;
                    }
                    if (Math.abs(p_tot - 1.0) > 1.0E-7) {
                        Errors.arith_error((BytePtr)new BytePtr("rbinom: probability sum should be 1, but is %g\u0000".getBytes(), 0), (double)p_tot);
                    }
                    if (n != 0) {
                        if (K != 1 || p_tot != 0.0) {
                            k = 0;
                            while (K + -1 > k) {
                                Ptr ptr = prob;
                                int n8 = k * 8;
                                int n9 = n8;
                                if (ptr.getDouble(n9) != 0.0) {
                                    int iftmp$6;
                                    int n10 = k * 8;
                                    Ptr ptr4 = prob;
                                    int n11 = n10;
                                    pp = ptr4.getDouble(n11) / p_tot;
                                    int n12 = k * 4;
                                    Ptr ptr5 = rN;
                                    int n13 = n12;
                                    if (pp < 1.0) {
                                        double d = n;
                                        iftmp$6 = (int)rbinom.rbinom(unif_rand, d, pp);
                                    } else {
                                        iftmp$6 = n;
                                    }
                                    ptr5.setInt(n13, iftmp$6);
                                    int n14 = k * 4;
                                    Ptr ptr6 = rN;
                                    int n15 = n14;
                                    int n16 = ptr6.getInt(n15);
                                    n -= n16;
                                } else {
                                    int n17 = k * 4;
                                    Ptr ptr7 = rN;
                                    int n18 = n17;
                                    ptr7.setInt(n18, 0);
                                }
                                if (n > 0) {
                                    int n19 = k * 8;
                                    Ptr ptr8 = prob;
                                    int n20 = n19;
                                    double d = ptr8.getDouble(n20);
                                    p_tot -= d;
                                    ++k;
                                    continue;
                                }
                                break block14;
                            }
                            int n21 = (K + -1) * 4;
                            Ptr ptr = rN;
                            int n22 = n21;
                            ptr.setInt(n22, n);
                        }
                    }
                }
            }
        }
    }
}

