/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import java.lang.invoke.MethodHandle;
import org.renjin.nmath.rgamma;
import org.renjin.nmath.rpois;

public class rnbinom {
    private rnbinom() {
    }

    public static double rnbinom_mu(MethodHandle unif_rand, double size, double mu) {
        double d;
        if (!(Math.abs(mu) <= Double.MAX_VALUE) || size <= 0.0 || mu < 0.0) {
            d = 0.0 / 0.0;
        } else {
            double iftmp$0;
            if (!(Math.abs(size) <= Double.MAX_VALUE)) {
                size = 8.988465674311579E307;
            }
            if (mu != 0.0) {
                double d2 = mu / size;
                double d3 = rgamma.rgamma(unif_rand, size, d2);
                iftmp$0 = rpois.rpois(unif_rand, d3);
            } else {
                iftmp$0 = 0.0;
            }
            d = iftmp$0;
        }
        return d;
    }

    public static double rnbinom(MethodHandle unif_rand, double size, double prob) {
        double d;
        if (!(Math.abs(prob) <= Double.MAX_VALUE) || size <= 0.0 || prob <= 0.0 || prob > 1.0) {
            d = 0.0 / 0.0;
        } else {
            double iftmp$1;
            if (!(Math.abs(size) <= Double.MAX_VALUE)) {
                size = 8.988465674311579E307;
            }
            if (prob != 1.0) {
                double d2 = (1.0 - prob) / prob;
                double d3 = rgamma.rgamma(unif_rand, size, d2);
                iftmp$1 = rpois.rpois(unif_rand, d3);
            } else {
                iftmp$1 = 0.0;
            }
            d = iftmp$1;
        }
        return d;
    }
}

