/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import java.lang.invoke.MethodHandle;
import org.renjin.nmath.rchisq;
import org.renjin.nmath.rgamma;
import org.renjin.nmath.rpois;

public class rnchisq {
    private rnchisq() {
    }

    public static double rnchisq(MethodHandle unif_rand, double df2, double lambda) {
        double d;
        if (!(Math.abs(df2) <= Double.MAX_VALUE) || !(Math.abs(lambda) <= Double.MAX_VALUE) || df2 < 0.0 || lambda < 0.0) {
            d = 0.0 / 0.0;
        } else if (lambda == 0.0) {
            double iftmp$0;
            if (df2 != 0.0) {
                double d2 = df2 / 2.0;
                iftmp$0 = rgamma.rgamma(unif_rand, d2, 2.0);
            } else {
                iftmp$0 = 0.0;
            }
            d = iftmp$0;
        } else {
            double d3 = lambda / 2.0;
            double r = rpois.rpois(unif_rand, d3);
            if (r > 0.0) {
                double d4 = r * 2.0;
                r = rchisq.rchisq(unif_rand, d4);
            }
            if (df2 > 0.0) {
                double d5 = df2 / 2.0;
                r = rgamma.rgamma(unif_rand, d5, 2.0) + r;
            }
            d = r;
        }
        return d;
    }
}

