/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import java.lang.invoke.MethodHandle;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.nmath.imin2;

public class signrank {
    public static int allocated_n = 0;
    public static Ptr w = BytePtr.of((int)0);

    private signrank() {
    }

    public static double rsignrank(MethodHandle unif_rand, double n) {
        double d;
        int k = 0;
        if (Double.isNaN(n) || Double.isNaN(n)) {
            d = n;
        } else {
            n = Mathlib.round((double)n);
            if (n < 0.0) {
                d = 0.0 / 0.0;
            } else if (n == 0.0) {
                d = 0.0;
            } else {
                double r = 0.0;
                k = (int)n;
                int i = 0;
                while (i < k) {
                    double d2 = ++i;
                    double d3 = Mathlib.floor((double)(unif_rand.invoke() + 0.5));
                    r = d2 * d3 + r;
                }
                d = r;
            }
        }
        return d;
    }

    public static double qsignrank(double x, double n, int lower_tail, int log_p) {
        double d;
        int nn = 0;
        double f = 0.0;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(n) || Double.isNaN(n)) {
            d = x + n;
        } else if (!(Math.abs(x) <= Double.MAX_VALUE) || !(Math.abs(n) <= Double.MAX_VALUE)) {
            d = 0.0 / 0.0;
        } else if (log_p != 0 && x > 0.0 || log_p == 0 && (x < 0.0 || x > 1.0)) {
            d = 0.0 / 0.0;
        } else if ((n = Mathlib.round((double)n)) <= 0.0) {
            d = 0.0 / 0.0;
        } else {
            double iftmp$0;
            if (lower_tail != 0) {
                double iftmp$1 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$0 = iftmp$1;
            } else {
                double iftmp$2 = log_p != 0 ? 0.0 : 1.0;
                iftmp$0 = iftmp$2;
            }
            if (iftmp$0 == x) {
                d = 0.0;
            } else {
                double iftmp$3;
                if (lower_tail != 0) {
                    double iftmp$4 = log_p != 0 ? 0.0 : 1.0;
                    iftmp$3 = iftmp$4;
                } else {
                    double iftmp$5 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                    iftmp$3 = iftmp$5;
                }
                if (iftmp$3 == x) {
                    d = (n + 1.0) * n / 2.0;
                } else {
                    if (log_p != 0 || lower_tail == 0) {
                        double iftmp$6;
                        if (log_p != 0) {
                            double iftmp$7 = lower_tail != 0 ? Mathlib.exp((double)x) : -Mathlib.expm1((double)x);
                            iftmp$6 = iftmp$7;
                        } else {
                            double iftmp$8 = lower_tail == 0 ? 0.5 - x + 0.5 : x;
                            iftmp$6 = iftmp$8;
                        }
                        x = iftmp$6;
                    }
                    nn = (int)n;
                    signrank.w_init_maybe(nn);
                    f = Mathlib.exp((double)(-n * 0.6931471805599453));
                    double p = 0.0;
                    int q = 0;
                    if (x <= 0.5) {
                        x -= 2.220446049250313E-15;
                        while (!((p = signrank.csignrank(q, nn) * f + p) >= x)) {
                            ++q;
                        }
                    } else {
                        x = 1.0 - x + 2.220446049250313E-15;
                        while (true) {
                            if ((p = signrank.csignrank(q, nn) * f + p) > x) {
                                double d2 = (n + 1.0) * n / 2.0;
                                double d3 = q;
                                q = (int)(d2 - d3);
                                break;
                            }
                            ++q;
                        }
                    }
                    d = q;
                }
            }
        }
        return d;
    }

    public static double psignrank(double x, double n, int lower_tail, int log_p) {
        double d;
        int nn = 0;
        double f = 0.0;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(n) || Double.isNaN(n)) {
            d = x + n;
        } else if (!(Math.abs(n) <= Double.MAX_VALUE)) {
            d = 0.0 / 0.0;
        } else {
            n = Mathlib.round((double)n);
            if (n <= 0.0) {
                d = 0.0 / 0.0;
            } else {
                x = Mathlib.round((double)(x + 1.0E-7));
                if (x < 0.0) {
                    double iftmp$9;
                    if (lower_tail != 0) {
                        double iftmp$10 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                        iftmp$9 = iftmp$10;
                    } else {
                        double iftmp$11 = log_p != 0 ? 0.0 : 1.0;
                        iftmp$9 = iftmp$11;
                    }
                    d = iftmp$9;
                } else if ((n + 1.0) * n / 2.0 <= x) {
                    double iftmp$12;
                    if (lower_tail != 0) {
                        double iftmp$13 = log_p != 0 ? 0.0 : 1.0;
                        iftmp$12 = iftmp$13;
                    } else {
                        double iftmp$14 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                        iftmp$12 = iftmp$14;
                    }
                    d = iftmp$12;
                } else {
                    double iftmp$15;
                    nn = (int)n;
                    signrank.w_init_maybe(nn);
                    f = Mathlib.exp((double)(-n * 0.6931471805599453));
                    double p = 0.0;
                    if ((n + 1.0) * n / 4.0 >= x) {
                        int i = 0;
                        while ((double)i <= x) {
                            p = signrank.csignrank(i, nn) * f + p;
                            ++i;
                        }
                    } else {
                        x = (n + 1.0) * n / 2.0 - x;
                        int i = 0;
                        while ((double)i < x) {
                            p = signrank.csignrank(i, nn) * f + p;
                            ++i;
                        }
                        int n2 = lower_tail = lower_tail != 0 ? 0 : 1;
                    }
                    if (lower_tail != 0) {
                        double iftmp$16 = log_p != 0 ? Mathlib.log((double)p) : p;
                        iftmp$15 = iftmp$16;
                    } else {
                        double iftmp$17 = log_p != 0 ? Mathlib.log1p((double)(-p)) : 0.5 - p + 0.5;
                        iftmp$15 = iftmp$17;
                    }
                    d = iftmp$15;
                }
            }
        }
        return d;
    }

    public static double dsignrank(double x, double n, int log_p) {
        double d;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(n) || Double.isNaN(n)) {
            d = x + n;
        } else {
            n = Mathlib.round((double)n);
            if (n <= 0.0) {
                d = 0.0 / 0.0;
            } else {
                double d2 = Mathlib.round((double)x);
                if (Math.abs(x - d2) > 1.0E-7) {
                    double iftmp$18 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                    d = iftmp$18;
                } else if ((x = Mathlib.round((double)x)) < 0.0 || (n + 1.0) * n / 2.0 < x) {
                    double iftmp$19 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                    d = iftmp$19;
                } else {
                    double iftmp$20;
                    int nn = (int)n;
                    signrank.w_init_maybe(nn);
                    if (log_p != 0) {
                        double d3 = Mathlib.log((double)signrank.csignrank((int)x, nn));
                        double d4 = n * 0.6931471805599453;
                        iftmp$20 = d3 - d4;
                    } else {
                        double d5 = Mathlib.log((double)signrank.csignrank((int)x, nn));
                        double d6 = n * 0.6931471805599453;
                        iftmp$20 = Mathlib.exp((double)(d5 - d6));
                    }
                    d = iftmp$20;
                }
            }
        }
        return d;
    }

    public static double csignrank(int k, int n) {
        double d;
        int j = 0;
        int c = 0;
        int u = (n + 1) * n / 2;
        c = u / 2;
        if (k < 0 || k > u) {
            d = 0.0;
        } else {
            if (k > c) {
                k = u - k;
            }
            if (n == 1) {
                d = 1.0;
            } else if (w.getDouble() == 1.0) {
                Ptr w$22 = w;
                int n2 = k * 8;
                Ptr ptr = w$22;
                int n3 = 0 + n2;
                d = ptr.getDouble(n3);
            } else {
                Ptr w$24 = w;
                Ptr ptr = w;
                ptr.setDouble(8, 1.0);
                double d2 = ptr.getDouble(8);
                w$24.setDouble(0, d2);
                j = 2;
                while (n + 1 > j) {
                    int i = imin2.imin2((j + 1) * j / 2, c);
                    while (i >= j) {
                        Ptr w$26 = w;
                        int n4 = i * 8;
                        Ptr ptr2 = w$26;
                        int n5 = 0 + n4;
                        Ptr w$28 = w;
                        int n6 = i * 8;
                        Ptr ptr3 = w$28;
                        int n7 = 0 + n6;
                        double d3 = ptr3.getDouble(n7);
                        Ptr w$30 = w;
                        int n8 = (i - j) * 8;
                        Ptr ptr4 = w$30;
                        int n9 = 0 + n8;
                        double d4 = ptr4.getDouble(n9);
                        double d5 = d3 + d4;
                        ptr2.setDouble(n5, d5);
                        --i;
                    }
                    ++j;
                }
                Ptr w$31 = w;
                int n10 = k * 8;
                Ptr ptr5 = w$31;
                int n11 = 0 + n10;
                d = ptr5.getDouble(n11);
            }
        }
        return d;
    }

    public static void w_init_maybe(int n) {
        block5: {
            int c;
            block4: {
                c = (n + 1) * n / 2 / 2;
                if (w.isNull()) break block4;
                int allocated_n$34 = allocated_n;
                if (n == allocated_n$34) break block5;
                signrank.w_free();
            }
            if (w.isNull()) {
                w = DoublePtr.malloc((int)((c + 1) * 8));
                allocated_n = n;
            }
        }
    }

    public static void signrank_free() {
        signrank.w_free();
    }

    public static void w_free() {
        if (!w.isNull()) {
            Ptr w$39 = w;
            w = BytePtr.of((int)0);
            allocated_n = 0;
        }
    }
}

