/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.script;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import org.renjin.invoke.reflection.converters.Converters;
import org.renjin.repackaged.guava.base.Function;
import org.renjin.repackaged.guava.collect.Collections2;
import org.renjin.repackaged.guava.collect.Sets;
import org.renjin.sexp.Frame;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;

public class RenjinBindings
implements Bindings {
    private final Frame frame;

    public RenjinBindings(Frame frame) {
        this.frame = frame;
    }

    @Override
    public void clear() {
        this.frame.clear();
    }

    @Override
    public boolean containsValue(Object value) {
        for (Symbol symbol : this.frame.getSymbols()) {
            if (!this.frame.getVariable(symbol).equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        throw new UnsupportedOperationException("nyi");
    }

    @Override
    public boolean isEmpty() {
        return this.frame.getSymbols().isEmpty();
    }

    @Override
    public Set<String> keySet() {
        HashSet names = Sets.newHashSet();
        for (Symbol symbol : this.frame.getSymbols()) {
            names.add(symbol.getPrintName());
        }
        return names;
    }

    @Override
    public int size() {
        return this.frame.getSymbols().size();
    }

    @Override
    public Collection<Object> values() {
        return Collections2.transform((Collection)this.frame.getSymbols(), (Function)new Function<Symbol, Object>(){

            public Object apply(Symbol symbol) {
                return RenjinBindings.this.frame.getVariable(symbol);
            }
        });
    }

    @Override
    public boolean containsKey(Object key) {
        return this.frame.getSymbols().contains(this.toSymbol(key));
    }

    @Override
    public Object get(Object key) {
        return this.frame.getVariable(this.toSymbol(key));
    }

    private Symbol toSymbol(Object key) {
        if (key instanceof Symbol) {
            return (Symbol)key;
        }
        if (key instanceof String) {
            return Symbol.get((String)((String)key));
        }
        return Symbol.UNBOUND_VALUE;
    }

    @Override
    public Object put(String name, Object value) {
        Symbol symbol = Symbol.get((String)name);
        SEXP previousValue = this.frame.getVariable(symbol);
        Object exp = value == null ? Null.INSTANCE : Converters.get(value.getClass()).convertToR(value);
        this.frame.setVariable(symbol, (SEXP)exp);
        return previousValue;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> toMerge) {
        for (Map.Entry<? extends String, ? extends Object> entry : toMerge.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object remove(Object key) {
        Object originalValue = this.get(key);
        this.frame.remove(this.toSymbol(key));
        return originalValue;
    }
}

