/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats;

import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gnur.api.Error;
import org.renjin.gnur.api.GetText;
import org.renjin.gnur.api.Print;
import org.renjin.gnur.api.Rinternals;
import org.renjin.sexp.SEXP;

public class Srunmed__ {
    private Srunmed__() {
    }

    public static SEXP runmed(SEXP x, SEXP stype, SEXP sk, SEXP end, SEXP print_level) {
        if (Rinternals.TYPEOF((SEXP)x) != 14) {
            Error.Rf_error((BytePtr)new BytePtr("numeric 'x' required\u0000".getBytes(), 0), (Object[])new Object[0]);
        }
        int n = Rinternals.XLENGTH((SEXP)x);
        int type = Rinternals.Rf_asInteger((SEXP)stype);
        int k = Rinternals.Rf_asInteger((SEXP)sk);
        int iend = Rinternals.Rf_asInteger((SEXP)end);
        int pl = Rinternals.Rf_asInteger((SEXP)print_level);
        SEXP ans = Rinternals.Rf_protect((SEXP)Rinternals.Rf_allocVector((int)14, (int)n));
        if (type == 1) {
            if (Rinternals.IS_LONG_VEC((SEXP)x) != 0) {
                Error.Rf_error((BytePtr)new BytePtr("long vectors are not supported for algorithm = \"Turlach\"\u0000".getBytes(), 0), (Object[])new Object[0]);
            }
            IntPtr i1 = IntPtr.malloc((int)((k + 1) * 4));
            int i1$offset = 0;
            IntPtr i2 = IntPtr.malloc((int)(k * 8 + 4));
            int i2$offset = 0;
            DoublePtr d1 = DoublePtr.malloc((int)(k * 16 + 8));
            int d1$offset = 0;
            DoublePtr doublePtr = Rinternals.REAL((SEXP)ans);
            int n2 = 0;
            DoublePtr doublePtr2 = Rinternals.REAL((SEXP)x);
            int n3 = 0;
            Srunmed__.Trunmed(n, k, doublePtr2.pointerPlus(n3), doublePtr.pointerPlus(n2), i1.pointerPlus(i1$offset), i2.pointerPlus(i2$offset), d1.pointerPlus(d1$offset), iend, pl);
        } else {
            int n4 = pl <= 0 ? 0 : 1;
            DoublePtr doublePtr = Rinternals.REAL((SEXP)ans);
            int n5 = 0;
            DoublePtr doublePtr3 = Rinternals.REAL((SEXP)x);
            int n6 = 0;
            Srunmed__.Srunmed(doublePtr3.pointerPlus(n6), doublePtr.pointerPlus(n5), n, k, iend, n4);
        }
        Rinternals.Rf_unprotect((int)1);
        return ans;
    }

    public static void Srunmed(Ptr y, Ptr smo, int n, int bw, int end_rule, int debug) {
        int i;
        int i2 = 0;
        DoublePtr scrat = DoublePtr.NULL;
        int scrat$offset = 0;
        int kplus = 0;
        int kminus = 0;
        int band2 = 0;
        int last = 0;
        int first = 0;
        int ismo = 0;
        int imin = 0;
        double rts = 0.0;
        double rse = 0.0;
        double rtb = 0.0;
        double rbe = 0.0;
        double rnew = 0.0;
        double temp = 0.0;
        double rmin = 0.0;
        double rmed = 0.0;
        scrat = DoublePtr.malloc((int)(bw * 8));
        scrat$offset = 0;
        if (bw > n) {
            BytePtr bytePtr = GetText.dgettext((BytePtr)new BytePtr("stats\u0000".getBytes(), 0), (BytePtr)new BytePtr("bandwidth/span of running medians is larger than n\u0000".getBytes(), 0));
            int n2 = 0;
            Error.Rf_error((BytePtr)((BytePtr)bytePtr.pointerPlus(n2)), (Object[])new Object[0]);
        }
        int i3 = 0;
        while (i3 < bw) {
            int n3 = i3 * 8;
            DoublePtr doublePtr = scrat;
            int n4 = scrat$offset + n3;
            int n5 = i3 * 8;
            Ptr ptr = y;
            int n6 = 0 + n5;
            double d = ptr.getDouble(n6);
            doublePtr.setDouble(n4, d);
            ++i3;
        }
        rmin = scrat.getDouble(scrat$offset);
        imin = 0;
        int i4 = 1;
        while (i4 < bw) {
            DoublePtr doublePtr = scrat;
            int n7 = i4 * 8;
            int n8 = scrat$offset + n7;
            if (doublePtr.getDouble(n8) < rmin) {
                int n9 = i4 * 8;
                DoublePtr doublePtr2 = scrat;
                int n10 = scrat$offset + n9;
                rmin = doublePtr2.getDouble(n10);
                imin = i4;
            }
            ++i4;
        }
        temp = scrat.getDouble(scrat$offset);
        scrat.setDouble(scrat$offset, rmin);
        int n11 = imin * 8;
        DoublePtr doublePtr = scrat;
        int n12 = scrat$offset + n11;
        doublePtr.setDouble(n12, temp);
        i2 = 2;
        while (i2 < bw) {
            int n13;
            int n14;
            DoublePtr doublePtr3;
            double d;
            DoublePtr doublePtr4 = scrat;
            int n15 = i2 * 8;
            int n16 = scrat$offset + n15;
            double d2 = doublePtr4.getDouble(n16);
            if (d2 < (d = (doublePtr3 = scrat).getDouble(n14 = scrat$offset + (n13 = (i2 + -1) * 8)))) {
                int n17;
                int n18;
                DoublePtr doublePtr5;
                int n19 = i2 * 8;
                DoublePtr doublePtr6 = scrat;
                int n20 = scrat$offset + n19;
                temp = doublePtr6.getDouble(n20);
                int j = i2;
                do {
                    int n21 = j * 8;
                    DoublePtr doublePtr7 = scrat;
                    int n22 = scrat$offset + n21;
                    int n23 = (j + -1) * 8;
                    DoublePtr doublePtr8 = scrat;
                    int n24 = scrat$offset + n23;
                    double d3 = doublePtr8.getDouble(n24);
                    doublePtr7.setDouble(n22, d3);
                } while ((doublePtr5 = scrat).getDouble(n18 = scrat$offset + (n17 = (--j + -1) * 8)) > temp);
                int n25 = j * 8;
                DoublePtr doublePtr9 = scrat;
                int n26 = scrat$offset + n25;
                doublePtr9.setDouble(n26, temp);
            }
            ++i2;
        }
        band2 = bw / 2;
        int n27 = band2 * 8;
        DoublePtr doublePtr10 = scrat;
        int n28 = scrat$offset + n27;
        rmed = doublePtr10.getDouble(n28);
        if (end_rule == 0) {
            i = 0;
            while (i < band2) {
                int n29 = i * 8;
                Ptr ptr = smo;
                int n30 = 0 + n29;
                int n31 = i * 8;
                Ptr ptr2 = y;
                int n32 = 0 + n31;
                double d = ptr2.getDouble(n32);
                ptr.setDouble(n30, d);
                ++i;
            }
        } else {
            i = 0;
            while (i < band2) {
                int n33 = i * 8;
                Ptr ptr = smo;
                int n34 = 0 + n33;
                ptr.setDouble(n34, rmed);
                ++i;
            }
        }
        int n35 = band2 * 8;
        Ptr ptr = smo;
        int n36 = 0 + n35;
        ptr.setDouble(n36, rmed);
        ++band2;
        if (debug != 0) {
            Print.REprintf((BytePtr)new BytePtr("(bw,b2)= (%d,%d)\n\u0000".getBytes(), 0), (Object[])new Object[]{bw, band2});
        }
        first = 1;
        last = bw;
        ismo = band2;
        while (last < n) {
            double yi;
            int n37 = last * 8;
            Ptr ptr3 = y;
            int n38 = 0 + n37;
            double yin = ptr3.getDouble(n38);
            int n39 = (first + -1) * 8;
            Ptr ptr4 = y;
            int n40 = 0 + n39;
            double yout = ptr4.getDouble(n40);
            if (debug != 0) {
                Print.REprintf((BytePtr)new BytePtr(" is=%d, y(in/out)= %10g, %10g\u0000".getBytes(), 0), (Object[])new Object[]{ismo, yin, yout});
            }
            rnew = rmed;
            if (yin < rmed) {
                if (yout >= rmed) {
                    kminus = 0;
                    if (yout > rmed) {
                        if (debug != 0) {
                            Print.REprintf((BytePtr)new BytePtr(": yin < rmed < yout \u0000".getBytes(), 0), (Object[])new Object[0]);
                        }
                        rnew = yin;
                        i = first;
                        while (i <= last) {
                            Ptr ptr5 = y;
                            int n41 = i * 8;
                            int n42 = 0 + n41;
                            yi = ptr5.getDouble(n42);
                            if (yi < rmed) {
                                ++kminus;
                                if (yi > rnew) {
                                    rnew = yi;
                                }
                            }
                            ++i;
                        }
                        if (kminus < band2) {
                            rnew = rmed;
                        }
                    } else {
                        if (debug != 0) {
                            Print.REprintf((BytePtr)new BytePtr(": yin < rmed == yout \u0000".getBytes(), 0), (Object[])new Object[0]);
                        }
                        rse = rts = yin;
                        i = first;
                        while (i <= last) {
                            Ptr ptr6 = y;
                            int n43 = i * 8;
                            int n44 = 0 + n43;
                            yi = ptr6.getDouble(n44);
                            if (yi <= rmed) {
                                if (yi < rmed) {
                                    ++kminus;
                                    if (yi > rts) {
                                        rts = yi;
                                    }
                                    if (yi > rse) {
                                        rse = yi;
                                    }
                                } else {
                                    rse = yi;
                                }
                            }
                            ++i;
                        }
                        double iftmp$22 = kminus == band2 ? rts : rse;
                        rnew = iftmp$22;
                        if (debug != 0) {
                            Print.REprintf((BytePtr)new BytePtr("k- : %d,\u0000".getBytes(), 0), (Object[])new Object[]{kminus});
                        }
                    }
                }
            } else if (yin != rmed && yout <= rmed) {
                kplus = 0;
                if (yout < rmed) {
                    if (debug != 0) {
                        Print.REprintf((BytePtr)new BytePtr(": yout < rmed < yin \u0000".getBytes(), 0), (Object[])new Object[0]);
                    }
                    rnew = yin;
                    i = first;
                    while (i <= last) {
                        Ptr ptr7 = y;
                        int n45 = i * 8;
                        int n46 = 0 + n45;
                        yi = ptr7.getDouble(n46);
                        if (yi > rmed) {
                            ++kplus;
                            if (yi < rnew) {
                                rnew = yi;
                            }
                        }
                        ++i;
                    }
                    if (kplus < band2) {
                        rnew = rmed;
                    }
                } else {
                    if (debug != 0) {
                        Print.REprintf((BytePtr)new BytePtr(": yout == rmed < yin \u0000".getBytes(), 0), (Object[])new Object[0]);
                    }
                    rbe = rtb = yin;
                    i = first;
                    while (i <= last) {
                        Ptr ptr8 = y;
                        int n47 = i * 8;
                        int n48 = 0 + n47;
                        yi = ptr8.getDouble(n48);
                        if (yi >= rmed) {
                            if (yi > rmed) {
                                ++kplus;
                                if (yi < rtb) {
                                    rtb = yi;
                                }
                                if (yi < rbe) {
                                    rbe = yi;
                                }
                            } else {
                                rbe = yi;
                            }
                        }
                        ++i;
                    }
                    double iftmp$25 = kplus == band2 ? rtb : rbe;
                    rnew = iftmp$25;
                    if (debug != 0) {
                        Print.REprintf((BytePtr)new BytePtr("k+ : %d,\u0000".getBytes(), 0), (Object[])new Object[]{kplus});
                    }
                }
            }
            if (debug != 0) {
                Print.REprintf((BytePtr)new BytePtr("=> %12g, %12g\n\u0000".getBytes(), 0), (Object[])new Object[]{rmed, rnew});
            }
            rmed = rnew;
            int n49 = ismo * 8;
            Ptr ptr9 = smo;
            int n50 = 0 + n49;
            ptr9.setDouble(n50, rmed);
            ++first;
            ++last;
            ++ismo;
        }
        if (end_rule == 0) {
            i = ismo;
            while (i < n) {
                int n51 = i * 8;
                Ptr ptr10 = smo;
                int n52 = 0 + n51;
                int n53 = i * 8;
                Ptr ptr11 = y;
                int n54 = 0 + n53;
                double d = ptr11.getDouble(n54);
                ptr10.setDouble(n52, d);
                ++i;
            }
        } else {
            i = ismo;
            while (i < n) {
                int n55 = i * 8;
                Ptr ptr12 = smo;
                int n56 = 0 + n55;
                ptr12.setDouble(n56, rmed);
                ++i;
            }
        }
    }

    public static void Trunmed(int n, int k, Ptr data, Ptr median, Ptr outlist, Ptr nrlist, Ptr window, int end_rule, int print_level) {
        int k2 = 0;
        k2 = (k + -1) / 2;
        Srunmed__.inittree(n, k, k2, data, window, outlist, nrlist, print_level);
        if (print_level != 0) {
            Print.Rprintf((BytePtr)new BytePtr("After inittree():\n\u0000".getBytes(), 0), (Object[])new Object[0]);
            Print.Rprintf((BytePtr)new BytePtr(" %9s: \u0000".getBytes(), 0), (Object[])new Object[]{new BytePtr("j\u0000".getBytes(), 0)});
            int j = 0;
            while (k * 2 >= j) {
                Print.Rprintf((BytePtr)new BytePtr("%6d\u0000".getBytes(), 0), (Object[])new Object[]{j});
                ++j;
            }
            Print.Rprintf((BytePtr)new BytePtr("\n\u0000".getBytes(), 0), (Object[])new Object[0]);
            Print.Rprintf((BytePtr)new BytePtr(" %9s: \u0000".getBytes(), 0), (Object[])new Object[]{new BytePtr("window []\u0000".getBytes(), 0)});
            j = 0;
            while (k * 2 >= j) {
                int n2 = j * 8;
                Ptr ptr = window;
                int n3 = 0 + n2;
                double d = ptr.getDouble(n3);
                Print.Rprintf((BytePtr)new BytePtr("%6g\u0000".getBytes(), 0), (Object[])new Object[]{d});
                ++j;
            }
            Print.Rprintf((BytePtr)new BytePtr("\n\u0000".getBytes(), 0), (Object[])new Object[0]);
            Print.Rprintf((BytePtr)new BytePtr(" %9s: \u0000".getBytes(), 0), (Object[])new Object[]{new BytePtr(" nrlist[]\u0000".getBytes(), 0)});
            j = 0;
            while (k * 2 >= j) {
                int n4 = j * 4;
                Ptr ptr = nrlist;
                int n5 = 0 + n4;
                int n6 = ptr.getInt(n5);
                Print.Rprintf((BytePtr)new BytePtr("%6d\u0000".getBytes(), 0), (Object[])new Object[]{n6});
                ++j;
            }
            Print.Rprintf((BytePtr)new BytePtr("\n\u0000".getBytes(), 0), (Object[])new Object[0]);
            Print.Rprintf((BytePtr)new BytePtr(" %9s: \u0000".getBytes(), 0), (Object[])new Object[]{new BytePtr("outlist[]\u0000".getBytes(), 0)});
            j = 0;
            while (k * 2 >= j) {
                int iftmp$32;
                if (j > k2 && k + k2 >= j) {
                    int n7 = (j - k2) * 4;
                    Ptr ptr = outlist;
                    int n8 = 0 + n7;
                    iftmp$32 = ptr.getInt(n8);
                } else {
                    iftmp$32 = -9;
                }
                Print.Rprintf((BytePtr)new BytePtr("%6d\u0000".getBytes(), 0), (Object[])new Object[]{iftmp$32});
                ++j;
            }
            Print.Rprintf((BytePtr)new BytePtr("\n\u0000".getBytes(), 0), (Object[])new Object[0]);
        }
        Srunmed__.runmedint(n, k, k2, data, median, window, outlist, nrlist, end_rule, print_level);
    }

    public static void runmedint(int n, int k, int k2, Ptr data, Ptr median, Ptr window, Ptr outlist, Ptr nrlist, int end_rule, int print_level) {
        if (end_rule != 0) {
            int i = 0;
            while (i <= k2) {
                int n2 = i * 8;
                Ptr ptr = median;
                int n3 = 0 + n2;
                int n4 = k * 8;
                Ptr ptr2 = window;
                int n5 = 0 + n4;
                double d = ptr2.getDouble(n5);
                ptr.setDouble(n3, d);
                ++i;
            }
        } else {
            int i = 0;
            while (i < k2) {
                int n6 = i * 8;
                Ptr ptr = median;
                int n7 = 0 + n6;
                int n8 = i * 8;
                Ptr ptr3 = data;
                int n9 = 0 + n8;
                double d = ptr3.getDouble(n9);
                ptr.setDouble(n7, d);
                ++i;
            }
            int n10 = k2 * 8;
            Ptr ptr = median;
            int n11 = 0 + n10;
            int n12 = k * 8;
            Ptr ptr4 = window;
            int n13 = 0 + n12;
            double d = ptr4.getDouble(n13);
            ptr.setDouble(n11, d);
        }
        int outnext = 0;
        int i = k2 + 1;
        while (n - k2 > i) {
            int n14 = outnext * 4;
            Ptr ptr = outlist;
            int n15 = 0 + n14;
            int out = ptr.getInt(n15);
            int nrnew = i + k2;
            int n16 = out * 8;
            Ptr ptr5 = window;
            int n17 = 0 + n16;
            int n18 = nrnew * 8;
            Ptr ptr6 = data;
            int n19 = 0 + n18;
            double d = ptr6.getDouble(n19);
            ptr5.setDouble(n17, d);
            int outvirt = out - k;
            if (out > k) {
                int n20;
                int n21;
                Ptr ptr7;
                double d2;
                Ptr ptr8 = data;
                int n22 = nrnew * 8;
                int n23 = 0 + n22;
                double d3 = ptr8.getDouble(n23);
                if (d3 >= (d2 = (ptr7 = window).getDouble(n21 = 0 + (n20 = k * 8)))) {
                    Srunmed__.upperoutupperin(outvirt, k, window, outlist, nrlist, print_level);
                } else {
                    Srunmed__.upperoutdownin(outvirt, k, nrnew, outnext, data, window, outlist, nrlist, print_level);
                }
            } else if (out < k) {
                int n24;
                int n25;
                Ptr ptr9;
                double d4;
                Ptr ptr10 = data;
                int n26 = nrnew * 8;
                int n27 = 0 + n26;
                double d5 = ptr10.getDouble(n27);
                if (d5 < (d4 = (ptr9 = window).getDouble(n25 = 0 + (n24 = k * 8)))) {
                    Srunmed__.downoutdownin(outvirt, k, window, outlist, nrlist, print_level);
                } else {
                    Srunmed__.downoutupperin(outvirt, k, nrnew, outnext, data, window, outlist, nrlist, print_level);
                }
            } else {
                int n28;
                int n29;
                Ptr ptr11;
                double d6;
                Ptr ptr12 = window;
                int n30 = k * 8;
                int n31 = 0 + n30;
                double d7 = ptr12.getDouble(n31);
                if (d7 > (d6 = (ptr11 = window).getDouble(n29 = 0 + (n28 = (k + 1) * 8)))) {
                    Srunmed__.wentoutone(k, window, outlist, nrlist, print_level);
                } else {
                    int n32 = k * 8;
                    Ptr ptr13 = window;
                    int n33 = 0 + n32;
                    double d8 = ptr13.getDouble(n33);
                    int n34 = (k + -1) * 8;
                    Ptr ptr14 = window;
                    int n35 = 0 + n34;
                    double d9 = ptr14.getDouble(n35);
                    if (d8 < d9) {
                        Srunmed__.wentouttwo(k, window, outlist, nrlist, print_level);
                    }
                }
            }
            int n36 = i * 8;
            Ptr ptr15 = median;
            int n37 = 0 + n36;
            int n38 = k * 8;
            Ptr ptr16 = window;
            int n39 = 0 + n38;
            double d10 = ptr16.getDouble(n39);
            ptr15.setDouble(n37, d10);
            outnext = (outnext + 1) % k;
            ++i;
        }
        if (end_rule != 0) {
            int i2 = n - k2;
            while (i2 < n) {
                int n40 = i2 * 8;
                Ptr ptr = median;
                int n41 = 0 + n40;
                int n42 = k * 8;
                Ptr ptr17 = window;
                int n43 = 0 + n42;
                double d = ptr17.getDouble(n43);
                ptr.setDouble(n41, d);
                ++i2;
            }
        } else {
            int i3 = n - k2;
            while (i3 < n) {
                int n44 = i3 * 8;
                Ptr ptr = median;
                int n45 = 0 + n44;
                int n46 = i3 * 8;
                Ptr ptr18 = data;
                int n47 = 0 + n46;
                double d = ptr18.getDouble(n47);
                ptr.setDouble(n45, d);
                ++i3;
            }
        }
    }

    public static void wentouttwo(int k, Ptr window, Ptr outlist, Ptr nrlist, int print_level) {
        if (print_level > 1) {
            Print.Rprintf((BytePtr)new BytePtr("\nwentOUT_2(%d)\n  \u0000".getBytes(), 0), (Object[])new Object[]{k});
        }
        int n = k + -1;
        Srunmed__.swap(k, n, window, outlist, nrlist, print_level);
        Srunmed__.downtoleave(-1, k, window, outlist, nrlist, print_level);
    }

    public static void wentoutone(int k, Ptr window, Ptr outlist, Ptr nrlist, int print_level) {
        if (print_level > 1) {
            Print.Rprintf((BytePtr)new BytePtr("\nwentOUT_1(%d)\n  \u0000".getBytes(), 0), (Object[])new Object[]{k});
        }
        int n = k + 1;
        Srunmed__.swap(k, n, window, outlist, nrlist, print_level);
        Srunmed__.uptoleave(1, k, window, outlist, nrlist, print_level);
    }

    public static void downoutupperin(int outvirt, int k, int nrnew, int outnext, Ptr data, Ptr window, Ptr outlist, Ptr nrlist, int print_level) {
        if (print_level > 1) {
            Print.Rprintf((BytePtr)new BytePtr("\n__downoutUPPERin(%d, %d)\n  \u0000".getBytes(), 0), (Object[])new Object[]{outvirt, k});
        }
        Srunmed__.toroot(outvirt, k, nrnew, outnext, data, window, outlist, nrlist, print_level);
        int n = k * 8;
        Ptr ptr = window;
        int n2 = 0 + n;
        double d = ptr.getDouble(n2);
        int n3 = (k + 1) * 8;
        Ptr ptr2 = window;
        int n4 = 0 + n3;
        double d2 = ptr2.getDouble(n4);
        if (d > d2) {
            int n5 = k + 1;
            Srunmed__.swap(k, n5, window, outlist, nrlist, print_level);
            Srunmed__.uptoleave(1, k, window, outlist, nrlist, print_level);
        }
    }

    public static void downoutdownin(int outvirt, int k, Ptr window, Ptr outlist, Ptr nrlist, int print_level) {
        int n;
        int n2;
        Ptr ptr;
        double d;
        int n3;
        int n4;
        Ptr ptr2;
        double d2;
        if (print_level > 1) {
            Print.Rprintf((BytePtr)new BytePtr("\nDownoutDOWNin(%d, %d)\n  \u0000".getBytes(), 0), (Object[])new Object[]{outvirt, k});
        }
        Srunmed__.downtoleave(outvirt, k, window, outlist, nrlist, print_level);
        int father = outvirt / 2;
        while ((d2 = (ptr2 = window).getDouble(n4 = 0 + (n3 = (outvirt + k) * 8))) > (d = (ptr = window).getDouble(n2 = 0 + (n = (father + k) * 8)))) {
            int n5 = father + k;
            Srunmed__.swap(outvirt + k, n5, window, outlist, nrlist, print_level);
            outvirt = father;
            father = outvirt / 2;
        }
        if (print_level > 1) {
            Print.Rprintf((BytePtr)new BytePtr("\n\u0000".getBytes(), 0), (Object[])new Object[0]);
        }
    }

    public static void upperoutdownin(int outvirt, int k, int nrnew, int outnext, Ptr data, Ptr window, Ptr outlist, Ptr nrlist, int print_level) {
        if (print_level > 1) {
            Print.Rprintf((BytePtr)new BytePtr("\n__upperoutDOWNin(%d, %d)\n  \u0000".getBytes(), 0), (Object[])new Object[]{outvirt, k});
        }
        Srunmed__.toroot(outvirt, k, nrnew, outnext, data, window, outlist, nrlist, print_level);
        int n = k * 8;
        Ptr ptr = window;
        int n2 = 0 + n;
        double d = ptr.getDouble(n2);
        int n3 = (k + -1) * 8;
        Ptr ptr2 = window;
        int n4 = 0 + n3;
        double d2 = ptr2.getDouble(n4);
        if (d < d2) {
            int n5 = k + -1;
            Srunmed__.swap(k, n5, window, outlist, nrlist, print_level);
            Srunmed__.downtoleave(-1, k, window, outlist, nrlist, print_level);
        }
    }

    public static void upperoutupperin(int outvirt, int k, Ptr window, Ptr outlist, Ptr nrlist, int print_level) {
        int n;
        int n2;
        Ptr ptr;
        double d;
        int n3;
        int n4;
        Ptr ptr2;
        double d2;
        if (print_level > 1) {
            Print.Rprintf((BytePtr)new BytePtr("\nUpperoutUPPERin(%d, %d)\n  \u0000".getBytes(), 0), (Object[])new Object[]{outvirt, k});
        }
        Srunmed__.uptoleave(outvirt, k, window, outlist, nrlist, print_level);
        int father = outvirt / 2;
        while ((d2 = (ptr2 = window).getDouble(n4 = 0 + (n3 = (outvirt + k) * 8))) < (d = (ptr = window).getDouble(n2 = 0 + (n = (father + k) * 8)))) {
            int n5 = father + k;
            Srunmed__.swap(outvirt + k, n5, window, outlist, nrlist, print_level);
            outvirt = father;
            father = outvirt / 2;
        }
        if (print_level > 1) {
            Print.Rprintf((BytePtr)new BytePtr("\n\u0000".getBytes(), 0), (Object[])new Object[0]);
        }
    }

    public static void uptoleave(int outvirt, int k, Ptr window, Ptr outlist, Ptr nrlist, int print_level) {
        if (print_level > 1) {
            Print.Rprintf((BytePtr)new BytePtr("\n uptoleave(%d, %d)\n   \u0000".getBytes(), 0), (Object[])new Object[]{outvirt, k});
        }
        while (true) {
            int n;
            int n2;
            Ptr ptr;
            double d;
            int childl = outvirt * 2;
            int childr = childl + 1;
            Ptr ptr2 = window;
            int n3 = (childl + k) * 8;
            int n4 = 0 + n3;
            double d2 = ptr2.getDouble(n4);
            if (d2 > (d = (ptr = window).getDouble(n2 = 0 + (n = (childr + k) * 8)))) {
                childl = childr;
            }
            int n5 = (outvirt + k) * 8;
            Ptr ptr3 = window;
            int n6 = 0 + n5;
            double d3 = ptr3.getDouble(n6);
            int n7 = (childl + k) * 8;
            Ptr ptr4 = window;
            int n8 = 0 + n7;
            double d4 = ptr4.getDouble(n8);
            if (d3 <= d4) break;
            int n9 = childl + k;
            Srunmed__.swap(outvirt + k, n9, window, outlist, nrlist, print_level);
            outvirt = childl;
        }
    }

    public static void downtoleave(int outvirt, int k, Ptr window, Ptr outlist, Ptr nrlist, int print_level) {
        if (print_level > 1) {
            Print.Rprintf((BytePtr)new BytePtr("\n downtoleave(%d, %d)\n   \u0000".getBytes(), 0), (Object[])new Object[]{outvirt, k});
        }
        while (true) {
            int n;
            int n2;
            Ptr ptr;
            double d;
            int childl = outvirt * 2;
            int childr = childl + -1;
            Ptr ptr2 = window;
            int n3 = (childl + k) * 8;
            int n4 = 0 + n3;
            double d2 = ptr2.getDouble(n4);
            if (d2 < (d = (ptr = window).getDouble(n2 = 0 + (n = (childr + k) * 8)))) {
                childl = childr;
            }
            int n5 = (outvirt + k) * 8;
            Ptr ptr3 = window;
            int n6 = 0 + n5;
            double d3 = ptr3.getDouble(n6);
            int n7 = (childl + k) * 8;
            Ptr ptr4 = window;
            int n8 = 0 + n7;
            double d4 = ptr4.getDouble(n8);
            if (d3 >= d4) break;
            int n9 = childl + k;
            Srunmed__.swap(outvirt + k, n9, window, outlist, nrlist, print_level);
            outvirt = childl;
        }
    }

    public static void toroot(int outvirt, int k, int nrnew, int outnext, Ptr data, Ptr window, Ptr outlist, Ptr nrlist, int print_level) {
        int father;
        if (print_level > 1) {
            Print.Rprintf((BytePtr)new BytePtr("toroot(%d, %d,%d) \u0000".getBytes(), 0), (Object[])new Object[]{k, nrnew, outnext});
        }
        do {
            father = outvirt / 2;
            int n = (outvirt + k) * 8;
            Ptr ptr = window;
            int n2 = 0 + n;
            int n3 = (father + k) * 8;
            Ptr ptr2 = window;
            int n4 = 0 + n3;
            double d = ptr2.getDouble(n4);
            ptr.setDouble(n2, d);
            int n5 = (father + k) * 4;
            Ptr ptr3 = nrlist;
            int n6 = 0 + n5;
            int n7 = ptr3.getInt(n6) * 4;
            Ptr ptr4 = outlist;
            int n8 = 0 + n7;
            int n9 = outvirt + k;
            ptr4.setInt(n8, n9);
            int n10 = (outvirt + k) * 4;
            Ptr ptr5 = nrlist;
            int n11 = 0 + n10;
            int n12 = (father + k) * 4;
            Ptr ptr6 = nrlist;
            int n13 = 0 + n12;
            int n14 = ptr6.getInt(n13);
            ptr5.setInt(n11, n14);
            outvirt = father;
        } while (father != 0);
        int n = k * 8;
        Ptr ptr = window;
        int n15 = 0 + n;
        int n16 = nrnew * 8;
        Ptr ptr7 = data;
        int n17 = 0 + n16;
        double d = ptr7.getDouble(n17);
        ptr.setDouble(n15, d);
        int n18 = outnext * 4;
        Ptr ptr8 = outlist;
        int n19 = 0 + n18;
        ptr8.setInt(n19, k);
        int n20 = k * 4;
        Ptr ptr9 = nrlist;
        int n21 = 0 + n20;
        ptr9.setInt(n21, outnext);
    }

    public static void inittree(int n, int k, int k2, Ptr data, Ptr window, Ptr outlist, Ptr nrlist, int print_level) {
        double big = 0.0;
        int k2p1 = 0;
        int i = 1;
        while (i <= k) {
            int n2 = i * 8;
            Ptr ptr = window;
            int n3 = 0 + n2;
            int n4 = (i + -1) * 8;
            Ptr ptr2 = data;
            int n5 = 0 + n4;
            double d = ptr2.getDouble(n5);
            ptr.setDouble(n3, d);
            int n6 = i * 4;
            Ptr ptr3 = nrlist;
            int n7 = 0 + n6;
            int n8 = i * 4;
            Ptr ptr4 = outlist;
            int n9 = 0 + n8;
            ptr4.setInt(n9, i);
            int n10 = ptr4.getInt(n9);
            ptr3.setInt(n7, n10);
            ++i;
        }
        Srunmed__.R_heapsort(1, k, window, outlist, nrlist, print_level);
        int n11 = k * 8;
        Ptr ptr = window;
        int n12 = 0 + n11;
        big = Math.abs(ptr.getDouble(n12));
        Ptr ptr5 = window;
        int n13 = 8;
        if (Math.abs(ptr5.getDouble(n13)) > big) {
            Ptr ptr6 = window;
            int n14 = 8;
            big = Math.abs(ptr6.getDouble(n14));
        }
        i = k;
        while (i < n) {
            Ptr ptr7 = data;
            int n15 = i * 8;
            int n16 = 0 + n15;
            if (Math.abs(ptr7.getDouble(n16)) > big) {
                int n17 = i * 8;
                Ptr ptr8 = data;
                int n18 = 0 + n17;
                big = Math.abs(ptr8.getDouble(n18));
            }
            ++i;
        }
        big = big * 2.0 + 1.0;
        i = k;
        while (i > 0) {
            int n19 = (i + k2) * 8;
            Ptr ptr9 = window;
            int n20 = 0 + n19;
            int n21 = i * 8;
            Ptr ptr10 = window;
            int n22 = 0 + n21;
            double d = ptr10.getDouble(n22);
            ptr9.setDouble(n20, d);
            int n23 = (i + k2) * 4;
            Ptr ptr11 = nrlist;
            int n24 = 0 + n23;
            int n25 = i * 4;
            Ptr ptr12 = nrlist;
            int n26 = 0 + n25;
            int n27 = ptr12.getInt(n26) + -1;
            ptr11.setInt(n24, n27);
            --i;
        }
        i = 0;
        while (i < k) {
            int n28 = i * 4;
            Ptr ptr13 = outlist;
            int n29 = 0 + n28;
            int n30 = (i + 1) * 4;
            Ptr ptr14 = outlist;
            int n31 = 0 + n30;
            int n32 = ptr14.getInt(n31) + k2;
            ptr13.setInt(n29, n32);
            ++i;
        }
        k2p1 = k2 + 1;
        i = 0;
        while (i < k2p1) {
            int n33 = i * 8;
            Ptr ptr15 = window;
            int n34 = 0 + n33;
            double d = -big;
            ptr15.setDouble(n34, d);
            int n35 = (k + k2p1 + i) * 8;
            Ptr ptr16 = window;
            int n36 = 0 + n35;
            ptr16.setDouble(n36, big);
            ++i;
        }
    }

    public static void R_heapsort(int low, int up, Ptr window, Ptr outlist, Ptr nrlist, int print_level) {
        int u = 0;
        int l = 0;
        l = up / 2 + 1;
        u = up;
        while (l > low) {
            Srunmed__.siftup(--l, u, window, outlist, nrlist, print_level);
        }
        while (u > low) {
            Srunmed__.swap(l, u, window, outlist, nrlist, print_level);
            Srunmed__.siftup(l, --u, window, outlist, nrlist, print_level);
        }
    }

    public static void siftup(int l, int r, Ptr window, Ptr outlist, Ptr nrlist, int print_level) {
        double x = 0.0;
        int nrold = 0;
        if (print_level > 1) {
            Print.Rprintf((BytePtr)new BytePtr("siftup(%d,%d) \u0000".getBytes(), 0), (Object[])new Object[]{l, r});
        }
        int i = l;
        int j = i * 2;
        int n = i * 8;
        Ptr ptr = window;
        int n2 = 0 + n;
        x = ptr.getDouble(n2);
        int n3 = i * 4;
        Ptr ptr2 = nrlist;
        int n4 = 0 + n3;
        nrold = ptr2.getInt(n4);
        while (j <= r) {
            int n5;
            int n6;
            Ptr ptr3;
            int n7;
            int n8;
            Ptr ptr4;
            double d;
            int n9;
            int n10;
            Ptr ptr5;
            double d2;
            if (j < r && (d2 = (ptr5 = window).getDouble(n10 = 0 + (n9 = j * 8))) < (d = (ptr4 = window).getDouble(n8 = 0 + (n7 = (j + 1) * 8)))) {
                ++j;
            }
            if ((ptr3 = window).getDouble(n6 = 0 + (n5 = j * 8)) <= x) break;
            int n11 = i * 8;
            Ptr ptr6 = window;
            int n12 = 0 + n11;
            int n13 = j * 8;
            Ptr ptr7 = window;
            int n14 = 0 + n13;
            double d3 = ptr7.getDouble(n14);
            ptr6.setDouble(n12, d3);
            int n15 = j * 4;
            Ptr ptr8 = nrlist;
            int n16 = 0 + n15;
            int n17 = ptr8.getInt(n16) * 4;
            Ptr ptr9 = outlist;
            int n18 = 0 + n17;
            ptr9.setInt(n18, i);
            int n19 = i * 4;
            Ptr ptr10 = nrlist;
            int n20 = 0 + n19;
            int n21 = j * 4;
            Ptr ptr11 = nrlist;
            int n22 = 0 + n21;
            int n23 = ptr11.getInt(n22);
            ptr10.setInt(n20, n23);
            i = j;
            j = i * 2;
        }
        int n24 = i * 8;
        Ptr ptr12 = window;
        int n25 = 0 + n24;
        ptr12.setDouble(n25, x);
        int n26 = nrold * 4;
        Ptr ptr13 = outlist;
        int n27 = 0 + n26;
        ptr13.setInt(n27, i);
        int n28 = i * 4;
        Ptr ptr14 = nrlist;
        int n29 = 0 + n28;
        ptr14.setInt(n29, nrold);
    }

    public static void swap(int l, int r, Ptr window, Ptr outlist, Ptr nrlist, int print_level) {
        if (print_level > 2) {
            Print.Rprintf((BytePtr)new BytePtr("SW(%d,%d) \u0000".getBytes(), 0), (Object[])new Object[]{l, r});
        }
        int n = l * 8;
        Ptr ptr = window;
        int n2 = 0 + n;
        double tmp = ptr.getDouble(n2);
        int n3 = l * 8;
        Ptr ptr2 = window;
        int n4 = 0 + n3;
        int n5 = r * 8;
        Ptr ptr3 = window;
        int n6 = 0 + n5;
        double d = ptr3.getDouble(n6);
        ptr2.setDouble(n4, d);
        int n7 = r * 8;
        Ptr ptr4 = window;
        int n8 = 0 + n7;
        ptr4.setDouble(n8, tmp);
        int n9 = l * 4;
        Ptr ptr5 = nrlist;
        int n10 = 0 + n9;
        int nl = ptr5.getInt(n10);
        int n11 = l * 4;
        Ptr ptr6 = nrlist;
        int n12 = 0 + n11;
        int n13 = r * 4;
        Ptr ptr7 = nrlist;
        int n14 = 0 + n13;
        int nr = ptr7.getInt(n14);
        ptr6.setInt(n12, nr);
        int n15 = r * 4;
        Ptr ptr8 = nrlist;
        int n16 = 0 + n15;
        ptr8.setInt(n16, nl);
        int n17 = nl * 4;
        Ptr ptr9 = outlist;
        int n18 = 0 + n17;
        ptr9.setInt(n18, r);
        int n19 = nr * 4;
        Ptr ptr10 = outlist;
        int n20 = 0 + n19;
        ptr10.setInt(n20, l);
    }
}

