/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gnur.api.Arith;
import org.renjin.gnur.api.Error;
import org.renjin.gnur.api.GetText;
import org.renjin.gnur.api.Rmath;

public class distance__ {
    private distance__() {
    }

    public static void R_distance(Ptr x, Ptr nr, Ptr nc, Ptr d, Ptr diag, Ptr method, Ptr p) {
        MethodHandle distfun = null;
        int ij = 0;
        int j = 0;
        int dc = 0;
        distfun = null;
        switch (method.getInt()) {
            case 1: {
                distfun = cfr_ldc_0();
                break;
            }
            case 2: {
                distfun = cfr_ldc_1();
                break;
            }
            case 3: {
                distfun = cfr_ldc_2();
                break;
            }
            case 4: {
                distfun = cfr_ldc_3();
                break;
            }
            case 5: {
                distfun = cfr_ldc_4();
                break;
            }
            case 6: {
                if (Arith.R_finite((double)p.getDouble()) != 0 && !(p.getDouble() <= 0.0)) break;
                BytePtr bytePtr = GetText.dgettext((BytePtr)new BytePtr("stats\u0000".getBytes(), 0), (BytePtr)new BytePtr("distance(): invalid p\u0000".getBytes(), 0));
                int n = 0;
                Error.Rf_error((BytePtr)((BytePtr)bytePtr.pointerPlus(n)), (Object[])new Object[0]);
                break;
            }
            default: {
                BytePtr bytePtr = GetText.dgettext((BytePtr)new BytePtr("stats\u0000".getBytes(), 0), (BytePtr)new BytePtr("distance(): invalid distance\u0000".getBytes(), 0));
                int n = 0;
                Error.Rf_error((BytePtr)((BytePtr)bytePtr.pointerPlus(n)), (Object[])new Object[0]);
            }
        }
        dc = diag.getInt() != 0 ? 0 : 1;
        ij = 0;
        j = 0;
        while (nr.getInt() >= j) {
            int i = j + dc;
            while (nr.getInt() > i) {
                double iftmp$1;
                int n = ij * 8;
                Ptr ptr = d;
                int n2 = 0 + n;
                if (method.getInt() != 6) {
                    int n3 = nc.getInt();
                    int n4 = nr.getInt();
                    iftmp$1 = distfun.invoke(x, n4, n3, i, j);
                } else {
                    double d2 = p.getDouble();
                    int n5 = nc.getInt();
                    int n6 = nr.getInt();
                    iftmp$1 = distance__.R_minkowski(x, n6, n5, i, j, d2);
                }
                ptr.setDouble(n2, iftmp$1);
                ++ij;
                ++i;
            }
            ++j;
        }
    }

    public static double R_minkowski(Ptr x, int nr, int nc, int i1, int i2, double p) {
        double d;
        int count = 0;
        double dist = 0.0;
        count = 0;
        dist = 0.0;
        int j = 0;
        while (j < nc) {
            int n;
            int n2;
            Ptr ptr;
            double d2;
            int n3;
            int n4;
            Ptr ptr2;
            double d3;
            double dev;
            int n5;
            int n6;
            Ptr ptr3;
            Ptr ptr4 = x;
            int n7 = i1 * 8;
            int n8 = 0 + n7;
            if (Builtins.__isnan((double)ptr4.getDouble(n8)) == 0 && Builtins.__isnan((double)(ptr3 = x).getDouble(n6 = 0 + (n5 = i2 * 8))) == 0 && Builtins.__isnan((double)(dev = (d3 = (ptr2 = x).getDouble(n4 = 0 + (n3 = i1 * 8))) - (d2 = (ptr = x).getDouble(n2 = 0 + (n = i2 * 8))))) == 0) {
                dist = Rmath.R_pow((double)Math.abs(dev), (double)p) + dist;
                ++count;
            }
            i1 += nr;
            i2 += nr;
            ++j;
        }
        if (count == 0) {
            d = Arith.R_NaReal;
        } else {
            if (count != nc) {
                double d4 = count;
                double d5 = nc;
                double d6 = d4 / d5;
                dist /= d6;
            }
            double d7 = 1.0 / p;
            d = Rmath.R_pow((double)dist, (double)d7);
        }
        return d;
    }

    public static double R_dist_binary(Ptr x, int nr, int nc, int i1, int i2) {
        double d;
        int dist = 0;
        int count = 0;
        int total = 0;
        total = 0;
        count = 0;
        dist = 0;
        int j = 0;
        while (j < nc) {
            int n;
            int n2;
            Ptr ptr;
            Ptr ptr2 = x;
            int n3 = i1 * 8;
            int n4 = 0 + n3;
            if (Builtins.__isnan((double)ptr2.getDouble(n4)) == 0 && Builtins.__isnan((double)(ptr = x).getDouble(n2 = 0 + (n = i2 * 8))) == 0) {
                int n5;
                int n6;
                Ptr ptr3;
                Ptr ptr4 = x;
                int n7 = i1 * 8;
                int n8 = 0 + n7;
                if (Arith.R_finite((double)ptr4.getDouble(n8)) == 0 || Arith.R_finite((double)(ptr3 = x).getDouble(n6 = 0 + (n5 = i2 * 8))) == 0) {
                    BytePtr bytePtr = GetText.dgettext((BytePtr)new BytePtr("stats\u0000".getBytes(), 0), (BytePtr)new BytePtr("treating non-finite values as NA\u0000".getBytes(), 0));
                    int n9 = 0;
                    Error.Rf_warning((BytePtr)((BytePtr)bytePtr.pointerPlus(n9)), (Object[])new Object[0]);
                } else {
                    int n10;
                    int n11;
                    Ptr ptr5;
                    int n12 = i1 * 8;
                    Ptr ptr6 = x;
                    int n13 = 0 + n12;
                    if (ptr6.getDouble(n13) != 0.0 || (ptr5 = x).getDouble(n11 = 0 + (n10 = i2 * 8)) != 0.0) {
                        int n14;
                        int n15;
                        Ptr ptr7;
                        ++count;
                        Ptr ptr8 = x;
                        int n16 = i1 * 8;
                        int n17 = 0 + n16;
                        if (ptr8.getDouble(n17) == 0.0 || (ptr7 = x).getDouble(n15 = 0 + (n14 = i2 * 8)) == 0.0) {
                            ++dist;
                        }
                    }
                    ++total;
                }
            }
            i1 += nr;
            i2 += nr;
            ++j;
        }
        if (total == 0) {
            d = Arith.R_NaReal;
        } else if (count == 0) {
            d = 0.0;
        } else {
            double d2 = dist;
            double d3 = count;
            d = d2 / d3;
        }
        return d;
    }

    public static double R_canberra(Ptr x, int nr, int nc, int i1, int i2) {
        double d;
        int count = 0;
        double dist = 0.0;
        count = 0;
        dist = 0.0;
        int j = 0;
        while (j < nc) {
            int n;
            int n2;
            Ptr ptr;
            Ptr ptr2 = x;
            int n3 = i1 * 8;
            int n4 = 0 + n3;
            if (Builtins.__isnan((double)ptr2.getDouble(n4)) == 0 && Builtins.__isnan((double)(ptr = x).getDouble(n2 = 0 + (n = i2 * 8))) == 0) {
                double dev;
                int n5 = i1 * 8;
                Ptr ptr3 = x;
                int n6 = 0 + n5;
                double d2 = ptr3.getDouble(n6);
                int n7 = i2 * 8;
                Ptr ptr4 = x;
                int n8 = 0 + n7;
                double d3 = ptr4.getDouble(n8);
                double sum = Math.abs(d2 + d3);
                int n9 = i1 * 8;
                Ptr ptr5 = x;
                int n10 = 0 + n9;
                double d4 = ptr5.getDouble(n10);
                int n11 = i2 * 8;
                Ptr ptr6 = x;
                int n12 = 0 + n11;
                double d5 = ptr6.getDouble(n12);
                double diff = Math.abs(d4 - d5);
                if ((sum > Double.MIN_NORMAL || diff > Double.MIN_NORMAL) && (Builtins.__isnan((double)(dev = diff / sum)) == 0 || Arith.R_finite((double)diff) == 0 && diff == sum && (dev = 1.0) != 0.0)) {
                    dist += dev;
                    ++count;
                }
            }
            i1 += nr;
            i2 += nr;
            ++j;
        }
        if (count == 0) {
            d = Arith.R_NaReal;
        } else {
            if (count != nc) {
                double d6 = count;
                double d7 = nc;
                double d8 = d6 / d7;
                dist /= d8;
            }
            d = dist;
        }
        return d;
    }

    public static double R_manhattan(Ptr x, int nr, int nc, int i1, int i2) {
        double d;
        int count = 0;
        double dist = 0.0;
        count = 0;
        dist = 0.0;
        int j = 0;
        while (j < nc) {
            int n;
            int n2;
            Ptr ptr;
            double d2;
            int n3;
            int n4;
            Ptr ptr2;
            double d3;
            double dev;
            int n5;
            int n6;
            Ptr ptr3;
            Ptr ptr4 = x;
            int n7 = i1 * 8;
            int n8 = 0 + n7;
            if (Builtins.__isnan((double)ptr4.getDouble(n8)) == 0 && Builtins.__isnan((double)(ptr3 = x).getDouble(n6 = 0 + (n5 = i2 * 8))) == 0 && Builtins.__isnan((double)(dev = Math.abs((d3 = (ptr2 = x).getDouble(n4 = 0 + (n3 = i1 * 8))) - (d2 = (ptr = x).getDouble(n2 = 0 + (n = i2 * 8)))))) == 0) {
                dist += dev;
                ++count;
            }
            i1 += nr;
            i2 += nr;
            ++j;
        }
        if (count == 0) {
            d = Arith.R_NaReal;
        } else {
            if (count != nc) {
                double d4 = count;
                double d5 = nc;
                double d6 = d4 / d5;
                dist /= d6;
            }
            d = dist;
        }
        return d;
    }

    public static double R_maximum(Ptr x, int nr, int nc, int i1, int i2) {
        int count = 0;
        double dist = 0.0;
        count = 0;
        dist = -1.7976931348623157E308;
        int j = 0;
        while (j < nc) {
            int n;
            int n2;
            Ptr ptr;
            double d;
            int n3;
            int n4;
            Ptr ptr2;
            double d2;
            double dev;
            int n5;
            int n6;
            Ptr ptr3;
            Ptr ptr4 = x;
            int n7 = i1 * 8;
            int n8 = 0 + n7;
            if (Builtins.__isnan((double)ptr4.getDouble(n8)) == 0 && Builtins.__isnan((double)(ptr3 = x).getDouble(n6 = 0 + (n5 = i2 * 8))) == 0 && Builtins.__isnan((double)(dev = Math.abs((d2 = (ptr2 = x).getDouble(n4 = 0 + (n3 = i1 * 8))) - (d = (ptr = x).getDouble(n2 = 0 + (n = i2 * 8)))))) == 0) {
                if (dev > dist) {
                    dist = dev;
                }
                ++count;
            }
            i1 += nr;
            i2 += nr;
            ++j;
        }
        double d = count == 0 ? Arith.R_NaReal : dist;
        return d;
    }

    public static double R_euclidean(Ptr x, int nr, int nc, int i1, int i2) {
        double d;
        int count = 0;
        double dist = 0.0;
        count = 0;
        dist = 0.0;
        int j = 0;
        while (j < nc) {
            int n;
            int n2;
            Ptr ptr;
            double d2;
            int n3;
            int n4;
            Ptr ptr2;
            double d3;
            double dev;
            int n5;
            int n6;
            Ptr ptr3;
            Ptr ptr4 = x;
            int n7 = i1 * 8;
            int n8 = 0 + n7;
            if (Builtins.__isnan((double)ptr4.getDouble(n8)) == 0 && Builtins.__isnan((double)(ptr3 = x).getDouble(n6 = 0 + (n5 = i2 * 8))) == 0 && Builtins.__isnan((double)(dev = (d3 = (ptr2 = x).getDouble(n4 = 0 + (n3 = i1 * 8))) - (d2 = (ptr = x).getDouble(n2 = 0 + (n = i2 * 8))))) == 0) {
                double d4 = dev;
                dist = d4 * d4 + dist;
                ++count;
            }
            i1 += nr;
            i2 += nr;
            ++j;
        }
        if (count == 0) {
            d = Arith.R_NaReal;
        } else {
            if (count != nc) {
                double d5 = count;
                double d6 = nc;
                double d7 = d5 / d6;
                dist /= d7;
            }
            d = Mathlib.sqrt((double)dist);
        }
        return d;
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_0() {
        try {
            return MethodHandles.lookup().findStatic(distance__.class, "R_euclidean", MethodType.fromMethodDescriptorString("(Lorg/renjin/gcc/runtime/Ptr;IIII)D", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_1() {
        try {
            return MethodHandles.lookup().findStatic(distance__.class, "R_maximum", MethodType.fromMethodDescriptorString("(Lorg/renjin/gcc/runtime/Ptr;IIII)D", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_2() {
        try {
            return MethodHandles.lookup().findStatic(distance__.class, "R_manhattan", MethodType.fromMethodDescriptorString("(Lorg/renjin/gcc/runtime/Ptr;IIII)D", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_3() {
        try {
            return MethodHandles.lookup().findStatic(distance__.class, "R_canberra", MethodType.fromMethodDescriptorString("(Lorg/renjin/gcc/runtime/Ptr;IIII)D", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_4() {
        try {
            return MethodHandles.lookup().findStatic(distance__.class, "R_dist_binary", MethodType.fromMethodDescriptorString("(Lorg/renjin/gcc/runtime/Ptr;IIII)D", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }
}

