/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats;

import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gnur.api.Arith;
import org.renjin.gnur.api.Error;
import org.renjin.gnur.api.Rinternals;
import org.renjin.gnur.api.Rmath;
import org.renjin.gnur.api.Utils;
import org.renjin.sexp.SEXP;

public class lowess__ {
    private lowess__() {
    }

    public static SEXP lowess(SEXP x, SEXP y, SEXP sf, SEXP siter, SEXP sdelta) {
        if (Rinternals.TYPEOF((SEXP)x) != 14 || Rinternals.TYPEOF((SEXP)y) != 14) {
            Error.Rf_error((BytePtr)new BytePtr("invalid input\u0000".getBytes(), 0), (Object[])new Object[0]);
        }
        int nx = Rinternals.LENGTH((SEXP)x);
        int R_NaInt$0 = Arith.R_NaInt;
        if (nx == R_NaInt$0 || nx == 0) {
            Error.Rf_error((BytePtr)new BytePtr("invalid input\u0000".getBytes(), 0), (Object[])new Object[0]);
        }
        double f = Rinternals.Rf_asReal((SEXP)sf);
        if (Arith.R_finite((double)f) == 0 || f <= 0.0) {
            Error.Rf_error((BytePtr)new BytePtr("'f' must be finite and > 0\u0000".getBytes(), 0), (Object[])new Object[0]);
        }
        int iter = Rinternals.Rf_asInteger((SEXP)siter);
        int R_NaInt$1 = Arith.R_NaInt;
        if (iter == R_NaInt$1 || iter < 0) {
            Error.Rf_error((BytePtr)new BytePtr("'iter' must be finite and >= 0\u0000".getBytes(), 0), (Object[])new Object[0]);
        }
        double delta = Rinternals.Rf_asReal((SEXP)sdelta);
        if (Arith.R_finite((double)delta) == 0 || delta < 0.0) {
            Error.Rf_error((BytePtr)new BytePtr("'delta' must be finite and > 0\u0000".getBytes(), 0), (Object[])new Object[0]);
        }
        SEXP ans = Rinternals.Rf_allocVector((int)14, (int)nx);
        Rinternals.Rf_protect((SEXP)ans);
        DoublePtr rw = DoublePtr.malloc((int)(nx * 8));
        int rw$offset = 0;
        DoublePtr res = DoublePtr.malloc((int)(nx * 8));
        int res$offset = 0;
        DoublePtr doublePtr = Rinternals.REAL((SEXP)ans);
        int n = 0;
        DoublePtr doublePtr2 = Rinternals.REAL((SEXP)y);
        int n2 = 0;
        DoublePtr doublePtr3 = Rinternals.REAL((SEXP)x);
        int n3 = 0;
        lowess__.clowess(doublePtr3.pointerPlus(n3), doublePtr2.pointerPlus(n2), nx, f, iter, delta, doublePtr.pointerPlus(n), rw.pointerPlus(rw$offset), res.pointerPlus(res$offset));
        Rinternals.Rf_unprotect((int)1);
        return ans;
    }

    public static void clowess(Ptr x, Ptr y, int n, double f, int nsteps, double delta, Ptr ys, Ptr rw, Ptr res) {
        int[] ok = new int[1];
        double sc = 0.0;
        double denom = 0.0;
        double cut = 0.0;
        double cmad = 0.0;
        double c9 = 0.0;
        double c1 = 0.0;
        ok[0] = 0;
        int ns = 0;
        int nright = 0;
        int nleft = 0;
        int last = 0;
        int iter = 0;
        int i = 0;
        if (n <= 1) {
            double d = y.getDouble();
            ys.setDouble(d);
        } else {
            x = x.pointerPlus(-8);
            y = y.pointerPlus(-8);
            ys = ys.pointerPlus(-8);
            int n2 = (int)((double)n * f + 1.0E-7);
            int n3 = Rmath.Rf_imin2((int)n, (int)n2);
            ns = Rmath.Rf_imax2((int)2, (int)n3);
            iter = 1;
            while (nsteps + 1 >= iter) {
                nleft = 1;
                nright = ns;
                last = 0;
                i = 1;
                while (true) {
                    int n4;
                    int n5;
                    Ptr ptr;
                    double d;
                    int n6;
                    int n7;
                    Ptr ptr2;
                    double d2;
                    double d22;
                    int n8;
                    int n9;
                    Ptr ptr3;
                    double d3;
                    int n10;
                    int n11;
                    Ptr ptr4;
                    double d4;
                    double d1;
                    if (nright < n && (d1 = (d4 = (ptr4 = x).getDouble(n11 = 0 + (n10 = i * 8))) - (d3 = (ptr3 = x).getDouble(n9 = 0 + (n8 = nleft * 8)))) > (d22 = (d2 = (ptr2 = x).getDouble(n7 = 0 + (n6 = (nright + 1) * 8))) - (d = (ptr = x).getDouble(n5 = 0 + (n4 = i * 8))))) {
                        ++nleft;
                        ++nright;
                        continue;
                    }
                    int n12 = iter <= 1 ? 0 : 1;
                    int n13 = i * 8;
                    Ptr ptr5 = ys;
                    int n14 = 0 + n13;
                    int n15 = i * 8;
                    Ptr ptr6 = x;
                    int n16 = 0 + n15;
                    Ptr ptr7 = y;
                    int n17 = 8;
                    Ptr ptr8 = x;
                    int n18 = 8;
                    lowess__.lowest(ptr8.pointerPlus(n18), ptr7.pointerPlus(n17), n, ptr6.pointerPlus(n16), ptr5.pointerPlus(n14), nleft, nright, res, n12, rw, (Ptr)new IntPtr(ok, 0));
                    if (ok[0] == 0) {
                        int n19 = i * 8;
                        Ptr ptr9 = ys;
                        int n20 = 0 + n19;
                        int n21 = i * 8;
                        Ptr ptr10 = y;
                        int n22 = 0 + n21;
                        double d5 = ptr10.getDouble(n22);
                        ptr9.setDouble(n20, d5);
                    }
                    if (i + -1 > last) {
                        int n23 = i * 8;
                        Ptr ptr11 = x;
                        int n24 = 0 + n23;
                        double d6 = ptr11.getDouble(n24);
                        int n25 = last * 8;
                        Ptr ptr12 = x;
                        int n26 = 0 + n25;
                        double d7 = ptr12.getDouble(n26);
                        denom = d6 - d7;
                        int j = last + 1;
                        while (j < i) {
                            int n27 = j * 8;
                            Ptr ptr13 = x;
                            int n28 = 0 + n27;
                            double d8 = ptr13.getDouble(n28);
                            int n29 = last * 8;
                            Ptr ptr14 = x;
                            int n30 = 0 + n29;
                            double d9 = ptr14.getDouble(n30);
                            double alpha = (d8 - d9) / denom;
                            int n31 = j * 8;
                            Ptr ptr15 = ys;
                            int n32 = 0 + n31;
                            int n33 = i * 8;
                            Ptr ptr16 = ys;
                            int n34 = 0 + n33;
                            double d10 = ptr16.getDouble(n34) * alpha;
                            double d11 = 1.0 - alpha;
                            int n35 = last * 8;
                            Ptr ptr17 = ys;
                            int n36 = 0 + n35;
                            double d12 = ptr17.getDouble(n36);
                            double d13 = d11 * d12;
                            double d14 = d10 + d13;
                            ptr15.setDouble(n32, d14);
                            ++j;
                        }
                    }
                    last = i;
                    int n37 = last * 8;
                    Ptr ptr18 = x;
                    int n38 = 0 + n37;
                    cut = ptr18.getDouble(n38) + delta;
                    i = last + 1;
                    while (i <= n) {
                        Ptr ptr19 = x;
                        int n39 = i * 8;
                        int n40 = 0 + n39;
                        if (ptr19.getDouble(n40) > cut) break;
                        int n41 = i * 8;
                        Ptr ptr20 = x;
                        int n42 = 0 + n41;
                        double d15 = ptr20.getDouble(n42);
                        int n43 = last * 8;
                        Ptr ptr21 = x;
                        int n44 = 0 + n43;
                        double d16 = ptr21.getDouble(n44);
                        if (d15 == d16) {
                            int n45 = i * 8;
                            Ptr ptr22 = ys;
                            int n46 = 0 + n45;
                            int n47 = last * 8;
                            Ptr ptr23 = ys;
                            int n48 = 0 + n47;
                            double d17 = ptr23.getDouble(n48);
                            ptr22.setDouble(n46, d17);
                            last = i;
                        }
                        ++i;
                    }
                    int n49 = i + -1;
                    i = Rmath.Rf_imax2((int)(last + 1), (int)n49);
                    if (last >= n) break;
                }
                i = 0;
                while (i < n) {
                    int n50 = i * 8;
                    Ptr ptr = res;
                    int n51 = 0 + n50;
                    int n52 = (i + 1) * 8;
                    Ptr ptr24 = y;
                    int n53 = 0 + n52;
                    double d = ptr24.getDouble(n53);
                    int n54 = (i + 1) * 8;
                    Ptr ptr25 = ys;
                    int n55 = 0 + n54;
                    double d18 = ptr25.getDouble(n55);
                    double d19 = d - d18;
                    ptr.setDouble(n51, d19);
                    ++i;
                }
                sc = 0.0;
                i = 0;
                while (i < n) {
                    int n56 = i * 8;
                    Ptr ptr = res;
                    int n57 = 0 + n56;
                    sc = Math.abs(ptr.getDouble(n57)) + sc;
                    ++i;
                }
                double d = n;
                sc /= d;
                if (iter > nsteps) break;
                i = 0;
                while (i < n) {
                    int n58 = i * 8;
                    Ptr ptr = rw;
                    int n59 = 0 + n58;
                    int n60 = i * 8;
                    Ptr ptr26 = res;
                    int n61 = 0 + n60;
                    double d20 = Math.abs(ptr26.getDouble(n61));
                    ptr.setDouble(n59, d20);
                    ++i;
                }
                int m1 = n / 2;
                Utils.Rf_rPsort((DoublePtr)((DoublePtr)rw), (int)n, (int)m1);
                if ((n & 1) == 0) {
                    int m2 = n - m1 + -1;
                    Utils.Rf_rPsort((DoublePtr)((DoublePtr)rw), (int)n, (int)m2);
                    int n62 = m1 * 8;
                    Ptr ptr = rw;
                    int n63 = 0 + n62;
                    double d21 = ptr.getDouble(n63);
                    int n64 = m2 * 8;
                    Ptr ptr27 = rw;
                    int n65 = 0 + n64;
                    double d22 = ptr27.getDouble(n65);
                    cmad = (d21 + d22) * 3.0;
                } else {
                    int n66 = m1 * 8;
                    Ptr ptr = rw;
                    int n67 = 0 + n66;
                    cmad = ptr.getDouble(n67) * 6.0;
                }
                if (sc * 1.0E-7 > cmad) break;
                c9 = cmad * 0.999;
                c1 = cmad * 0.001;
                i = 0;
                while (i < n) {
                    Ptr ptr = res;
                    int n68 = i * 8;
                    int n69 = 0 + n68;
                    double r = Math.abs(ptr.getDouble(n69));
                    if (r <= c1) {
                        int n70 = i * 8;
                        Ptr ptr28 = rw;
                        int n71 = 0 + n70;
                        ptr28.setDouble(n71, 1.0);
                    } else if (r <= c9) {
                        int n72 = i * 8;
                        Ptr ptr29 = rw;
                        int n73 = 0 + n72;
                        double d23 = lowess__.fsquare(r / cmad);
                        double d24 = lowess__.fsquare(1.0 - d23);
                        ptr29.setDouble(n73, d24);
                    } else {
                        int n74 = i * 8;
                        Ptr ptr30 = rw;
                        int n75 = 0 + n74;
                        ptr30.setDouble(n75, 0.0);
                    }
                    ++i;
                }
                ++iter;
            }
        }
    }

    public static double fsquare(double x) {
        double d = x;
        return d * d;
    }

    public static void lowest(Ptr x, Ptr y, int n, Ptr xs, Ptr ys, int nleft, int nright, Ptr w, int userw, Ptr rw, Ptr ok) {
        double range = 0.0;
        double h9 = 0.0;
        double h1 = 0.0;
        double h = 0.0;
        double b = 0.0;
        double a = 0.0;
        int nrt = 0;
        x = x.pointerPlus(-8);
        y = y.pointerPlus(-8);
        w = w.pointerPlus(-8);
        rw = rw.pointerPlus(-8);
        int n2 = n * 8;
        Ptr ptr = x;
        int n3 = 0 + n2;
        double d = ptr.getDouble(n3);
        Ptr ptr2 = x;
        int n4 = 8;
        double d2 = ptr2.getDouble(n4);
        range = d - d2;
        int n5 = nright * 8;
        Ptr ptr3 = x;
        int n6 = 0 + n5;
        double d3 = ptr3.getDouble(n6);
        double d4 = xs.getDouble();
        double d5 = d3 - d4;
        double d6 = xs.getDouble();
        int n7 = nleft * 8;
        Ptr ptr4 = x;
        int n8 = 0 + n7;
        double d7 = ptr4.getDouble(n8);
        h = Rmath.Rf_fmax2((double)(d6 - d7), (double)d5);
        h9 = h * 0.999;
        h1 = h * 0.001;
        a = 0.0;
        int j = nleft;
        while (j <= n) {
            int n9 = j * 8;
            Ptr ptr5 = w;
            int n10 = 0 + n9;
            ptr5.setDouble(n10, 0.0);
            int n11 = j * 8;
            Ptr ptr6 = x;
            int n12 = 0 + n11;
            double d8 = ptr6.getDouble(n12);
            double d9 = xs.getDouble();
            double r = Math.abs(d8 - d9);
            if (r <= h9) {
                if (r <= h1) {
                    int n13 = j * 8;
                    Ptr ptr7 = w;
                    int n14 = 0 + n13;
                    ptr7.setDouble(n14, 1.0);
                } else {
                    int n15 = j * 8;
                    Ptr ptr8 = w;
                    int n16 = 0 + n15;
                    double d10 = lowess__.fcube(r / h);
                    double d11 = lowess__.fcube(1.0 - d10);
                    ptr8.setDouble(n16, d11);
                }
                if (userw != 0) {
                    int n17 = j * 8;
                    Ptr ptr9 = w;
                    int n18 = 0 + n17;
                    int n19 = j * 8;
                    Ptr ptr10 = w;
                    int n20 = 0 + n19;
                    double d12 = ptr10.getDouble(n20);
                    int n21 = j * 8;
                    Ptr ptr11 = rw;
                    int n22 = 0 + n21;
                    double d13 = ptr11.getDouble(n22);
                    double d14 = d12 * d13;
                    ptr9.setDouble(n18, d14);
                }
                int n23 = j * 8;
                Ptr ptr12 = w;
                int n24 = 0 + n23;
                a = ptr12.getDouble(n24) + a;
            } else {
                double d15;
                Ptr ptr13 = x;
                int n25 = j * 8;
                int n26 = 0 + n25;
                double d16 = ptr13.getDouble(n26);
                if (d16 > (d15 = xs.getDouble())) break;
            }
            ++j;
        }
        nrt = j + -1;
        if (a <= 0.0) {
            ok.setInt(0);
        } else {
            ok.setInt(1);
            j = nleft;
            while (j <= nrt) {
                int n27 = j * 8;
                Ptr ptr14 = w;
                int n28 = 0 + n27;
                int n29 = j * 8;
                Ptr ptr15 = w;
                int n30 = 0 + n29;
                double d17 = ptr15.getDouble(n30) / a;
                ptr14.setDouble(n28, d17);
                ++j;
            }
            if (h > 0.0) {
                double d18;
                a = 0.0;
                j = nleft;
                while (j <= nrt) {
                    int n31 = j * 8;
                    Ptr ptr16 = w;
                    int n32 = 0 + n31;
                    double d19 = ptr16.getDouble(n32);
                    int n33 = j * 8;
                    Ptr ptr17 = x;
                    int n34 = 0 + n33;
                    double d20 = ptr17.getDouble(n34);
                    a = d19 * d20 + a;
                    ++j;
                }
                b = xs.getDouble() - a;
                double c = 0.0;
                j = nleft;
                while (j <= nrt) {
                    int n35 = j * 8;
                    Ptr ptr18 = w;
                    int n36 = 0 + n35;
                    double d21 = ptr18.getDouble(n36);
                    int n37 = j * 8;
                    Ptr ptr19 = x;
                    int n38 = 0 + n37;
                    double d22 = lowess__.fsquare(ptr19.getDouble(n38) - a);
                    c = d21 * d22 + c;
                    ++j;
                }
                double d23 = Mathlib.sqrt((double)c);
                if (d23 > (d18 = range * 0.001)) {
                    b /= c;
                    j = nleft;
                    while (j <= nrt) {
                        int n39 = j * 8;
                        Ptr ptr20 = w;
                        int n40 = 0 + n39;
                        int n41 = j * 8;
                        Ptr ptr21 = w;
                        int n42 = 0 + n41;
                        double d24 = ptr21.getDouble(n42);
                        int n43 = j * 8;
                        Ptr ptr22 = x;
                        int n44 = 0 + n43;
                        double d25 = (ptr22.getDouble(n44) - a) * b + 1.0;
                        double d26 = d24 * d25;
                        ptr20.setDouble(n40, d26);
                        ++j;
                    }
                }
            }
            ys.setDouble(0.0);
            j = nleft;
            while (j <= nrt) {
                double d27 = ys.getDouble();
                int n45 = j * 8;
                Ptr ptr23 = w;
                int n46 = 0 + n45;
                double d28 = ptr23.getDouble(n46);
                int n47 = j * 8;
                Ptr ptr24 = y;
                int n48 = 0 + n47;
                double d29 = ptr24.getDouble(n48);
                double d30 = d28 * d29;
                double d31 = d27 + d30;
                ys.setDouble(d31);
                ++j;
            }
        }
    }

    public static double fcube(double x) {
        double d = x;
        return d * d * x;
    }
}

