/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.nls;

import java.io.IOException;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.primitives.matrix.DoubleMatrixBuilder;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Vector;
import org.renjin.stats.nls.NlsControl;
import org.renjin.stats.nls.NlsModel;

public class NonlinearLeastSquares {
    private static SEXP convergenceResult(NlsControl nlsControl, String string, int n, StopReason stopReason, double d) {
        if (!nlsControl.isWarnOnly() && stopReason != StopReason.CONVERGED) {
            throw new EvalException(string, new Object[0]);
        }
        nlsControl = ListVector.newNamedBuilder();
        boolean bl = stopReason == StopReason.CONVERGED;
        nlsControl.add("isConv", bl);
        nlsControl.add("finIter", n);
        nlsControl.add("finTol", d);
        nlsControl.add("stopCode", stopReason.ordinal());
        nlsControl.add("stopMessage", string);
        return nlsControl.build();
    }

    @Internal
    public static SEXP iterate(@Current Context objectArray, ListVector object, ListVector listVector, boolean bl) throws IOException {
        int n;
        NlsModel nlsModel = new NlsModel((Context)objectArray, (ListVector)object);
        object = new NlsControl(listVector);
        AtomicVector atomicVector = nlsModel.getParameterValues();
        int n2 = atomicVector.length();
        double d = nlsModel.calculateDeviation();
        if (bl) {
            nlsModel.trace();
        }
        double d2 = 1.0;
        boolean bl2 = false;
        double[] dArray = new double[n2];
        int n3 = 1;
        double d3 = Double.POSITIVE_INFINITY;
        for (n = 0; n < ((NlsControl)object).getMaxIterations(); ++n) {
            d3 = nlsModel.getConvergence();
            if (d3 < ((NlsControl)object).getTolerance()) {
                bl2 = true;
                break;
            }
            DoubleVector doubleVector = nlsModel.calculateIncrements();
            int n4 = 1;
            while (d2 >= ((NlsControl)object).getMinFactor()) {
                if (((NlsControl)object).isPrintEval()) {
                    Object[] objectArray2 = new Object[]{n + 1, d2, n4, n3};
                    objectArray.getSession().getStdOut().printf("  It. %3d, fac= %11.6f, eval (no.,total): (%2d,%3d):\n", objectArray2);
                    ++n4;
                    ++n3;
                }
                for (int i = 0; i < n2; ++i) {
                    dArray[i] = atomicVector.getElementAsDouble(i) + d2 * doubleVector.getElementAsDouble(i);
                }
                if (nlsModel.updateParameters(dArray)) {
                    return NonlinearLeastSquares.convergenceResult((NlsControl)object, "singular gradient", n, StopReason.SINGULAR_GRADIENT, d3);
                }
                double d4 = nlsModel.calculateDeviation();
                if (((NlsControl)object).isPrintEval()) {
                    objectArray.getSession().getStdOut().printf(" new dev = %f\n", d4);
                }
                if (d4 <= d) {
                    d = d4;
                    d2 = Math.min(2.0 * d2, 1.0);
                    atomicVector = new DoubleArrayVector(dArray);
                    break;
                }
                d2 /= 2.0;
            }
            if (d2 < ((NlsControl)object).getMinFactor()) {
                objectArray = new Object[]{d2, ((NlsControl)object).getMinFactor()};
                return NonlinearLeastSquares.convergenceResult((NlsControl)object, String.format("step factor %f reduced below 'minFactor' of %f", objectArray), n, StopReason.MIN_FACTOR_REACHED, d3);
            }
            if (!bl) continue;
            nlsModel.trace();
        }
        if (!bl2) {
            return NonlinearLeastSquares.convergenceResult((NlsControl)object, String.format("number of iterations exceeded maximum of %d", ((NlsControl)object).getMaxIterations()), n, StopReason.MAX_ITERATIONS_EXCEEDED, d3);
        }
        return NonlinearLeastSquares.convergenceResult((NlsControl)object, "converged", n, StopReason.CONVERGED, d3);
    }

    public static SEXP numericDerivative(@Current Context context, SEXP sEXP, StringVector stringVector, Environment environment, DoubleVector doubleVector) {
        String string;
        int n;
        if (doubleVector.length() != stringVector.length()) {
            throw new EvalException("'dir' is not a numeric vector of the correct length", new Object[0]);
        }
        SEXP sEXP2 = context.evaluate(sEXP, environment);
        if (!(sEXP2 instanceof Vector)) {
            throw new EvalException("Expected numeric response from model", new Object[0]);
        }
        sEXP2 = (Vector)sEXP2;
        for (int i = 0; i != sEXP2.length(); ++i) {
            if (DoubleVector.isFinite((double)sEXP2.getElementAsDouble(i))) continue;
            throw new EvalException("Missing value or an infinity produced when evaluating the model", new Object[0]);
        }
        double[][] dArrayArray = new double[stringVector.length()][];
        int n2 = 0;
        for (n = 0; n < stringVector.length(); ++n) {
            string = stringVector.getElementAsString(n);
            SEXP sEXP3 = environment.findVariable(context, Symbol.get((String)string));
            if (!(sEXP3 instanceof AtomicVector)) {
                throw new EvalException("variable '%s' is not numeric", new Object[]{string});
            }
            dArrayArray[n] = ((AtomicVector)sEXP3).toDoubleArray();
            n2 += dArrayArray[n].length;
        }
        double d = Math.sqrt(2.220446E-16);
        string = new DoubleMatrixBuilder(sEXP2.length(), n2);
        n = 0;
        for (int i = 0; i < stringVector.length(); ++i) {
            double d2 = doubleVector.getElementAsDouble(i);
            for (int j = 0; j < dArrayArray[i].length; ++j) {
                double d3 = dArrayArray[i][j];
                double d4 = Math.abs(d3);
                double d5 = d4 == 0.0 ? d : d4 * d;
                d4 = d5;
                double[] dArray = dArrayArray[i];
                dArray[j] = d5 = dArray[j] + d2 * d5;
                environment.setVariable(context, stringVector.getElementAsString(i), (SEXP)new DoubleArrayVector(dArrayArray[i]));
                DoubleVector doubleVector2 = (DoubleVector)context.evaluate(sEXP, environment);
                for (int k = 0; k < sEXP2.length(); ++k) {
                    if (!DoubleVector.isFinite((double)doubleVector2.getElementAsDouble(k))) {
                        throw new EvalException("Missing value or an infinity produced when evaluating the model", new Object[0]);
                    }
                    string.set(k, n, d2 * ((doubleVector2.getElementAsDouble(k) - sEXP2.getElementAsDouble(k)) / d4));
                }
                dArrayArray[i][j] = d3;
                ++n;
            }
            environment.setVariable(context, stringVector.getElementAsString(i), (SEXP)new DoubleArrayVector(dArrayArray[i]));
        }
        return sEXP2.setAttribute(Symbol.get((String)"gradient"), (SEXP)string.build());
    }

    private static final class StopReason
    extends Enum<StopReason> {
        public static final /* enum */ StopReason CONVERGED = new StopReason();
        public static final /* enum */ StopReason SINGULAR_GRADIENT = new StopReason();
        public static final /* enum */ StopReason MIN_FACTOR_REACHED = new StopReason();
        public static final /* enum */ StopReason MAX_ITERATIONS_EXCEEDED = new StopReason();
        private static final /* synthetic */ StopReason[] $VALUES;

        static {
            StopReason[] stopReasonArray = new StopReason[]{CONVERGED, SINGULAR_GRADIENT, MIN_FACTOR_REACHED, MAX_ITERATIONS_EXCEEDED};
            $VALUES = stopReasonArray;
        }

        public static StopReason valueOf(String string) {
            return Enum.valueOf(StopReason.class, string);
        }

        public static StopReason[] values() {
            return (StopReason[])$VALUES.clone();
        }
    }
}

