/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.dist;

import org.renjin.invoke.annotations.Operand;
import org.renjin.primitives.vector.DeferredComputation;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class Euclidean1dDistanceMatrix
extends DoubleVector
implements DeferredComputation {
    @Operand
    private Vector vector;
    private int size;
    private int length;

    public Euclidean1dDistanceMatrix(Vector vector, AttributeMap attributeMap) {
        super(attributeMap);
        this.vector = vector;
        this.size = vector.length();
        this.length = this.size * this.size;
    }

    public Euclidean1dDistanceMatrix(Vector vector) {
        this(vector, AttributeMap.dim((int)vector.length(), (int)vector.length()));
    }

    protected SEXP cloneWithNewAttributes(AttributeMap attributeMap) {
        return new Euclidean1dDistanceMatrix(this.vector, attributeMap);
    }

    public String getComputationName() {
        return "dist";
    }

    public double getElementAsDouble(int n) {
        int n2 = this.vector.length();
        if ((n %= n2) == (n2 = n / n2)) {
            return 0.0;
        }
        return Math.abs(this.getOperandElementAsDouble(n) - this.getOperandElementAsDouble(n2));
    }

    private double getOperandElementAsDouble(int n) {
        return this.vector.getElementAsDouble(n);
    }

    private int getOperandLength() {
        return this.vector.length();
    }

    public Vector[] getOperands() {
        return new Vector[]{this.vector};
    }

    public boolean isConstantAccessTime() {
        return false;
    }

    public boolean isDeferred() {
        return true;
    }

    public int length() {
        return this.getOperandLength() * this.getOperandLength();
    }

    public static double test(int n, int n2) {
        return Math.sqrt(n % n2);
    }
}

