/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.dist;

import org.renjin.primitives.vector.DeferredComputation;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class Euclidean1dDistanceTriangle
extends DoubleVector
implements DeferredComputation {
    private Vector vector;
    private int length;
    private int size;

    public Euclidean1dDistanceTriangle(Vector vector, AttributeMap attributeMap) {
        super(attributeMap);
        this.vector = vector;
        this.size = vector.length();
        this.length = this.size * (this.size - 1) / 2;
    }

    protected SEXP cloneWithNewAttributes(AttributeMap attributeMap) {
        return new Euclidean1dDistanceTriangle(this.vector, attributeMap);
    }

    public String getComputationName() {
        return "dist";
    }

    public double getElementAsDouble(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4;
        while (n >= n2 + (n4 = this.size - n3 - 1)) {
            n2 += n4;
            ++n3;
        }
        return Math.abs(this.vector.getElementAsDouble(n3 + 1 + (n - n2)) - this.vector.getElementAsDouble(n3));
    }

    public Vector[] getOperands() {
        return new Vector[]{this.vector};
    }

    public Vector getVector() {
        return this.vector;
    }

    public boolean isConstantAccessTime() {
        return this.vector.isConstantAccessTime();
    }

    public boolean isDeferred() {
        return true;
    }

    public int length() {
        return this.length;
    }
}

