/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.MixedPtr;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gnur.api.Arith;
import org.renjin.gnur.api.Error;
import org.renjin.gnur.api.GetText;
import org.renjin.gnur.api.Rinternals;
import org.renjin.gnur.api.Rinternals2;
import org.renjin.sexp.SEXP;

public class approx__ {
    private approx__() {
    }

    public static SEXP Approx(SEXP x, SEXP y, SEXP v, SEXP method, SEXP yleft, SEXP yright, SEXP sf) {
        SEXP xout = Rinternals.Rf_protect((SEXP)Rinternals.Rf_coerceVector((SEXP)v, (int)14));
        int nx = Rinternals.XLENGTH((SEXP)x);
        int nout = Rinternals.XLENGTH((SEXP)xout);
        SEXP yout = Rinternals.Rf_protect((SEXP)Rinternals.Rf_allocVector((int)14, (int)nout));
        double d = Rinternals.Rf_asReal((SEXP)sf);
        double d2 = Rinternals.Rf_asReal((SEXP)yright);
        double d3 = Rinternals.Rf_asReal((SEXP)yleft);
        int n = Rinternals.Rf_asInteger((SEXP)method);
        Ptr ptr = Rinternals2.REAL((SEXP)yout);
        Ptr ptr2 = Rinternals2.REAL((SEXP)xout);
        Ptr ptr3 = Rinternals2.REAL((SEXP)y);
        approx__.R_approxfun(Rinternals2.REAL((SEXP)x), ptr3, nx, ptr2, ptr, nout, n, d3, d2, d);
        Rinternals.Rf_unprotect((int)2);
        return yout;
    }

    public static SEXP ApproxTest(SEXP x, SEXP y, SEXP method, SEXP sf) {
        int nx = Rinternals.XLENGTH((SEXP)x);
        int m = Rinternals.Rf_asInteger((SEXP)method);
        double f = Rinternals.Rf_asReal((SEXP)sf);
        Ptr ptr = Rinternals2.REAL((SEXP)y);
        approx__.R_approxtest(Rinternals2.REAL((SEXP)x), ptr, nx, m, f);
        return Rinternals.R_NilValue;
    }

    public static void R_approxfun(Ptr x, Ptr y, int nxy, Ptr xout, Ptr yout, int nout, int method, double yleft, double yright, double f) {
        MixedPtr M = MixedPtr.malloc((int)36);
        M.setDouble(0.0);
        M.setAlignedDouble(1, 0.0);
        M.setAlignedDouble(2, 0.0);
        M.setAlignedDouble(3, 0.0);
        M.setAlignedInt(8, 0);
        M.setAlignedDouble(3, f);
        double d = 1.0 - f;
        M.setAlignedDouble(2, d);
        M.setAlignedInt(8, method);
        M.setDouble(yleft);
        M.setAlignedDouble(1, yright);
        int i = 0;
        while (i < nout) {
            double iftmp$1;
            int n = i * 8;
            Ptr ptr = yout;
            int n2 = n;
            Ptr ptr2 = xout;
            int n3 = i * 8;
            int n4 = n3;
            if (Builtins.__isnan((double)ptr2.getDouble(n4)) != 0) {
                int n5 = i * 8;
                Ptr ptr3 = xout;
                int n6 = n5;
                iftmp$1 = ptr3.getDouble(n6);
            } else {
                int n7 = i * 8;
                Ptr ptr4 = xout;
                int n8 = n7;
                iftmp$1 = approx__.approx1(ptr4.getDouble(n8), x, y, nxy, (Ptr)M);
            }
            ptr.setDouble(n2, iftmp$1);
            ++i;
        }
    }

    public static void R_approxtest(Ptr x, Ptr y, int nxy, int method, double f) {
        switch (method) {
            case 1: {
                break;
            }
            case 2: {
                if (Builtins.__finite((double)f) != 0 && !(f < 0.0) && !(f > 1.0)) break;
                Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("stats\u0000".getBytes(), 0), (BytePtr)new BytePtr("approx(): invalid f value\u0000".getBytes(), 0)), (Object[])new Object[0]);
                break;
            }
            default: {
                Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("stats\u0000".getBytes(), 0), (BytePtr)new BytePtr("approx(): invalid interpolation method\u0000".getBytes(), 0)), (Object[])new Object[0]);
            }
        }
        int i = 0;
        while (i < nxy) {
            int n;
            int n2;
            Ptr ptr;
            Ptr ptr2 = x;
            int n3 = i * 8;
            int n4 = n3;
            if (Builtins.__isnan((double)ptr2.getDouble(n4)) != 0 || Builtins.__isnan((double)(ptr = y).getDouble(n2 = (n = i * 8))) != 0) {
                Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("stats\u0000".getBytes(), 0), (BytePtr)new BytePtr("approx(): attempted to interpolate NA values\u0000".getBytes(), 0)), (Object[])new Object[0]);
            }
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double approx1(double v, Ptr x, Ptr y, int n, Ptr Meth) {
        double iftmp$22;
        double iftmp$20;
        int j = 0;
        int i = 0;
        if (n == 0) return Arith.R_NaN;
        i = 0;
        j = n + -1;
        int n2 = i * 8;
        Ptr ptr = x;
        int n3 = n2;
        if (ptr.getDouble(n3) > v) return Meth.getDouble();
        int n4 = j * 8;
        Ptr ptr2 = x;
        int n5 = n4;
        if (ptr2.getDouble(n5) < v) return Meth.getAlignedDouble(1);
        while (j + -1 > i) {
            Ptr ptr3 = x;
            int ij = (i + j) / 2;
            int n6 = ij * 8;
            int n7 = n6;
            if (ptr3.getDouble(n7) > v) {
                j = ij;
                continue;
            }
            i = ij;
        }
        Ptr ptr4 = x;
        int n8 = j * 8;
        int n9 = n8;
        if (ptr4.getDouble(n9) == v) {
            int n10 = j * 8;
            Ptr ptr5 = y;
            int n11 = n10;
            return ptr5.getDouble(n11);
        }
        int n12 = i * 8;
        Ptr ptr6 = x;
        int n13 = n12;
        if (ptr6.getDouble(n13) == v) {
            int n14 = i * 8;
            Ptr ptr7 = y;
            int n15 = n14;
            return ptr7.getDouble(n15);
        }
        if (Meth.getAlignedInt(8) == 1) {
            int n16 = i * 8;
            Ptr ptr8 = y;
            int n17 = n16;
            double d = ptr8.getDouble(n17);
            int n18 = j * 8;
            Ptr ptr9 = y;
            int n19 = n18;
            double d2 = ptr9.getDouble(n19);
            int n20 = i * 8;
            Ptr ptr10 = y;
            int n21 = n20;
            double d3 = ptr10.getDouble(n21);
            double d4 = d2 - d3;
            int n22 = i * 8;
            Ptr ptr11 = x;
            int n23 = n22;
            double d5 = ptr11.getDouble(n23);
            double d6 = v - d5;
            int n24 = j * 8;
            Ptr ptr12 = x;
            int n25 = n24;
            double d7 = ptr12.getDouble(n25);
            int n26 = i * 8;
            Ptr ptr13 = x;
            int n27 = n26;
            double d8 = ptr13.getDouble(n27);
            double d9 = d7 - d8;
            double d10 = d6 / d9;
            double d11 = d4 * d10;
            return d + d11;
        }
        if (Meth.getAlignedDouble(2) != 0.0) {
            int n28 = i * 8;
            Ptr ptr14 = y;
            int n29 = n28;
            double d = ptr14.getDouble(n29);
            double d12 = Meth.getAlignedDouble(2);
            iftmp$20 = d * d12;
        } else {
            iftmp$20 = 0.0;
        }
        if (Meth.getAlignedDouble(3) != 0.0) {
            int n30 = j * 8;
            Ptr ptr15 = y;
            int n31 = n30;
            double d = ptr15.getDouble(n31);
            double d13 = Meth.getAlignedDouble(3);
            iftmp$22 = d * d13;
            return iftmp$20 + iftmp$22;
        } else {
            iftmp$22 = 0.0;
        }
        return iftmp$20 + iftmp$22;
    }
}

