/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats;

import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gnur.api.Error;
import org.renjin.gnur.api.GetText;
import org.renjin.gnur.api.Rinternals;
import org.renjin.gnur.api.Rinternals2;
import org.renjin.sexp.SEXP;

public class family__ {
    public static double INVEPS = 4.503599627370496E15;
    public static double MTHRESH = -30.0;
    public static double THRESH = 30.0;

    private family__() {
    }

    public static SEXP binomial_dev_resids(SEXP y, SEXP mu, SEXP wt) {
        Ptr rans = BytePtr.of((int)0);
        int rans$offset = 0;
        Ptr rwt = BytePtr.of((int)0);
        int rwt$offset = 0;
        Ptr ry = BytePtr.of((int)0);
        int ry$offset = 0;
        Ptr rmu = BytePtr.of((int)0);
        int rmu$offset = 0;
        double mui = 0.0;
        SEXP ans = (SEXP)BytePtr.of((int)0).getArray();
        int nprot = 0;
        int lwt = 0;
        int n = 0;
        n = Rinternals.LENGTH((SEXP)y);
        int lmu = Rinternals.LENGTH((SEXP)mu);
        lwt = Rinternals.LENGTH((SEXP)wt);
        nprot = 1;
        if (!Rinternals.Rf_isReal((SEXP)y)) {
            y = Rinternals.Rf_protect((SEXP)Rinternals.Rf_coerceVector((SEXP)y, (int)14));
            ++nprot;
        }
        ry = Rinternals2.REAL((SEXP)y);
        ry$offset = 0;
        ans = Rinternals.Rf_protect((SEXP)Rinternals.Rf_shallow_duplicate((SEXP)y));
        rans = Rinternals2.REAL((SEXP)ans);
        rans$offset = 0;
        if (!Rinternals.Rf_isReal((SEXP)mu)) {
            mu = Rinternals.Rf_protect((SEXP)Rinternals.Rf_coerceVector((SEXP)mu, (int)14));
            ++nprot;
        }
        if (!Rinternals.Rf_isReal((SEXP)wt)) {
            wt = Rinternals.Rf_protect((SEXP)Rinternals.Rf_coerceVector((SEXP)wt, (int)14));
            ++nprot;
        }
        rmu = Rinternals2.REAL((SEXP)mu);
        rmu$offset = 0;
        rwt = Rinternals2.REAL((SEXP)wt);
        rwt$offset = 0;
        if (lmu != n && lmu != 1) {
            Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("stats\u0000".getBytes(), 0), (BytePtr)new BytePtr("argument %s must be a numeric vector of length 1 or length %d\u0000".getBytes(), 0)), (Object[])new Object[]{new BytePtr("mu\u0000".getBytes(), 0), n});
        }
        if (lwt != n && lwt != 1) {
            Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("stats\u0000".getBytes(), 0), (BytePtr)new BytePtr("argument %s must be a numeric vector of length 1 or length %d\u0000".getBytes(), 0)), (Object[])new Object[]{new BytePtr("wt\u0000".getBytes(), 0), n});
        }
        if (lmu > 1) {
            int i = 0;
            while (i < n) {
                int n2 = i * 8;
                Ptr ptr = rmu;
                int n3 = rmu$offset + n2;
                mui = ptr.getDouble(n3);
                int n4 = i * 8;
                Ptr ptr2 = ry;
                int n5 = ry$offset + n4;
                double yi = ptr2.getDouble(n5);
                int n6 = i * 8;
                Ptr ptr3 = rans;
                int n7 = rans$offset + n6;
                int iftmp$3 = lwt > 1 ? i * 8 : 0;
                Ptr ptr4 = rwt;
                int n8 = rwt$offset + iftmp$3;
                double d = ptr4.getDouble(n8) * 2.0;
                double d2 = family__.y_log_y(yi, mui);
                double d3 = 1.0 - mui;
                double d4 = family__.y_log_y(1.0 - yi, d3);
                double d5 = d2 + d4;
                double d6 = d * d5;
                ptr3.setDouble(n7, d6);
                ++i;
            }
        } else {
            mui = rmu.getDouble(rmu$offset);
            int i = 0;
            while (i < n) {
                int n9 = i * 8;
                Ptr ptr = ry;
                int n10 = ry$offset + n9;
                double yi = ptr.getDouble(n10);
                int n11 = i * 8;
                Ptr ptr5 = rans;
                int n12 = rans$offset + n11;
                int iftmp$7 = lwt > 1 ? i * 8 : 0;
                Ptr ptr6 = rwt;
                int n13 = rwt$offset + iftmp$7;
                double d = ptr6.getDouble(n13) * 2.0;
                double d7 = family__.y_log_y(yi, mui);
                double d8 = 1.0 - mui;
                double d9 = family__.y_log_y(1.0 - yi, d8);
                double d10 = d7 + d9;
                double d11 = d * d10;
                ptr5.setDouble(n12, d11);
                ++i;
            }
        }
        Rinternals.Rf_unprotect((int)nprot);
        return ans;
    }

    public static double y_log_y(double y, double mu) {
        double iftmp$9 = y != 0.0 ? Math.log(y / mu) * y : 0.0;
        return iftmp$9;
    }

    public static SEXP logit_mu_eta(SEXP eta) {
        Ptr reta = BytePtr.of((int)0);
        int reta$offset = 0;
        Ptr rans = BytePtr.of((int)0);
        int rans$offset = 0;
        int n = 0;
        SEXP ans = (SEXP)BytePtr.of((int)0).getArray();
        ans = Rinternals.Rf_protect((SEXP)Rinternals.Rf_shallow_duplicate((SEXP)eta));
        n = Rinternals.LENGTH((SEXP)eta);
        rans = Rinternals2.REAL((SEXP)ans);
        rans$offset = 0;
        reta = Rinternals2.REAL((SEXP)eta);
        reta$offset = 0;
        if (n == 0 || !Rinternals.Rf_isReal((SEXP)eta)) {
            Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("stats\u0000".getBytes(), 0), (BytePtr)new BytePtr("Argument %s must be a nonempty numeric vector\u0000".getBytes(), 0)), (Object[])new Object[]{new BytePtr("eta\u0000".getBytes(), 0)});
        }
        int i = 0;
        while (i < n) {
            double iftmp$12;
            double MTHRESH$14;
            int n2 = i * 8;
            Ptr ptr = reta;
            int n3 = reta$offset + n2;
            double etai = ptr.getDouble(n3);
            double opexp = Math.exp(etai) + 1.0;
            int n4 = i * 8;
            Ptr ptr2 = rans;
            int n5 = rans$offset + n4;
            double THRESH$13 = THRESH;
            if (etai > THRESH$13 ^ true && etai < (MTHRESH$14 = MTHRESH) ^ true) {
                double d = Math.exp(etai);
                double d2 = opexp;
                double d3 = d2 * d2;
                iftmp$12 = d / d3;
            } else {
                iftmp$12 = 2.220446049250313E-16;
            }
            ptr2.setDouble(n5, iftmp$12);
            ++i;
        }
        Rinternals.Rf_unprotect((int)1);
        return ans;
    }

    public static SEXP logit_linkinv(SEXP eta) {
        Ptr reta = BytePtr.of((int)0);
        int reta$offset = 0;
        Ptr rans = BytePtr.of((int)0);
        int rans$offset = 0;
        int n = 0;
        SEXP ans = (SEXP)BytePtr.of((int)0).getArray();
        ans = Rinternals.Rf_protect((SEXP)Rinternals.Rf_shallow_duplicate((SEXP)eta));
        n = Rinternals.LENGTH((SEXP)eta);
        rans = Rinternals2.REAL((SEXP)ans);
        rans$offset = 0;
        reta = Rinternals2.REAL((SEXP)eta);
        reta$offset = 0;
        if (n == 0 || !Rinternals.Rf_isReal((SEXP)eta)) {
            Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("stats\u0000".getBytes(), 0), (BytePtr)new BytePtr("Argument %s must be a nonempty numeric vector\u0000".getBytes(), 0)), (Object[])new Object[]{new BytePtr("eta\u0000".getBytes(), 0)});
        }
        int i = 0;
        while (i < n) {
            double iftmp$16;
            double MTHRESH$17;
            Ptr ptr = reta;
            int n2 = i * 8;
            int n3 = reta$offset + n2;
            double etai = ptr.getDouble(n3);
            if (etai < (MTHRESH$17 = MTHRESH)) {
                iftmp$16 = 2.220446049250313E-16;
            } else {
                double THRESH$19 = THRESH;
                double iftmp$18 = etai > THRESH$19 ? INVEPS : Math.exp(etai);
                iftmp$16 = iftmp$18;
            }
            double tmp = iftmp$16;
            int n4 = i * 8;
            Ptr ptr2 = rans;
            int n5 = rans$offset + n4;
            double d = family__.x_d_opx(tmp);
            ptr2.setDouble(n5, d);
            ++i;
        }
        Rinternals.Rf_unprotect((int)1);
        return ans;
    }

    public static double x_d_opx(double x) {
        double d = x + 1.0;
        return x / d;
    }

    public static SEXP logit_link(SEXP mu) {
        Ptr rmu = BytePtr.of((int)0);
        int rmu$offset = 0;
        Ptr rans = BytePtr.of((int)0);
        int rans$offset = 0;
        SEXP ans = (SEXP)BytePtr.of((int)0).getArray();
        int n = 0;
        n = Rinternals.LENGTH((SEXP)mu);
        ans = Rinternals.Rf_protect((SEXP)Rinternals.Rf_shallow_duplicate((SEXP)mu));
        rans = Rinternals2.REAL((SEXP)ans);
        rans$offset = 0;
        rmu = Rinternals2.REAL((SEXP)mu);
        rmu$offset = 0;
        if (n == 0 || !Rinternals.Rf_isReal((SEXP)mu)) {
            Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("stats\u0000".getBytes(), 0), (BytePtr)new BytePtr("Argument %s must be a nonempty numeric vector\u0000".getBytes(), 0)), (Object[])new Object[]{new BytePtr("mu\u0000".getBytes(), 0)});
        }
        int i = 0;
        while (i < n) {
            int n2 = i * 8;
            Ptr ptr = rans;
            int n3 = rans$offset + n2;
            int n4 = i * 8;
            Ptr ptr2 = rmu;
            int n5 = rmu$offset + n4;
            double d = Math.log(family__.x_d_omx(ptr2.getDouble(n5)));
            ptr.setDouble(n3, d);
            ++i;
        }
        Rinternals.Rf_unprotect((int)1);
        return ans;
    }

    public static double x_d_omx(double x) {
        if (x < 0.0 || x > 1.0) {
            Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("stats\u0000".getBytes(), 0), (BytePtr)new BytePtr("Value %g out of range (0, 1)\u0000".getBytes(), 0)), (Object[])new Object[]{x});
        }
        double d = 1.0 - x;
        return x / d;
    }
}

