/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats;

import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gnur.api.Arith;
import org.renjin.gnur.api.Error;
import org.renjin.gnur.api.GetText;
import org.renjin.gnur.api.Print;
import org.renjin.gnur.api.Rinternals;
import org.renjin.gnur.api.Rinternals2;
import org.renjin.sexp.SEXP;

public class ksmooth__ {
    private ksmooth__() {
    }

    public static SEXP ksmooth(SEXP x, SEXP y, SEXP xp, SEXP skrn, SEXP sbw) {
        int krn = Rinternals.Rf_asInteger((SEXP)skrn);
        double bw = Rinternals.Rf_asReal((SEXP)sbw);
        x = Rinternals.Rf_protect((SEXP)Rinternals.Rf_coerceVector((SEXP)x, (int)14));
        y = Rinternals.Rf_protect((SEXP)Rinternals.Rf_coerceVector((SEXP)y, (int)14));
        xp = Rinternals.Rf_protect((SEXP)Rinternals.Rf_coerceVector((SEXP)xp, (int)14));
        int nx = Rinternals.XLENGTH((SEXP)x);
        int np = Rinternals.XLENGTH((SEXP)xp);
        SEXP yp = Rinternals.Rf_protect((SEXP)Rinternals.Rf_allocVector((int)14, (int)np));
        Ptr ptr = Rinternals2.REAL((SEXP)yp);
        Ptr ptr2 = Rinternals2.REAL((SEXP)xp);
        Ptr ptr3 = Rinternals2.REAL((SEXP)y);
        ksmooth__.BDRksmooth(Rinternals2.REAL((SEXP)x), ptr3, nx, ptr2, ptr, np, krn, bw);
        SEXP ans = Rinternals.Rf_protect((SEXP)Rinternals.Rf_allocVector((int)19, (int)2));
        Rinternals.SET_VECTOR_ELT((SEXP)ans, (int)0, (SEXP)xp);
        Rinternals.SET_VECTOR_ELT((SEXP)ans, (int)1, (SEXP)yp);
        SEXP nm = Rinternals.Rf_allocVector((int)16, (int)2);
        SEXP R_NamesSymbol$0 = Rinternals.R_NamesSymbol;
        Rinternals.Rf_setAttrib((SEXP)ans, (SEXP)R_NamesSymbol$0, (SEXP)nm);
        SEXP sEXP = Rinternals.Rf_mkChar((Ptr)((Ptr)new BytePtr("x\u0000".getBytes(), 0)));
        Rinternals.SET_STRING_ELT((SEXP)nm, (int)0, (SEXP)sEXP);
        SEXP sEXP2 = Rinternals.Rf_mkChar((Ptr)((Ptr)new BytePtr("y\u0000".getBytes(), 0)));
        Rinternals.SET_STRING_ELT((SEXP)nm, (int)1, (SEXP)sEXP2);
        Rinternals.Rf_unprotect((int)5);
        return ans;
    }

    public static void smoothprt_(Ptr span, Ptr iper, Ptr var, Ptr cvar) {
        double d = cvar.getDouble();
        double d2 = var.getDouble();
        int n = iper.getInt();
        double d3 = span.getDouble();
        Print.Rprintf((BytePtr)new BytePtr("smooth(span=%4g, iper=%+2d) -> (var, cvar) = (%g, %g)\n\u0000".getBytes(), 0), (Object[])new Object[]{d3, n, d2, d});
    }

    public static void splineprt_(Ptr df, Ptr gcvpen, Ptr ismethod, Ptr lambda, Ptr edf) {
        double d = edf.getDouble();
        double d2 = lambda.getDouble();
        int n = ismethod.getInt();
        double d3 = gcvpen.getDouble();
        double d4 = df.getDouble();
        Print.Rprintf((BytePtr)new BytePtr("spline(df=%5.3g, g.pen=%11.6g, ismeth.=%+2d) -> (lambda, edf) = (%.7g, %5.2f)\n\u0000".getBytes(), 0), (Object[])new Object[]{d4, d3, n, d2, d});
    }

    public static void bdrsplerr_() {
        Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("stats\u0000".getBytes(), 0), (BytePtr)new BytePtr("only 2500 rows are allowed for sm.method=\"spline\"\u0000".getBytes(), 0)), (Object[])new Object[0]);
    }

    public static void BDRksmooth(Ptr x, Ptr y, int n, Ptr xp, Ptr yp, int np, int kern, double bw) {
        double d;
        int n2;
        int n3;
        Ptr ptr;
        double d2;
        int j = 0;
        double x0 = 0.0;
        double den = 0.0;
        double num = 0.0;
        double cutoff = 0.0;
        int imin = 0;
        imin = 0;
        cutoff = 0.0;
        if (kern == 1) {
            cutoff = bw *= 0.5;
        }
        if (kern == 2) {
            cutoff = (bw *= 0.3706506) * 4.0;
        }
        while ((d2 = (ptr = x).getDouble(n3 = (n2 = imin * 8))) < (d = xp.getDouble() - cutoff) && imin < n) {
            ++imin;
        }
        j = 0;
        while (j < np) {
            num = den = 0.0;
            int n4 = j * 8;
            Ptr ptr2 = xp;
            int n5 = n4;
            x0 = ptr2.getDouble(n5);
            int i = imin;
            while (i < n) {
                double d3;
                Ptr ptr3 = x;
                int n6 = i * 8;
                int n7 = n6;
                double d4 = ptr3.getDouble(n7);
                if (d4 < (d3 = x0 - cutoff)) {
                    imin = i;
                } else {
                    int n8 = i * 8;
                    Ptr ptr4 = x;
                    int n9 = n8;
                    double d5 = ptr4.getDouble(n9);
                    double d6 = x0 + cutoff;
                    if (d5 > d6) break;
                    int n10 = i * 8;
                    Ptr ptr5 = x;
                    int n11 = n10;
                    double w = ksmooth__.dokern(Math.abs(ptr5.getDouble(n11) - x0) / bw, kern);
                    int n12 = i * 8;
                    Ptr ptr6 = y;
                    int n13 = n12;
                    num = ptr6.getDouble(n13) * w + num;
                    den += w;
                }
                ++i;
            }
            if (den > 0.0) {
                int n14 = j * 8;
                Ptr ptr7 = yp;
                int n15 = n14;
                double d7 = num / den;
                ptr7.setDouble(n15, d7);
            } else {
                int n16 = j * 8;
                Ptr ptr8 = yp;
                int n17 = n16;
                double R_NaReal$9 = Arith.R_NaReal;
                ptr8.setDouble(n17, R_NaReal$9);
            }
            ++j;
        }
    }

    public static double dokern(double x, int kern) {
        double d = kern == 1 ? 1.0 : (kern == 2 ? Math.exp(x * -0.5 * x) : 0.0);
        return d;
    }
}

