/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.nls;

import org.renjin.sexp.ListVector;

class NlsControl {
    private final int maxIter;
    private final double tolerance;
    private final double minFac;
    private final boolean warnOnly;
    private final boolean printEval;

    NlsControl(ListVector exp) {
        this.maxIter = exp.getElementAsInt("maxiter");
        this.tolerance = exp.getElementAsDouble("tol");
        this.minFac = exp.getElementAsDouble("minFactor");
        this.warnOnly = exp.getElementAsInt("warnOnly") == 1;
        this.printEval = exp.getElementAsInt("printEval") == 1;
    }

    public boolean isPrintEval() {
        return this.printEval;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public int getMaxIterations() {
        return this.maxIter;
    }

    public double getMinFactor() {
        return this.minFac;
    }

    public boolean isWarnOnly() {
        return this.warnOnly;
    }
}

